/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.IterableMap;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;

public class MultiKeyMap
implements Serializable,
IterableMap {
    private static final long serialVersionUID = -1788199231038721040L;
    protected final AbstractHashedMap map;

    public static MultiKeyMap decorate(AbstractHashedMap abstractHashedMap) {
        if (abstractHashedMap == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (abstractHashedMap.size() > 0) {
            throw new IllegalArgumentException("Map must be empty");
        }
        return new MultiKeyMap(abstractHashedMap);
    }

    public MultiKeyMap() {
        this.map = new HashedMap();
    }

    protected MultiKeyMap(AbstractHashedMap abstractHashedMap) {
        this.map = abstractHashedMap;
    }

    public Object get(Object object, Object object2) {
        int n = this.hash(object, object2);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object object, Object object2) {
        int n = this.hash(object, object2);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object object, Object object2, Object object3) {
        int n = this.hash(object, object2);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2)) {
                Object object4 = hashEntry.getValue();
                this.map.updateEntry(hashEntry, object3);
                return object4;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n2, n, new MultiKey(object, object2), object3);
        return null;
    }

    public Object remove(Object object, Object object2) {
        int n = this.hash(object, object2);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2)) {
                Object object3 = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n2, hashEntry2);
                return object3;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object object, Object object2) {
        int n = 0;
        if (object != null) {
            n ^= object.hashCode();
        }
        if (object2 != null) {
            n ^= object2.hashCode();
        }
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry hashEntry, Object object, Object object2) {
        MultiKey multiKey = (MultiKey)hashEntry.getKey();
        return multiKey.size() == 2 && (object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0))) && (object2 == null ? multiKey.getKey(1) == null : object2.equals(multiKey.getKey(1)));
    }

    public Object get(Object object, Object object2, Object object3) {
        int n = this.hash(object, object2, object3);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object object, Object object2, Object object3) {
        int n = this.hash(object, object2, object3);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object object, Object object2, Object object3, Object object4) {
        int n = this.hash(object, object2, object3);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3)) {
                Object object5 = hashEntry.getValue();
                this.map.updateEntry(hashEntry, object4);
                return object5;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n2, n, new MultiKey(object, object2, object3), object4);
        return null;
    }

    public Object remove(Object object, Object object2, Object object3) {
        int n = this.hash(object, object2, object3);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3)) {
                Object object4 = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n2, hashEntry2);
                return object4;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object object, Object object2, Object object3) {
        int n = 0;
        if (object != null) {
            n ^= object.hashCode();
        }
        if (object2 != null) {
            n ^= object2.hashCode();
        }
        if (object3 != null) {
            n ^= object3.hashCode();
        }
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry hashEntry, Object object, Object object2, Object object3) {
        MultiKey multiKey = (MultiKey)hashEntry.getKey();
        return multiKey.size() == 3 && (object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0))) && (object2 == null ? multiKey.getKey(1) == null : object2.equals(multiKey.getKey(1))) && (object3 == null ? multiKey.getKey(2) == null : object3.equals(multiKey.getKey(2)));
    }

    public Object get(Object object, Object object2, Object object3, Object object4) {
        int n = this.hash(object, object2, object3, object4);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object object, Object object2, Object object3, Object object4) {
        int n = this.hash(object, object2, object3, object4);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object object, Object object2, Object object3, Object object4, Object object5) {
        int n = this.hash(object, object2, object3, object4);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4)) {
                Object object6 = hashEntry.getValue();
                this.map.updateEntry(hashEntry, object5);
                return object6;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n2, n, new MultiKey(object, object2, object3, object4), object5);
        return null;
    }

    public Object remove(Object object, Object object2, Object object3, Object object4) {
        int n = this.hash(object, object2, object3, object4);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4)) {
                Object object5 = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n2, hashEntry2);
                return object5;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object object, Object object2, Object object3, Object object4) {
        int n = 0;
        if (object != null) {
            n ^= object.hashCode();
        }
        if (object2 != null) {
            n ^= object2.hashCode();
        }
        if (object3 != null) {
            n ^= object3.hashCode();
        }
        if (object4 != null) {
            n ^= object4.hashCode();
        }
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry hashEntry, Object object, Object object2, Object object3, Object object4) {
        MultiKey multiKey = (MultiKey)hashEntry.getKey();
        return multiKey.size() == 4 && (object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0))) && (object2 == null ? multiKey.getKey(1) == null : object2.equals(multiKey.getKey(1))) && (object3 == null ? multiKey.getKey(2) == null : object3.equals(multiKey.getKey(2))) && (object4 == null ? multiKey.getKey(3) == null : object4.equals(multiKey.getKey(3)));
    }

    public Object get(Object object, Object object2, Object object3, Object object4, Object object5) {
        int n = this.hash(object, object2, object3, object4, object5);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4, object5)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object object, Object object2, Object object3, Object object4, Object object5) {
        int n = this.hash(object, object2, object3, object4, object5);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[this.map.hashIndex(n, this.map.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4, object5)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        int n = this.hash(object, object2, object3, object4, object5);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4, object5)) {
                Object object7 = hashEntry.getValue();
                this.map.updateEntry(hashEntry, object6);
                return object7;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n2, n, new MultiKey(object, object2, object3, object4, object5), object6);
        return null;
    }

    public Object remove(Object object, Object object2, Object object3, Object object4, Object object5) {
        int n = this.hash(object, object2, object3, object4, object5);
        int n2 = this.map.hashIndex(n, this.map.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n2];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(hashEntry, object, object2, object3, object4, object5)) {
                Object object6 = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n2, hashEntry2);
                return object6;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object object, Object object2, Object object3, Object object4, Object object5) {
        int n = 0;
        if (object != null) {
            n ^= object.hashCode();
        }
        if (object2 != null) {
            n ^= object2.hashCode();
        }
        if (object3 != null) {
            n ^= object3.hashCode();
        }
        if (object4 != null) {
            n ^= object4.hashCode();
        }
        if (object5 != null) {
            n ^= object5.hashCode();
        }
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry hashEntry, Object object, Object object2, Object object3, Object object4, Object object5) {
        MultiKey multiKey = (MultiKey)hashEntry.getKey();
        return multiKey.size() == 5 && (object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0))) && (object2 == null ? multiKey.getKey(1) == null : object2.equals(multiKey.getKey(1))) && (object3 == null ? multiKey.getKey(2) == null : object3.equals(multiKey.getKey(2))) && (object4 == null ? multiKey.getKey(3) == null : object4.equals(multiKey.getKey(3))) && (object5 == null ? multiKey.getKey(4) == null : object5.equals(multiKey.getKey(4)));
    }

    public boolean removeAll(Object object) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() < 1 || !(object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Object object, Object object2) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() < 2 || !(object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0))) || !(object2 == null ? multiKey.getKey(1) == null : object2.equals(multiKey.getKey(1)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Object object, Object object2, Object object3) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() < 3 || !(object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0))) || !(object2 == null ? multiKey.getKey(1) == null : object2.equals(multiKey.getKey(1))) || !(object3 == null ? multiKey.getKey(2) == null : object3.equals(multiKey.getKey(2)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Object object, Object object2, Object object3, Object object4) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() < 4 || !(object == null ? multiKey.getKey(0) == null : object.equals(multiKey.getKey(0))) || !(object2 == null ? multiKey.getKey(1) == null : object2.equals(multiKey.getKey(1))) || !(object3 == null ? multiKey.getKey(2) == null : object3.equals(multiKey.getKey(2))) || !(object4 == null ? multiKey.getKey(3) == null : object4.equals(multiKey.getKey(3)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    protected void checkKey(Object object) {
        if (object == null) {
            throw new NullPointerException("Key must not be null");
        }
        if (!(object instanceof MultiKey)) {
            throw new ClassCastException("Key must be a MultiKey");
        }
    }

    public Object clone() {
        return new MultiKeyMap((AbstractHashedMap)this.map.clone());
    }

    public Object put(Object object, Object object2) {
        this.checkKey(object);
        return this.map.put(object, object2);
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.checkKey(k);
        }
        this.map.putAll(map);
    }

    public MapIterator mapIterator() {
        return this.map.mapIterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public Object get(Object object) {
        return this.map.get(object);
    }

    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return this.map.equals(object);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

