/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntry;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class ListOrderedMap
extends AbstractMapDecorator
implements Serializable,
OrderedMap {
    private static final long serialVersionUID = 2728177751851003750L;
    protected final List insertOrder = new ArrayList();

    public static OrderedMap decorate(Map map) {
        return new ListOrderedMap(map);
    }

    public ListOrderedMap() {
        this(new HashMap());
    }

    protected ListOrderedMap(Map map) {
        super(map);
        this.insertOrder.addAll(this.getMap().keySet());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    public MapIterator mapIterator() {
        return this.orderedMapIterator();
    }

    public OrderedMapIterator orderedMapIterator() {
        return new ListOrderedMapIterator(this);
    }

    public Object firstKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return this.insertOrder.get(0);
    }

    public Object lastKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return this.insertOrder.get(this.size() - 1);
    }

    public Object nextKey(Object object) {
        int n = this.insertOrder.indexOf(object);
        if (n >= 0 && n < this.size() - 1) {
            return this.insertOrder.get(n + 1);
        }
        return null;
    }

    public Object previousKey(Object object) {
        int n = this.insertOrder.indexOf(object);
        if (n > 0) {
            return this.insertOrder.get(n - 1);
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        if (this.getMap().containsKey(object)) {
            return this.getMap().put(object, object2);
        }
        Object object3 = this.getMap().put(object, object2);
        this.insertOrder.add(object);
        return object3;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Object v = this.getMap().remove(object);
        this.insertOrder.remove(object);
        return v;
    }

    public void clear() {
        this.getMap().clear();
        this.insertOrder.clear();
    }

    public Set keySet() {
        return new KeySetView(this);
    }

    public List keyList() {
        return UnmodifiableList.decorate(this.insertOrder);
    }

    public Collection values() {
        return new ValuesView(this);
    }

    public List valueList() {
        return new ValuesView(this);
    }

    public Set entrySet() {
        return new EntrySetView(this, this.insertOrder);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        boolean bl = true;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append((Object)(k == this ? "(this Map)" : k));
            stringBuffer.append('=');
            stringBuffer.append((Object)(v == this ? "(this Map)" : v));
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public Object get(int n) {
        return this.insertOrder.get(n);
    }

    public Object getValue(int n) {
        return this.get(this.insertOrder.get(n));
    }

    public int indexOf(Object object) {
        return this.insertOrder.indexOf(object);
    }

    public Object setValue(int n, Object object) {
        Object e = this.insertOrder.get(n);
        return this.put(e, object);
    }

    public Object put(int n, Object object, Object object2) {
        Map map = this.getMap();
        if (map.containsKey(object)) {
            Object v = map.remove(object);
            int n2 = this.insertOrder.indexOf(object);
            this.insertOrder.remove(n2);
            if (n2 < n) {
                --n;
            }
            this.insertOrder.add(n, object);
            map.put(object, object2);
            return v;
        }
        this.insertOrder.add(n, object);
        map.put(object, object2);
        return null;
    }

    public Object remove(int n) {
        return this.remove(this.get(n));
    }

    public List asList() {
        return this.keyList();
    }

    static class ListOrderedMapIterator
    implements OrderedMapIterator,
    ResettableIterator {
        private final ListOrderedMap parent;
        private ListIterator iterator;
        private Object last = null;
        private boolean readable = false;

        ListOrderedMapIterator(ListOrderedMap listOrderedMap) {
            this.parent = listOrderedMap;
            this.iterator = listOrderedMap.insertOrder.listIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = this.iterator.next();
            this.readable = true;
            return this.last;
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            this.last = this.iterator.previous();
            this.readable = true;
            return this.last;
        }

        public void remove() {
            if (!this.readable) {
                throw new IllegalStateException("remove() can only be called once after next()");
            }
            this.iterator.remove();
            this.parent.map.remove(this.last);
            this.readable = false;
        }

        public Object getKey() {
            if (!this.readable) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            return this.last;
        }

        public Object getValue() {
            if (!this.readable) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            return this.parent.get(this.last);
        }

        public Object setValue(Object object) {
            if (!this.readable) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            return this.parent.map.put(this.last, object);
        }

        public void reset() {
            this.iterator = this.parent.insertOrder.listIterator();
            this.last = null;
            this.readable = false;
        }

        public String toString() {
            if (this.readable) {
                return "Iterator[" + this.getKey() + "=" + this.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    static class ListOrderedMapEntry
    extends AbstractMapEntry {
        private final ListOrderedMap parent;

        ListOrderedMapEntry(ListOrderedMap listOrderedMap, Object object) {
            super(object, null);
            this.parent = listOrderedMap;
        }

        public Object getValue() {
            return this.parent.get(this.key);
        }

        public Object setValue(Object object) {
            return this.parent.getMap().put(this.key, object);
        }
    }

    static class ListOrderedIterator
    extends AbstractIteratorDecorator {
        private final ListOrderedMap parent;
        private Object last = null;

        ListOrderedIterator(ListOrderedMap listOrderedMap, List list) {
            super(list.iterator());
            this.parent = listOrderedMap;
        }

        public Object next() {
            this.last = super.next();
            return new ListOrderedMapEntry(this.parent, this.last);
        }

        public void remove() {
            super.remove();
            this.parent.getMap().remove(this.last);
        }
    }

    static class EntrySetView
    extends AbstractSet {
        private final ListOrderedMap parent;
        private final List insertOrder;
        private Set entrySet;

        public EntrySetView(ListOrderedMap listOrderedMap, List list) {
            this.parent = listOrderedMap;
            this.insertOrder = list;
        }

        private Set getEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = this.parent.getMap().entrySet();
            }
            return this.entrySet;
        }

        public int size() {
            return this.parent.size();
        }

        public boolean isEmpty() {
            return this.parent.isEmpty();
        }

        public boolean contains(Object object) {
            return this.getEntrySet().contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.getEntrySet().containsAll(collection);
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            if (this.getEntrySet().contains(object)) {
                Object k = ((Map.Entry)object).getKey();
                this.parent.remove(k);
                return true;
            }
            return false;
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return ((Object)this.getEntrySet()).equals(object);
        }

        public int hashCode() {
            return ((Object)this.getEntrySet()).hashCode();
        }

        public String toString() {
            return this.getEntrySet().toString();
        }

        public Iterator iterator() {
            return new ListOrderedIterator(this.parent, this.insertOrder);
        }
    }

    static class KeySetView
    extends AbstractSet {
        private final ListOrderedMap parent;

        KeySetView(ListOrderedMap listOrderedMap) {
            this.parent = listOrderedMap;
        }

        public int size() {
            return this.parent.size();
        }

        public boolean contains(Object object) {
            return this.parent.containsKey(object);
        }

        public void clear() {
            this.parent.clear();
        }

        public Iterator iterator() {
            return new AbstractIteratorDecorator(this, this.parent.entrySet().iterator()){
                private final KeySetView this$0;
                {
                    this.this$0 = keySetView;
                }

                public Object next() {
                    return ((Map.Entry)super.next()).getKey();
                }
            };
        }
    }

    static class ValuesView
    extends AbstractList {
        private final ListOrderedMap parent;

        ValuesView(ListOrderedMap listOrderedMap) {
            this.parent = listOrderedMap;
        }

        public int size() {
            return this.parent.size();
        }

        public boolean contains(Object object) {
            return this.parent.containsValue(object);
        }

        public void clear() {
            this.parent.clear();
        }

        public Iterator iterator() {
            return new AbstractIteratorDecorator(this, this.parent.entrySet().iterator()){
                private final ValuesView this$0;
                {
                    this.this$0 = valuesView;
                }

                public Object next() {
                    return ((Map.Entry)this.iterator.next()).getValue();
                }
            };
        }

        public Object get(int n) {
            return this.parent.getValue(n);
        }

        public Object set(int n, Object object) {
            return this.parent.setValue(n, object);
        }

        public Object remove(int n) {
            return this.parent.remove(n);
        }
    }
}

