/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.FactoryTransformer;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class LazyMap
extends AbstractMapDecorator
implements Serializable,
Map {
    private static final long serialVersionUID = 7990956402564206740L;
    protected final Transformer factory;

    public static Map decorate(Map map, Factory factory) {
        return new LazyMap(map, factory);
    }

    public static Map decorate(Map map, Transformer transformer) {
        return new LazyMap(map, transformer);
    }

    protected LazyMap(Map map, Factory factory) {
        super(map);
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = FactoryTransformer.getInstance(factory);
    }

    protected LazyMap(Map map, Transformer transformer) {
        super(map);
        if (transformer == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = transformer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    public Object get(Object object) {
        if (!this.map.containsKey(object)) {
            Object object2 = this.factory.transform(object);
            this.map.put(object, object2);
            return object2;
        }
        return this.map.get(object);
    }
}

