/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.BoundedMap;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.AbstractLinkedMap;

public class LRUMap
extends AbstractLinkedMap
implements Serializable,
Cloneable,
BoundedMap {
    private static final long serialVersionUID = -612114643488955218L;
    protected static final int DEFAULT_MAX_SIZE = 100;
    private transient int maxSize;
    private boolean scanUntilRemovable;

    public LRUMap() {
        this(100, 0.75f, false);
    }

    public LRUMap(int n) {
        this(n, 0.75f);
    }

    public LRUMap(int n, boolean bl) {
        this(n, 0.75f, bl);
    }

    public LRUMap(int n, float f) {
        this(n, f, false);
    }

    public LRUMap(int n, float f, boolean bl) {
        super(n < 1 ? 16 : n, f);
        if (n < 1) {
            throw new IllegalArgumentException("LRUMap max size must be greater than 0");
        }
        this.maxSize = n;
        this.scanUntilRemovable = bl;
    }

    public LRUMap(Map map) {
        this(map, false);
    }

    public LRUMap(Map map, boolean bl) {
        this(map.size(), 0.75f, bl);
        this.putAll(map);
    }

    public Object get(Object object) {
        AbstractLinkedMap.LinkEntry linkEntry = (AbstractLinkedMap.LinkEntry)this.getEntry(object);
        if (linkEntry == null) {
            return null;
        }
        this.moveToMRU(linkEntry);
        return linkEntry.getValue();
    }

    protected void moveToMRU(AbstractLinkedMap.LinkEntry linkEntry) {
        if (linkEntry.after != this.header) {
            ++this.modCount;
            linkEntry.before.after = linkEntry.after;
            linkEntry.after.before = linkEntry.before;
            linkEntry.after = this.header;
            linkEntry.before = this.header.before;
            this.header.before.after = linkEntry;
            this.header.before = linkEntry;
        } else if (linkEntry == this.header) {
            throw new IllegalStateException("Can't move header to MRU (please report this to commons-dev@jakarta.apache.org)");
        }
    }

    protected void updateEntry(AbstractHashedMap.HashEntry hashEntry, Object object) {
        this.moveToMRU((AbstractLinkedMap.LinkEntry)hashEntry);
        hashEntry.setValue(object);
    }

    protected void addMapping(int n, int n2, Object object, Object object2) {
        if (this.isFull()) {
            AbstractLinkedMap.LinkEntry linkEntry = this.header.after;
            boolean bl = false;
            if (this.scanUntilRemovable) {
                while (linkEntry != this.header && linkEntry != null) {
                    if (this.removeLRU(linkEntry)) {
                        bl = true;
                        break;
                    }
                    linkEntry = linkEntry.after;
                }
                if (linkEntry == null) {
                    throw new IllegalStateException("Entry.after=null, header.after" + this.header.after + " header.before" + this.header.before + " key=" + object + " value=" + object2 + " size=" + this.size + " maxSize=" + this.maxSize + " Please check that your keys are immutable, and that you have used synchronization properly." + " If so, then please report this to commons-dev@jakarta.apache.org as a bug.");
                }
            } else {
                bl = this.removeLRU(linkEntry);
            }
            if (bl) {
                if (linkEntry == null) {
                    throw new IllegalStateException("reuse=null, header.after=" + this.header.after + " header.before" + this.header.before + " key=" + object + " value=" + object2 + " size=" + this.size + " maxSize=" + this.maxSize + " Please check that your keys are immutable, and that you have used synchronization properly." + " If so, then please report this to commons-dev@jakarta.apache.org as a bug.");
                }
                this.reuseMapping(linkEntry, n, n2, object, object2);
            } else {
                super.addMapping(n, n2, object, object2);
            }
        } else {
            super.addMapping(n, n2, object, object2);
        }
    }

    protected void reuseMapping(AbstractLinkedMap.LinkEntry linkEntry, int n, int n2, Object object, Object object2) {
        try {
            int n3 = this.hashIndex(linkEntry.hashCode, this.data.length);
            AbstractHashedMap.HashEntry[] hashEntryArray = this.data;
            AbstractHashedMap.HashEntry hashEntry = hashEntryArray[n3];
            AbstractHashedMap.HashEntry hashEntry2 = null;
            while (hashEntry != linkEntry && hashEntry != null) {
                hashEntry2 = hashEntry;
                hashEntry = hashEntry.next;
            }
            if (hashEntry == null) {
                throw new IllegalStateException("Entry.next=null, data[removeIndex]=" + this.data[n3] + " previous=" + hashEntry2 + " key=" + object + " value=" + object2 + " size=" + this.size + " maxSize=" + this.maxSize + " Please check that your keys are immutable, and that you have used synchronization properly." + " If so, then please report this to commons-dev@jakarta.apache.org as a bug.");
            }
            ++this.modCount;
            this.removeEntry(linkEntry, n3, hashEntry2);
            this.reuseEntry(linkEntry, n, n2, object, object2);
            this.addEntry(linkEntry, n);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("NPE, entry=" + linkEntry + " entryIsHeader=" + (linkEntry == this.header) + " key=" + object + " value=" + object2 + " size=" + this.size + " maxSize=" + this.maxSize + " Please check that your keys are immutable, and that you have used synchronization properly." + " If so, then please report this to commons-dev@jakarta.apache.org as a bug.");
        }
    }

    protected boolean removeLRU(AbstractLinkedMap.LinkEntry linkEntry) {
        return true;
    }

    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public boolean isScanUntilRemovable() {
        return this.scanUntilRemovable;
    }

    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.doReadObject(objectInputStream);
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.maxSize);
        super.doWriteObject(objectOutputStream);
    }

    protected void doReadObject(ObjectInputStream objectInputStream) {
        this.maxSize = objectInputStream.readInt();
        super.doReadObject(objectInputStream);
    }
}

