/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.IterableMap;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.EmptyMapIterator;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;

public class Flat3Map
implements Serializable,
Cloneable,
IterableMap {
    private static final long serialVersionUID = -6701087419741928296L;
    private transient int size;
    private transient int hash1;
    private transient int hash2;
    private transient int hash3;
    private transient Object key1;
    private transient Object key2;
    private transient Object key3;
    private transient Object value1;
    private transient Object value2;
    private transient Object value3;
    private transient AbstractHashedMap delegateMap;

    public Flat3Map() {
    }

    public Flat3Map(Map map) {
        this.putAll(map);
    }

    public Object get(Object object) {
        if (this.delegateMap != null) {
            return this.delegateMap.get(object);
        }
        if (object == null) {
            switch (this.size) {
                case 3: {
                    if (this.key3 == null) {
                        return this.value3;
                    }
                }
                case 2: {
                    if (this.key2 == null) {
                        return this.value2;
                    }
                }
                case 1: {
                    if (this.key1 != null) break;
                    return this.value1;
                }
            }
        } else if (this.size > 0) {
            int n = object.hashCode();
            switch (this.size) {
                case 3: {
                    if (this.hash3 == n && object.equals(this.key3)) {
                        return this.value3;
                    }
                }
                case 2: {
                    if (this.hash2 == n && object.equals(this.key2)) {
                        return this.value2;
                    }
                }
                case 1: {
                    if (this.hash1 != n || !object.equals(this.key1)) break;
                    return this.value1;
                }
            }
        }
        return null;
    }

    public int size() {
        if (this.delegateMap != null) {
            return this.delegateMap.size();
        }
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object object) {
        if (this.delegateMap != null) {
            return this.delegateMap.containsKey(object);
        }
        if (object == null) {
            switch (this.size) {
                case 3: {
                    if (this.key3 == null) {
                        return true;
                    }
                }
                case 2: {
                    if (this.key2 == null) {
                        return true;
                    }
                }
                case 1: {
                    if (this.key1 != null) break;
                    return true;
                }
            }
        } else if (this.size > 0) {
            int n = object.hashCode();
            switch (this.size) {
                case 3: {
                    if (this.hash3 == n && object.equals(this.key3)) {
                        return true;
                    }
                }
                case 2: {
                    if (this.hash2 == n && object.equals(this.key2)) {
                        return true;
                    }
                }
                case 1: {
                    if (this.hash1 != n || !object.equals(this.key1)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        if (this.delegateMap != null) {
            return this.delegateMap.containsValue(object);
        }
        if (object == null) {
            switch (this.size) {
                case 3: {
                    if (this.value3 == null) {
                        return true;
                    }
                }
                case 2: {
                    if (this.value2 == null) {
                        return true;
                    }
                }
                case 1: {
                    if (this.value1 != null) break;
                    return true;
                }
            }
        } else {
            switch (this.size) {
                case 3: {
                    if (object.equals(this.value3)) {
                        return true;
                    }
                }
                case 2: {
                    if (object.equals(this.value2)) {
                        return true;
                    }
                }
                case 1: {
                    if (!object.equals(this.value1)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        if (this.delegateMap != null) {
            return this.delegateMap.put(object, object2);
        }
        if (object == null) {
            switch (this.size) {
                case 3: {
                    if (this.key3 == null) {
                        Object object3 = this.value3;
                        this.value3 = object2;
                        return object3;
                    }
                }
                case 2: {
                    if (this.key2 == null) {
                        Object object4 = this.value2;
                        this.value2 = object2;
                        return object4;
                    }
                }
                case 1: {
                    if (this.key1 != null) break;
                    Object object5 = this.value1;
                    this.value1 = object2;
                    return object5;
                }
            }
        } else if (this.size > 0) {
            int n = object.hashCode();
            switch (this.size) {
                case 3: {
                    if (this.hash3 == n && object.equals(this.key3)) {
                        Object object6 = this.value3;
                        this.value3 = object2;
                        return object6;
                    }
                }
                case 2: {
                    if (this.hash2 == n && object.equals(this.key2)) {
                        Object object7 = this.value2;
                        this.value2 = object2;
                        return object7;
                    }
                }
                case 1: {
                    if (this.hash1 != n || !object.equals(this.key1)) break;
                    Object object8 = this.value1;
                    this.value1 = object2;
                    return object8;
                }
            }
        }
        switch (this.size) {
            default: {
                this.convertToMap();
                this.delegateMap.put(object, object2);
                return null;
            }
            case 2: {
                this.hash3 = object == null ? 0 : object.hashCode();
                this.key3 = object;
                this.value3 = object2;
                break;
            }
            case 1: {
                this.hash2 = object == null ? 0 : object.hashCode();
                this.key2 = object;
                this.value2 = object2;
                break;
            }
            case 0: {
                this.hash1 = object == null ? 0 : object.hashCode();
                this.key1 = object;
                this.value1 = object2;
            }
        }
        ++this.size;
        return null;
    }

    public void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (this.delegateMap != null) {
            this.delegateMap.putAll(map);
            return;
        }
        if (n < 4) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.convertToMap();
            this.delegateMap.putAll(map);
        }
    }

    private void convertToMap() {
        this.delegateMap = this.createDelegateMap();
        switch (this.size) {
            case 3: {
                this.delegateMap.put(this.key3, this.value3);
            }
            case 2: {
                this.delegateMap.put(this.key2, this.value2);
            }
            case 1: {
                this.delegateMap.put(this.key1, this.value1);
            }
        }
        this.size = 0;
        this.hash3 = 0;
        this.hash2 = 0;
        this.hash1 = 0;
        this.key3 = null;
        this.key2 = null;
        this.key1 = null;
        this.value3 = null;
        this.value2 = null;
        this.value1 = null;
    }

    protected AbstractHashedMap createDelegateMap() {
        return new HashedMap();
    }

    public Object remove(Object object) {
        if (this.delegateMap != null) {
            return this.delegateMap.remove(object);
        }
        if (this.size == 0) {
            return null;
        }
        if (object == null) {
            switch (this.size) {
                case 3: {
                    if (this.key3 == null) {
                        Object object2 = this.value3;
                        this.hash3 = 0;
                        this.key3 = null;
                        this.value3 = null;
                        this.size = 2;
                        return object2;
                    }
                    if (this.key2 == null) {
                        Object object3 = this.value3;
                        this.hash2 = this.hash3;
                        this.key2 = this.key3;
                        this.value2 = this.value3;
                        this.hash3 = 0;
                        this.key3 = null;
                        this.value3 = null;
                        this.size = 2;
                        return object3;
                    }
                    if (this.key1 == null) {
                        Object object4 = this.value3;
                        this.hash1 = this.hash3;
                        this.key1 = this.key3;
                        this.value1 = this.value3;
                        this.hash3 = 0;
                        this.key3 = null;
                        this.value3 = null;
                        this.size = 2;
                        return object4;
                    }
                    return null;
                }
                case 2: {
                    if (this.key2 == null) {
                        Object object5 = this.value2;
                        this.hash2 = 0;
                        this.key2 = null;
                        this.value2 = null;
                        this.size = 1;
                        return object5;
                    }
                    if (this.key1 == null) {
                        Object object6 = this.value2;
                        this.hash1 = this.hash2;
                        this.key1 = this.key2;
                        this.value1 = this.value2;
                        this.hash2 = 0;
                        this.key2 = null;
                        this.value2 = null;
                        this.size = 1;
                        return object6;
                    }
                    return null;
                }
                case 1: {
                    if (this.key1 != null) break;
                    Object object7 = this.value1;
                    this.hash1 = 0;
                    this.key1 = null;
                    this.value1 = null;
                    this.size = 0;
                    return object7;
                }
            }
        } else if (this.size > 0) {
            int n = object.hashCode();
            switch (this.size) {
                case 3: {
                    if (this.hash3 == n && object.equals(this.key3)) {
                        Object object8 = this.value3;
                        this.hash3 = 0;
                        this.key3 = null;
                        this.value3 = null;
                        this.size = 2;
                        return object8;
                    }
                    if (this.hash2 == n && object.equals(this.key2)) {
                        Object object9 = this.value3;
                        this.hash2 = this.hash3;
                        this.key2 = this.key3;
                        this.value2 = this.value3;
                        this.hash3 = 0;
                        this.key3 = null;
                        this.value3 = null;
                        this.size = 2;
                        return object9;
                    }
                    if (this.hash1 == n && object.equals(this.key1)) {
                        Object object10 = this.value3;
                        this.hash1 = this.hash3;
                        this.key1 = this.key3;
                        this.value1 = this.value3;
                        this.hash3 = 0;
                        this.key3 = null;
                        this.value3 = null;
                        this.size = 2;
                        return object10;
                    }
                    return null;
                }
                case 2: {
                    if (this.hash2 == n && object.equals(this.key2)) {
                        Object object11 = this.value2;
                        this.hash2 = 0;
                        this.key2 = null;
                        this.value2 = null;
                        this.size = 1;
                        return object11;
                    }
                    if (this.hash1 == n && object.equals(this.key1)) {
                        Object object12 = this.value2;
                        this.hash1 = this.hash2;
                        this.key1 = this.key2;
                        this.value1 = this.value2;
                        this.hash2 = 0;
                        this.key2 = null;
                        this.value2 = null;
                        this.size = 1;
                        return object12;
                    }
                    return null;
                }
                case 1: {
                    if (this.hash1 != n || !object.equals(this.key1)) break;
                    Object object13 = this.value1;
                    this.hash1 = 0;
                    this.key1 = null;
                    this.value1 = null;
                    this.size = 0;
                    return object13;
                }
            }
        }
        return null;
    }

    public void clear() {
        if (this.delegateMap != null) {
            this.delegateMap.clear();
            this.delegateMap = null;
        } else {
            this.size = 0;
            this.hash3 = 0;
            this.hash2 = 0;
            this.hash1 = 0;
            this.key3 = null;
            this.key2 = null;
            this.key1 = null;
            this.value3 = null;
            this.value2 = null;
            this.value1 = null;
        }
    }

    public MapIterator mapIterator() {
        if (this.delegateMap != null) {
            return this.delegateMap.mapIterator();
        }
        if (this.size == 0) {
            return EmptyMapIterator.INSTANCE;
        }
        return new FlatMapIterator(this);
    }

    public Set entrySet() {
        if (this.delegateMap != null) {
            return this.delegateMap.entrySet();
        }
        return new EntrySet(this);
    }

    public Set keySet() {
        if (this.delegateMap != null) {
            return this.delegateMap.keySet();
        }
        return new KeySet(this);
    }

    public Collection values() {
        if (this.delegateMap != null) {
            return this.delegateMap.values();
        }
        return new Values(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            objectOutputStream.writeObject(mapIterator.next());
            objectOutputStream.writeObject(mapIterator.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 3) {
            this.delegateMap = this.createDelegateMap();
        }
        for (int i = n; i > 0; --i) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    public Object clone() {
        try {
            Flat3Map flat3Map = (Flat3Map)super.clone();
            if (flat3Map.delegateMap != null) {
                flat3Map.delegateMap = (HashedMap)flat3Map.delegateMap.clone();
            }
            return flat3Map;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (this.delegateMap != null) {
            return this.delegateMap.equals(object);
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        if (this.size > 0) {
            Object var3_3 = null;
            switch (this.size) {
                case 3: {
                    if (!map.containsKey(this.key3)) {
                        return false;
                    }
                    var3_3 = map.get(this.key3);
                    if (this.value3 == null ? var3_3 != null : !this.value3.equals(var3_3)) {
                        return false;
                    }
                }
                case 2: {
                    if (!map.containsKey(this.key2)) {
                        return false;
                    }
                    var3_3 = map.get(this.key2);
                    if (this.value2 == null ? var3_3 != null : !this.value2.equals(var3_3)) {
                        return false;
                    }
                }
                case 1: {
                    if (!map.containsKey(this.key1)) {
                        return false;
                    }
                    var3_3 = map.get(this.key1);
                    if (!(this.value1 == null ? var3_3 != null : !this.value1.equals(var3_3))) break;
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.delegateMap != null) {
            return this.delegateMap.hashCode();
        }
        int n = 0;
        switch (this.size) {
            case 3: {
                n += this.hash3 ^ (this.value3 == null ? 0 : this.value3.hashCode());
            }
            case 2: {
                n += this.hash2 ^ (this.value2 == null ? 0 : this.value2.hashCode());
            }
            case 1: {
                n += this.hash1 ^ (this.value1 == null ? 0 : this.value1.hashCode());
            }
        }
        return n;
    }

    public String toString() {
        if (this.delegateMap != null) {
            return this.delegateMap.toString();
        }
        if (this.size == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append('{');
        switch (this.size) {
            case 3: {
                stringBuffer.append(this.key3 == this ? "(this Map)" : this.key3);
                stringBuffer.append('=');
                stringBuffer.append(this.value3 == this ? "(this Map)" : this.value3);
                stringBuffer.append(',');
            }
            case 2: {
                stringBuffer.append(this.key2 == this ? "(this Map)" : this.key2);
                stringBuffer.append('=');
                stringBuffer.append(this.value2 == this ? "(this Map)" : this.value2);
                stringBuffer.append(',');
            }
            case 1: {
                stringBuffer.append(this.key1 == this ? "(this Map)" : this.key1);
                stringBuffer.append('=');
                stringBuffer.append(this.value1 == this ? "(this Map)" : this.value1);
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static int access$000(Flat3Map flat3Map) {
        return flat3Map.size;
    }

    static Object access$100(Flat3Map flat3Map) {
        return flat3Map.key3;
    }

    static Object access$200(Flat3Map flat3Map) {
        return flat3Map.key2;
    }

    static Object access$300(Flat3Map flat3Map) {
        return flat3Map.key1;
    }

    static Object access$400(Flat3Map flat3Map) {
        return flat3Map.value3;
    }

    static Object access$500(Flat3Map flat3Map) {
        return flat3Map.value2;
    }

    static Object access$600(Flat3Map flat3Map) {
        return flat3Map.value1;
    }

    static Object access$402(Flat3Map flat3Map, Object object) {
        flat3Map.value3 = object;
        return flat3Map.value3;
    }

    static Object access$502(Flat3Map flat3Map, Object object) {
        flat3Map.value2 = object;
        return flat3Map.value2;
    }

    static Object access$602(Flat3Map flat3Map, Object object) {
        flat3Map.value1 = object;
        return flat3Map.value1;
    }

    static AbstractHashedMap access$700(Flat3Map flat3Map) {
        return flat3Map.delegateMap;
    }

    static class ValuesIterator
    extends EntrySetIterator {
        ValuesIterator(Flat3Map flat3Map) {
            super(flat3Map);
        }

        public Object next() {
            super.next();
            return this.getValue();
        }
    }

    static class Values
    extends AbstractCollection {
        private final Flat3Map parent;

        Values(Flat3Map flat3Map) {
            this.parent = flat3Map;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object object) {
            return this.parent.containsValue(object);
        }

        public Iterator iterator() {
            if (Flat3Map.access$700(this.parent) != null) {
                return Flat3Map.access$700(this.parent).values().iterator();
            }
            if (this.parent.size() == 0) {
                return EmptyIterator.INSTANCE;
            }
            return new ValuesIterator(this.parent);
        }
    }

    static class KeySetIterator
    extends EntrySetIterator {
        KeySetIterator(Flat3Map flat3Map) {
            super(flat3Map);
        }

        public Object next() {
            super.next();
            return this.getKey();
        }
    }

    static class KeySet
    extends AbstractSet {
        private final Flat3Map parent;

        KeySet(Flat3Map flat3Map) {
            this.parent = flat3Map;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object object) {
            return this.parent.containsKey(object);
        }

        public boolean remove(Object object) {
            boolean bl = this.parent.containsKey(object);
            this.parent.remove(object);
            return bl;
        }

        public Iterator iterator() {
            if (Flat3Map.access$700(this.parent) != null) {
                return Flat3Map.access$700(this.parent).keySet().iterator();
            }
            if (this.parent.size() == 0) {
                return EmptyIterator.INSTANCE;
            }
            return new KeySetIterator(this.parent);
        }
    }

    static class EntrySetIterator
    implements Iterator,
    Map.Entry {
        private final Flat3Map parent;
        private int nextIndex = 0;
        private boolean canRemove = false;

        EntrySetIterator(Flat3Map flat3Map) {
            this.parent = flat3Map;
        }

        public boolean hasNext() {
            return this.nextIndex < Flat3Map.access$000(this.parent);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next() entry in the iteration");
            }
            this.canRemove = true;
            ++this.nextIndex;
            return this;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("remove() can only be called once after next()");
            }
            this.parent.remove(this.getKey());
            --this.nextIndex;
            this.canRemove = false;
        }

        public Object getKey() {
            if (!this.canRemove) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            switch (this.nextIndex) {
                case 3: {
                    return Flat3Map.access$100(this.parent);
                }
                case 2: {
                    return Flat3Map.access$200(this.parent);
                }
                case 1: {
                    return Flat3Map.access$300(this.parent);
                }
            }
            throw new IllegalStateException("Invalid map index");
        }

        public Object getValue() {
            if (!this.canRemove) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            switch (this.nextIndex) {
                case 3: {
                    return Flat3Map.access$400(this.parent);
                }
                case 2: {
                    return Flat3Map.access$500(this.parent);
                }
                case 1: {
                    return Flat3Map.access$600(this.parent);
                }
            }
            throw new IllegalStateException("Invalid map index");
        }

        public Object setValue(Object object) {
            if (!this.canRemove) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            Object object2 = this.getValue();
            switch (this.nextIndex) {
                case 3: {
                    Flat3Map.access$402(this.parent, object);
                }
                case 2: {
                    Flat3Map.access$502(this.parent, object);
                }
                case 1: {
                    Flat3Map.access$602(this.parent, object);
                }
            }
            return object2;
        }

        public boolean equals(Object object) {
            if (!this.canRemove) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = this.getKey();
            Object object3 = this.getValue();
            return (object2 == null ? entry.getKey() == null : object2.equals(entry.getKey())) && (object3 == null ? entry.getValue() == null : object3.equals(entry.getValue()));
        }

        public int hashCode() {
            if (!this.canRemove) {
                return 0;
            }
            Object object = this.getKey();
            Object object2 = this.getValue();
            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }

        public String toString() {
            if (this.canRemove) {
                return this.getKey() + "=" + this.getValue();
            }
            return "";
        }
    }

    static class EntrySet
    extends AbstractSet {
        private final Flat3Map parent;

        EntrySet(Flat3Map flat3Map) {
            this.parent = flat3Map;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            boolean bl = this.parent.containsKey(k);
            this.parent.remove(k);
            return bl;
        }

        public Iterator iterator() {
            if (Flat3Map.access$700(this.parent) != null) {
                return Flat3Map.access$700(this.parent).entrySet().iterator();
            }
            if (this.parent.size() == 0) {
                return EmptyIterator.INSTANCE;
            }
            return new EntrySetIterator(this.parent);
        }
    }

    static class FlatMapIterator
    implements MapIterator,
    ResettableIterator {
        private final Flat3Map parent;
        private int nextIndex = 0;
        private boolean canRemove = false;

        FlatMapIterator(Flat3Map flat3Map) {
            this.parent = flat3Map;
        }

        public boolean hasNext() {
            return this.nextIndex < Flat3Map.access$000(this.parent);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next() entry in the iteration");
            }
            this.canRemove = true;
            ++this.nextIndex;
            return this.getKey();
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("remove() can only be called once after next()");
            }
            this.parent.remove(this.getKey());
            --this.nextIndex;
            this.canRemove = false;
        }

        public Object getKey() {
            if (!this.canRemove) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            switch (this.nextIndex) {
                case 3: {
                    return Flat3Map.access$100(this.parent);
                }
                case 2: {
                    return Flat3Map.access$200(this.parent);
                }
                case 1: {
                    return Flat3Map.access$300(this.parent);
                }
            }
            throw new IllegalStateException("Invalid map index");
        }

        public Object getValue() {
            if (!this.canRemove) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            switch (this.nextIndex) {
                case 3: {
                    return Flat3Map.access$400(this.parent);
                }
                case 2: {
                    return Flat3Map.access$500(this.parent);
                }
                case 1: {
                    return Flat3Map.access$600(this.parent);
                }
            }
            throw new IllegalStateException("Invalid map index");
        }

        public Object setValue(Object object) {
            if (!this.canRemove) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            Object object2 = this.getValue();
            switch (this.nextIndex) {
                case 3: {
                    Flat3Map.access$402(this.parent, object);
                }
                case 2: {
                    Flat3Map.access$502(this.parent, object);
                }
                case 1: {
                    Flat3Map.access$602(this.parent, object);
                }
            }
            return object2;
        }

        public void reset() {
            this.nextIndex = 0;
            this.canRemove = false;
        }

        public String toString() {
            if (this.canRemove) {
                return "Iterator[" + this.getKey() + "=" + this.getValue() + "]";
            }
            return "Iterator[]";
        }
    }
}

