/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections.BoundedMap;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.apache.commons.collections.map.AbstractSortedMapDecorator;
import org.apache.commons.collections.set.UnmodifiableSet;

public class FixedSizeSortedMap
extends AbstractSortedMapDecorator
implements Serializable,
SortedMap,
BoundedMap {
    private static final long serialVersionUID = 3126019624511683653L;

    public static SortedMap decorate(SortedMap sortedMap) {
        return new FixedSizeSortedMap(sortedMap);
    }

    protected FixedSizeSortedMap(SortedMap sortedMap) {
        super(sortedMap);
    }

    protected SortedMap getSortedMap() {
        return (SortedMap)this.map;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    public Object put(Object object, Object object2) {
        if (!this.map.containsKey(object)) {
            throw new IllegalArgumentException("Cannot put new key/value pair - Map is fixed size");
        }
        return this.map.put(object, object2);
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (map.containsKey(iterator.next())) continue;
            throw new IllegalArgumentException("Cannot put new key/value pair - Map is fixed size");
        }
        this.map.putAll(map);
    }

    public void clear() {
        throw new UnsupportedOperationException("Map is fixed size");
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException("Map is fixed size");
    }

    public Set entrySet() {
        Set set = this.map.entrySet();
        return UnmodifiableSet.decorate(set);
    }

    public Set keySet() {
        Set set = this.map.keySet();
        return UnmodifiableSet.decorate(set);
    }

    public Collection values() {
        Collection collection = this.map.values();
        return UnmodifiableCollection.decorate(collection);
    }

    public SortedMap subMap(Object object, Object object2) {
        SortedMap sortedMap = this.getSortedMap().subMap(object, object2);
        return new FixedSizeSortedMap(sortedMap);
    }

    public SortedMap headMap(Object object) {
        SortedMap sortedMap = this.getSortedMap().headMap(object);
        return new FixedSizeSortedMap(sortedMap);
    }

    public SortedMap tailMap(Object object) {
        SortedMap sortedMap = this.getSortedMap().tailMap(object);
        return new FixedSizeSortedMap(sortedMap);
    }

    public boolean isFull() {
        return true;
    }

    public int maxSize() {
        return this.size();
    }
}

