/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ConstantTransformer;
import org.apache.commons.collections.functors.FactoryTransformer;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class DefaultedMap
extends AbstractMapDecorator
implements Serializable,
Map {
    private static final long serialVersionUID = 19698628745827L;
    protected final Object value;

    public static Map decorate(Map map, Object object) {
        if (object instanceof Transformer) {
            object = ConstantTransformer.getInstance(object);
        }
        return new DefaultedMap(map, object);
    }

    public static Map decorate(Map map, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        return new DefaultedMap(map, FactoryTransformer.getInstance(factory));
    }

    public static Map decorate(Map map, Transformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer must not be null");
        }
        return new DefaultedMap(map, transformer);
    }

    public DefaultedMap(Object object) {
        super(new HashMap());
        if (object instanceof Transformer) {
            object = ConstantTransformer.getInstance(object);
        }
        this.value = object;
    }

    protected DefaultedMap(Map map, Object object) {
        super(map);
        this.value = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    public Object get(Object object) {
        if (!this.map.containsKey(object)) {
            if (this.value instanceof Transformer) {
                return ((Transformer)this.value).transform(object);
            }
            return this.value;
        }
        return this.map.get(object);
    }
}

