/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.collections.set.CompositeSet;

public class CompositeMap
implements Map {
    private Map[] composite;
    private MapMutator mutator;

    public CompositeMap() {
        this(new Map[0], null);
    }

    public CompositeMap(Map map, Map map2) {
        this(new Map[]{map, map2}, null);
    }

    public CompositeMap(Map map, Map map2, MapMutator mapMutator) {
        this(new Map[]{map, map2}, mapMutator);
    }

    public CompositeMap(Map[] mapArray) {
        this(mapArray, null);
    }

    public CompositeMap(Map[] mapArray, MapMutator mapMutator) {
        this.mutator = mapMutator;
        this.composite = new Map[0];
        for (int i = mapArray.length - 1; i >= 0; --i) {
            this.addComposited(mapArray[i]);
        }
    }

    public void setMutator(MapMutator mapMutator) {
        this.mutator = mapMutator;
    }

    public synchronized void addComposited(Map map) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            Collection collection = CollectionUtils.intersection(this.composite[i].keySet(), map.keySet());
            if (collection.size() == 0) continue;
            if (this.mutator == null) {
                throw new IllegalArgumentException("Key collision adding Map to CompositeMap");
            }
            this.mutator.resolveCollision(this, this.composite[i], map, collection);
        }
        Map[] mapArray = new Map[this.composite.length + 1];
        System.arraycopy(this.composite, 0, mapArray, 0, this.composite.length);
        mapArray[mapArray.length - 1] = map;
        this.composite = mapArray;
    }

    public synchronized Map removeComposited(Map map) {
        int n = this.composite.length;
        for (int i = 0; i < n; ++i) {
            if (!((Object)this.composite[i]).equals(map)) continue;
            Map[] mapArray = new Map[n - 1];
            System.arraycopy(this.composite, 0, mapArray, 0, i);
            System.arraycopy(this.composite, i + 1, mapArray, i, n - i - 1);
            this.composite = mapArray;
            return map;
        }
        return null;
    }

    public void clear() {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            this.composite[i].clear();
        }
    }

    public boolean containsKey(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsValue(object)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        CompositeSet compositeSet = new CompositeSet();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            compositeSet.addComposited(this.composite[i].entrySet());
        }
        return compositeSet;
    }

    public Object get(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(object)) continue;
            return this.composite[i].get(object);
        }
        return null;
    }

    public boolean isEmpty() {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (this.composite[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set keySet() {
        CompositeSet compositeSet = new CompositeSet();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            compositeSet.addComposited(this.composite[i].keySet());
        }
        return compositeSet;
    }

    public Object put(Object object, Object object2) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        return this.mutator.put(this, this.composite, object, object2);
    }

    public void putAll(Map map) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        this.mutator.putAll(this, this.composite, map);
    }

    public Object remove(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(object)) continue;
            return this.composite[i].remove(object);
        }
        return null;
    }

    public int size() {
        int n = 0;
        for (int i = this.composite.length - 1; i >= 0; --i) {
            n += this.composite[i].size();
        }
        return n;
    }

    public Collection values() {
        CompositeCollection compositeCollection = new CompositeCollection();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            compositeCollection.addComposited(this.composite[i].values());
        }
        return compositeCollection;
    }

    public boolean equals(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public static interface MapMutator {
        public void resolveCollision(CompositeMap var1, Map var2, Map var3, Collection var4);

        public Object put(CompositeMap var1, Map[] var2, Object var3, Object var4);

        public void putAll(CompositeMap var1, Map[] var2, Map var3);
    }
}

