/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.collections.map.AbstractHashedMap;

public abstract class AbstractReferenceMap
extends AbstractHashedMap {
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;
    protected int keyType;
    protected int valueType;
    protected boolean purgeValues;
    private transient ReferenceQueue queue;

    protected AbstractReferenceMap() {
    }

    protected AbstractReferenceMap(int n, int n2, int n3, float f, boolean bl) {
        super(n3, f);
        AbstractReferenceMap.verify("keyType", n);
        AbstractReferenceMap.verify("valueType", n2);
        this.keyType = n;
        this.valueType = n2;
        this.purgeValues = bl;
    }

    protected void init() {
        this.queue = new ReferenceQueue();
    }

    private static void verify(String string, int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException(string + " must be HARD, SOFT, WEAK.");
        }
    }

    public int size() {
        this.purgeBeforeRead();
        return super.size();
    }

    public boolean isEmpty() {
        this.purgeBeforeRead();
        return super.isEmpty();
    }

    public boolean containsKey(Object object) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry hashEntry = this.getEntry(object);
        if (hashEntry == null) {
            return false;
        }
        return hashEntry.getValue() != null;
    }

    public boolean containsValue(Object object) {
        this.purgeBeforeRead();
        if (object == null) {
            return false;
        }
        return super.containsValue(object);
    }

    public Object get(Object object) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry hashEntry = this.getEntry(object);
        if (hashEntry == null) {
            return null;
        }
        return hashEntry.getValue();
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (object2 == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purgeBeforeWrite();
        return super.put(object, object2);
    }

    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        this.purgeBeforeWrite();
        return super.remove(object);
    }

    public void clear() {
        super.clear();
        while (this.queue.poll() != null) {
        }
    }

    public MapIterator mapIterator() {
        return new ReferenceMapIterator(this);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ReferenceEntrySet(this);
        }
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new ReferenceKeySet(this);
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new ReferenceValues(this);
        }
        return this.values;
    }

    protected void purgeBeforeRead() {
        this.purge();
    }

    protected void purgeBeforeWrite() {
        this.purge();
    }

    protected void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.purge(reference);
            reference = this.queue.poll();
        }
    }

    protected void purge(Reference reference) {
        int n = reference.hashCode();
        int n2 = this.hashIndex(n, this.data.length);
        AbstractHashedMap.HashEntry hashEntry = null;
        AbstractHashedMap.HashEntry hashEntry2 = this.data[n2];
        while (hashEntry2 != null) {
            if (((ReferenceEntry)hashEntry2).purge(reference)) {
                if (hashEntry == null) {
                    this.data[n2] = hashEntry2.next;
                } else {
                    hashEntry.next = hashEntry2.next;
                }
                --this.size;
                return;
            }
            hashEntry = hashEntry2;
            hashEntry2 = hashEntry2.next;
        }
    }

    protected AbstractHashedMap.HashEntry getEntry(Object object) {
        if (object == null) {
            return null;
        }
        return super.getEntry(object);
    }

    protected int hashEntry(Object object, Object object2) {
        return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
    }

    protected boolean isEqualKey(Object object, Object object2) {
        object2 = this.keyType > 0 ? ((Reference)object2).get() : object2;
        return object == object2 || object.equals(object2);
    }

    protected AbstractHashedMap.HashEntry createEntry(AbstractHashedMap.HashEntry hashEntry, int n, Object object, Object object2) {
        return new ReferenceEntry(this, hashEntry, n, object, object2);
    }

    protected Iterator createEntrySetIterator() {
        return new ReferenceEntrySetIterator(this);
    }

    protected Iterator createKeySetIterator() {
        return new ReferenceKeySetIterator(this);
    }

    protected Iterator createValuesIterator() {
        return new ReferenceValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.keyType);
        objectOutputStream.writeInt(this.valueType);
        objectOutputStream.writeBoolean(this.purgeValues);
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.data.length);
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            objectOutputStream.writeObject(mapIterator.next());
            objectOutputStream.writeObject(mapIterator.getValue());
        }
        objectOutputStream.writeObject(null);
    }

    protected void doReadObject(ObjectInputStream objectInputStream) {
        Object object;
        this.keyType = objectInputStream.readInt();
        this.valueType = objectInputStream.readInt();
        this.purgeValues = objectInputStream.readBoolean();
        this.loadFactor = objectInputStream.readFloat();
        int n = objectInputStream.readInt();
        this.init();
        this.data = new AbstractHashedMap.HashEntry[n];
        while ((object = objectInputStream.readObject()) != null) {
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
        this.threshold = this.calculateThreshold(this.data.length, this.loadFactor);
    }

    static ReferenceQueue access$000(AbstractReferenceMap abstractReferenceMap) {
        return abstractReferenceMap.queue;
    }

    static class WeakRef
    extends WeakReference {
        private int hash;

        public WeakRef(int n, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class SoftRef
    extends SoftReference {
        private int hash;

        public SoftRef(int n, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class ReferenceMapIterator
    extends ReferenceEntrySetIterator
    implements MapIterator {
        protected ReferenceMapIterator(AbstractReferenceMap abstractReferenceMap) {
            super(abstractReferenceMap);
        }

        public Object next() {
            return this.nextEntry().getKey();
        }

        public Object getKey() {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).getKey();
        }

        public Object getValue() {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).getValue();
        }

        public Object setValue(Object object) {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).setValue(object);
        }
    }

    static class ReferenceValuesIterator
    extends ReferenceEntrySetIterator {
        ReferenceValuesIterator(AbstractReferenceMap abstractReferenceMap) {
            super(abstractReferenceMap);
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    static class ReferenceKeySetIterator
    extends ReferenceEntrySetIterator {
        ReferenceKeySetIterator(AbstractReferenceMap abstractReferenceMap) {
            super(abstractReferenceMap);
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    static class ReferenceEntrySetIterator
    implements Iterator {
        final AbstractReferenceMap parent;
        int index;
        ReferenceEntry entry;
        ReferenceEntry previous;
        Object nextKey;
        Object nextValue;
        Object currentKey;
        Object currentValue;
        int expectedModCount;

        public ReferenceEntrySetIterator(AbstractReferenceMap abstractReferenceMap) {
            this.parent = abstractReferenceMap;
            this.index = abstractReferenceMap.size() != 0 ? abstractReferenceMap.data.length : 0;
            this.expectedModCount = abstractReferenceMap.modCount;
        }

        public boolean hasNext() {
            this.checkMod();
            while (this.nextNull()) {
                ReferenceEntry referenceEntry = this.entry;
                int n = this.index;
                while (referenceEntry == null && n > 0) {
                    referenceEntry = (ReferenceEntry)this.parent.data[--n];
                }
                this.entry = referenceEntry;
                this.index = n;
                if (referenceEntry == null) {
                    this.currentKey = null;
                    this.currentValue = null;
                    return false;
                }
                this.nextKey = referenceEntry.getKey();
                this.nextValue = referenceEntry.getValue();
                if (!this.nextNull()) continue;
                this.entry = this.entry.next();
            }
            return true;
        }

        private void checkMod() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private boolean nextNull() {
            return this.nextKey == null || this.nextValue == null;
        }

        protected ReferenceEntry nextEntry() {
            this.checkMod();
            if (this.nextNull() && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next();
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.nextKey = null;
            this.nextValue = null;
            return this.previous;
        }

        protected ReferenceEntry currentEntry() {
            this.checkMod();
            return this.previous;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            this.checkMod();
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.parent.remove(this.currentKey);
            this.previous = null;
            this.currentKey = null;
            this.currentValue = null;
            this.expectedModCount = this.parent.modCount;
        }
    }

    protected static class ReferenceEntry
    extends AbstractHashedMap.HashEntry {
        protected final AbstractReferenceMap parent;

        public ReferenceEntry(AbstractReferenceMap abstractReferenceMap, AbstractHashedMap.HashEntry hashEntry, int n, Object object, Object object2) {
            super(hashEntry, n, null, null);
            this.parent = abstractReferenceMap;
            this.key = this.toReference(abstractReferenceMap.keyType, object, n);
            this.value = this.toReference(abstractReferenceMap.valueType, object2, n);
        }

        public Object getKey() {
            return this.parent.keyType > 0 ? ((Reference)this.key).get() : this.key;
        }

        public Object getValue() {
            return this.parent.valueType > 0 ? ((Reference)this.value).get() : this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.getValue();
            if (this.parent.valueType > 0) {
                ((Reference)this.value).clear();
            }
            this.value = this.toReference(this.parent.valueType, object, this.hashCode);
            return object2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null || v == null) {
                return false;
            }
            return this.parent.isEqualKey(k, this.key) && this.parent.isEqualValue(v, this.getValue());
        }

        public int hashCode() {
            return this.parent.hashEntry(this.getKey(), this.getValue());
        }

        protected Object toReference(int n, Object object, int n2) {
            switch (n) {
                case 0: {
                    return object;
                }
                case 1: {
                    return new SoftRef(n2, object, AbstractReferenceMap.access$000(this.parent));
                }
                case 2: {
                    return new WeakRef(n2, object, AbstractReferenceMap.access$000(this.parent));
                }
            }
            throw new Error();
        }

        boolean purge(Reference reference) {
            boolean bl = this.parent.keyType > 0 && this.key == reference;
            boolean bl2 = bl = bl || this.parent.valueType > 0 && this.value == reference;
            if (bl) {
                if (this.parent.keyType > 0) {
                    ((Reference)this.key).clear();
                }
                if (this.parent.valueType > 0) {
                    ((Reference)this.value).clear();
                } else if (this.parent.purgeValues) {
                    this.value = null;
                }
            }
            return bl;
        }

        protected ReferenceEntry next() {
            return (ReferenceEntry)this.next;
        }
    }

    static class ReferenceValues
    extends AbstractHashedMap.Values {
        protected ReferenceValues(AbstractHashedMap abstractHashedMap) {
            super(abstractHashedMap);
        }

        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.parent.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    static class ReferenceKeySet
    extends AbstractHashedMap.KeySet {
        protected ReferenceKeySet(AbstractHashedMap abstractHashedMap) {
            super(abstractHashedMap);
        }

        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.parent.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    static class ReferenceEntrySet
    extends AbstractHashedMap.EntrySet {
        protected ReferenceEntrySet(AbstractHashedMap abstractHashedMap) {
            super(abstractHashedMap);
        }

        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList<DefaultMapEntry> arrayList = new ArrayList<DefaultMapEntry>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                arrayList.add(new DefaultMapEntry(entry.getKey(), entry.getValue()));
            }
            return arrayList.toArray(objectArray);
        }
    }
}

