/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedIterator;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.iterators.EmptyOrderedIterator;
import org.apache.commons.collections.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections.map.AbstractHashedMap;

public class AbstractLinkedMap
extends AbstractHashedMap
implements OrderedMap {
    protected transient LinkEntry header;

    protected AbstractLinkedMap() {
    }

    protected AbstractLinkedMap(int n, float f, int n2) {
        super(n, f, n2);
    }

    protected AbstractLinkedMap(int n) {
        super(n);
    }

    protected AbstractLinkedMap(int n, float f) {
        super(n, f);
    }

    protected AbstractLinkedMap(Map map) {
        super(map);
    }

    protected void init() {
        this.header.before = this.header.after = (this.header = (LinkEntry)this.createEntry(null, -1, null, null));
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            LinkEntry linkEntry = this.header.after;
            while (linkEntry != this.header) {
                if (linkEntry.getValue() == null) {
                    return true;
                }
                linkEntry = linkEntry.after;
            }
        } else {
            LinkEntry linkEntry = this.header.after;
            while (linkEntry != this.header) {
                if (this.isEqualValue(object, linkEntry.getValue())) {
                    return true;
                }
                linkEntry = linkEntry.after;
            }
        }
        return false;
    }

    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    public Object firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return this.header.after.getKey();
    }

    public Object lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return this.header.before.getKey();
    }

    public Object nextKey(Object object) {
        LinkEntry linkEntry = (LinkEntry)this.getEntry(object);
        return linkEntry == null || linkEntry.after == this.header ? null : linkEntry.after.getKey();
    }

    public Object previousKey(Object object) {
        LinkEntry linkEntry = (LinkEntry)this.getEntry(object);
        return linkEntry == null || linkEntry.before == this.header ? null : linkEntry.before.getKey();
    }

    protected LinkEntry getEntry(int n) {
        LinkEntry linkEntry;
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is less than zero");
        }
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index " + n + " is invalid for size " + this.size);
        }
        if (n < this.size / 2) {
            linkEntry = this.header.after;
            for (int i = 0; i < n; ++i) {
                linkEntry = linkEntry.after;
            }
        } else {
            linkEntry = this.header;
            for (int i = this.size; i > n; --i) {
                linkEntry = linkEntry.before;
            }
        }
        return linkEntry;
    }

    protected void addEntry(AbstractHashedMap.HashEntry hashEntry, int n) {
        LinkEntry linkEntry = (LinkEntry)hashEntry;
        linkEntry.after = this.header;
        linkEntry.before = this.header.before;
        this.header.before.after = linkEntry;
        this.header.before = linkEntry;
        this.data[n] = hashEntry;
    }

    protected AbstractHashedMap.HashEntry createEntry(AbstractHashedMap.HashEntry hashEntry, int n, Object object, Object object2) {
        return new LinkEntry(hashEntry, n, object, object2);
    }

    protected void removeEntry(AbstractHashedMap.HashEntry hashEntry, int n, AbstractHashedMap.HashEntry hashEntry2) {
        LinkEntry linkEntry = (LinkEntry)hashEntry;
        linkEntry.before.after = linkEntry.after;
        linkEntry.after.before = linkEntry.before;
        linkEntry.after = null;
        linkEntry.before = null;
        super.removeEntry(hashEntry, n, hashEntry2);
    }

    protected LinkEntry entryBefore(LinkEntry linkEntry) {
        return linkEntry.before;
    }

    protected LinkEntry entryAfter(LinkEntry linkEntry) {
        return linkEntry.after;
    }

    public MapIterator mapIterator() {
        if (this.size == 0) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new LinkMapIterator(this);
    }

    public OrderedMapIterator orderedMapIterator() {
        if (this.size == 0) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new LinkMapIterator(this);
    }

    protected Iterator createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyOrderedIterator.INSTANCE;
        }
        return new EntrySetIterator(this);
    }

    protected Iterator createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyOrderedIterator.INSTANCE;
        }
        return new KeySetIterator(this);
    }

    protected Iterator createValuesIterator() {
        if (this.size() == 0) {
            return EmptyOrderedIterator.INSTANCE;
        }
        return new ValuesIterator(this);
    }

    protected static abstract class LinkIterator
    implements OrderedIterator,
    ResettableIterator {
        protected final AbstractLinkedMap parent;
        protected LinkEntry last;
        protected LinkEntry next;
        protected int expectedModCount;

        protected LinkIterator(AbstractLinkedMap abstractLinkedMap) {
            this.parent = abstractLinkedMap;
            this.next = abstractLinkedMap.header.after;
            this.expectedModCount = abstractLinkedMap.modCount;
        }

        public boolean hasNext() {
            return this.next != this.parent.header;
        }

        public boolean hasPrevious() {
            return this.next.before != this.parent.header;
        }

        protected LinkEntry nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == this.parent.header) {
                throw new NoSuchElementException("No next() entry in the iteration");
            }
            this.last = this.next;
            this.next = this.next.after;
            return this.last;
        }

        protected LinkEntry previousEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkEntry linkEntry = this.next.before;
            if (linkEntry == this.parent.header) {
                throw new NoSuchElementException("No previous() entry in the iteration");
            }
            this.next = linkEntry;
            this.last = linkEntry;
            return this.last;
        }

        protected LinkEntry currentEntry() {
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("remove() can only be called once after next()");
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public void reset() {
            this.last = null;
            this.next = this.parent.header.after;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class LinkEntry
    extends AbstractHashedMap.HashEntry {
        protected LinkEntry before;
        protected LinkEntry after;

        protected LinkEntry(AbstractHashedMap.HashEntry hashEntry, int n, Object object, Object object2) {
            super(hashEntry, n, object, object2);
        }
    }

    protected static class ValuesIterator
    extends LinkIterator {
        protected ValuesIterator(AbstractLinkedMap abstractLinkedMap) {
            super(abstractLinkedMap);
        }

        public Object next() {
            return super.nextEntry().getValue();
        }

        public Object previous() {
            return super.previousEntry().getValue();
        }
    }

    protected static class KeySetIterator
    extends EntrySetIterator {
        protected KeySetIterator(AbstractLinkedMap abstractLinkedMap) {
            super(abstractLinkedMap);
        }

        public Object next() {
            return super.nextEntry().getKey();
        }

        public Object previous() {
            return super.previousEntry().getKey();
        }
    }

    protected static class EntrySetIterator
    extends LinkIterator {
        protected EntrySetIterator(AbstractLinkedMap abstractLinkedMap) {
            super(abstractLinkedMap);
        }

        public Object next() {
            return super.nextEntry();
        }

        public Object previous() {
            return super.previousEntry();
        }
    }

    protected static class LinkMapIterator
    extends LinkIterator
    implements OrderedMapIterator {
        protected LinkMapIterator(AbstractLinkedMap abstractLinkedMap) {
            super(abstractLinkedMap);
        }

        public Object next() {
            return super.nextEntry().getKey();
        }

        public Object previous() {
            return super.previousEntry().getKey();
        }

        public Object getKey() {
            LinkEntry linkEntry = this.currentEntry();
            if (linkEntry == null) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            return linkEntry.getKey();
        }

        public Object getValue() {
            LinkEntry linkEntry = this.currentEntry();
            if (linkEntry == null) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            return linkEntry.getValue();
        }

        public Object setValue(Object object) {
            LinkEntry linkEntry = this.currentEntry();
            if (linkEntry == null) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            return linkEntry.setValue(object);
        }
    }
}

