/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.collections.set.AbstractSetDecorator;

abstract class AbstractInputCheckedMapDecorator
extends AbstractMapDecorator {
    protected AbstractInputCheckedMapDecorator() {
    }

    protected AbstractInputCheckedMapDecorator(Map map) {
        super(map);
    }

    protected abstract Object checkSetValue(Object var1);

    protected boolean isSetValueChecking() {
        return true;
    }

    public Set entrySet() {
        if (this.isSetValueChecking()) {
            return new EntrySet(this.map.entrySet(), this);
        }
        return this.map.entrySet();
    }

    static class MapEntry
    extends AbstractMapEntryDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected MapEntry(Map.Entry entry, AbstractInputCheckedMapDecorator abstractInputCheckedMapDecorator) {
            super(entry);
            this.parent = abstractInputCheckedMapDecorator;
        }

        public Object setValue(Object object) {
            object = this.parent.checkSetValue(object);
            return this.entry.setValue(object);
        }
    }

    static class EntrySetIterator
    extends AbstractIteratorDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected EntrySetIterator(Iterator iterator, AbstractInputCheckedMapDecorator abstractInputCheckedMapDecorator) {
            super(iterator);
            this.parent = abstractInputCheckedMapDecorator;
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new MapEntry(entry, this.parent);
        }
    }

    static class EntrySet
    extends AbstractSetDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected EntrySet(Set set, AbstractInputCheckedMapDecorator abstractInputCheckedMapDecorator) {
            super(set);
            this.parent = abstractInputCheckedMapDecorator;
        }

        public Iterator iterator() {
            return new EntrySetIterator(this.collection.iterator(), this.parent);
        }

        public Object[] toArray() {
            Object[] objectArray = this.collection.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = new MapEntry((Map.Entry)objectArray[i], this.parent);
            }
            return objectArray;
        }

        public Object[] toArray(Object[] objectArray) {
            Object[] objectArray2 = objectArray;
            if (objectArray.length > 0) {
                objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), 0);
            }
            objectArray2 = this.collection.toArray(objectArray2);
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = new MapEntry((Map.Entry)objectArray2[i], this.parent);
            }
            if (objectArray2.length > objectArray.length) {
                return objectArray2;
            }
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            if (objectArray.length > objectArray2.length) {
                objectArray[objectArray2.length] = null;
            }
            return objectArray;
        }
    }
}

