/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.IterableMap;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.EmptyMapIterator;

public class AbstractHashedMap
extends AbstractMap
implements IterableMap {
    protected static final String NO_NEXT_ENTRY = "No next() entry in the iteration";
    protected static final String NO_PREVIOUS_ENTRY = "No previous() entry in the iteration";
    protected static final String REMOVE_INVALID = "remove() can only be called once after next()";
    protected static final String GETKEY_INVALID = "getKey() can only be called after next() and before remove()";
    protected static final String GETVALUE_INVALID = "getValue() can only be called after next() and before remove()";
    protected static final String SETVALUE_INVALID = "setValue() can only be called after next() and before remove()";
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final int DEFAULT_THRESHOLD = 12;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final Object NULL = new Object();
    protected transient float loadFactor;
    protected transient int size;
    protected transient HashEntry[] data;
    protected transient int threshold;
    protected transient int modCount;
    protected transient EntrySet entrySet;
    protected transient KeySet keySet;
    protected transient Values values;

    protected AbstractHashedMap() {
    }

    protected AbstractHashedMap(int n, float f, int n2) {
        this.loadFactor = f;
        this.data = new HashEntry[n];
        this.threshold = n2;
        this.init();
    }

    protected AbstractHashedMap(int n) {
        this(n, 0.75f);
    }

    protected AbstractHashedMap(int n, float f) {
        if (n < 1) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = f;
        n = this.calculateNewCapacity(n);
        this.threshold = this.calculateThreshold(n, f);
        this.data = new HashEntry[n];
        this.init();
    }

    protected AbstractHashedMap(Map map) {
        this(Math.max(2 * map.size(), 16), 0.75f);
        this.putAll(map);
    }

    protected void init() {
    }

    public Object get(Object object) {
        object = this.convertKey(object);
        int n = this.hash(object);
        HashEntry hashEntry = this.data[this.hashIndex(n, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.key)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        object = this.convertKey(object);
        int n = this.hash(object);
        HashEntry hashEntry = this.data[this.hashIndex(n, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.key)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            int n = this.data.length;
            for (int i = 0; i < n; ++i) {
                HashEntry hashEntry = this.data[i];
                while (hashEntry != null) {
                    if (hashEntry.getValue() == null) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        } else {
            int n = this.data.length;
            for (int i = 0; i < n; ++i) {
                HashEntry hashEntry = this.data[i];
                while (hashEntry != null) {
                    if (this.isEqualValue(object, hashEntry.getValue())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        object = this.convertKey(object);
        int n = this.hash(object);
        int n2 = this.hashIndex(n, this.data.length);
        HashEntry hashEntry = this.data[n2];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.key)) {
                Object object3 = hashEntry.getValue();
                this.updateEntry(hashEntry, object2);
                return object3;
            }
            hashEntry = hashEntry.next;
        }
        this.addMapping(n2, n, object, object2);
        return null;
    }

    public void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        int n2 = (int)((float)(this.size + n) / this.loadFactor + 1.0f);
        this.ensureCapacity(this.calculateNewCapacity(n2));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        object = this.convertKey(object);
        int n = this.hash(object);
        int n2 = this.hashIndex(n, this.data.length);
        HashEntry hashEntry = this.data[n2];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.key)) {
                Object object2 = hashEntry.getValue();
                this.removeMapping(hashEntry, n2, hashEntry2);
                return object2;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public void clear() {
        ++this.modCount;
        HashEntry[] hashEntryArray = this.data;
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            hashEntryArray[i] = null;
        }
        this.size = 0;
    }

    protected Object convertKey(Object object) {
        return object == null ? NULL : object;
    }

    protected int hash(Object object) {
        int n = object.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected boolean isEqualKey(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected boolean isEqualValue(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected int hashIndex(int n, int n2) {
        return n & n2 - 1;
    }

    protected HashEntry getEntry(Object object) {
        object = this.convertKey(object);
        int n = this.hash(object);
        HashEntry hashEntry = this.data[this.hashIndex(n, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.key)) {
                return hashEntry;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected void updateEntry(HashEntry hashEntry, Object object) {
        hashEntry.setValue(object);
    }

    protected void reuseEntry(HashEntry hashEntry, int n, int n2, Object object, Object object2) {
        hashEntry.next = this.data[n];
        hashEntry.hashCode = n2;
        hashEntry.key = object;
        hashEntry.value = object2;
    }

    protected void addMapping(int n, int n2, Object object, Object object2) {
        ++this.modCount;
        HashEntry hashEntry = this.createEntry(this.data[n], n2, object, object2);
        this.addEntry(hashEntry, n);
        ++this.size;
        this.checkCapacity();
    }

    protected HashEntry createEntry(HashEntry hashEntry, int n, Object object, Object object2) {
        return new HashEntry(hashEntry, n, object, object2);
    }

    protected void addEntry(HashEntry hashEntry, int n) {
        this.data[n] = hashEntry;
    }

    protected void removeMapping(HashEntry hashEntry, int n, HashEntry hashEntry2) {
        ++this.modCount;
        this.removeEntry(hashEntry, n, hashEntry2);
        --this.size;
        this.destroyEntry(hashEntry);
    }

    protected void removeEntry(HashEntry hashEntry, int n, HashEntry hashEntry2) {
        if (hashEntry2 == null) {
            this.data[n] = hashEntry.next;
        } else {
            hashEntry2.next = hashEntry.next;
        }
    }

    protected void destroyEntry(HashEntry hashEntry) {
        hashEntry.next = null;
        hashEntry.key = null;
        hashEntry.value = null;
    }

    protected void checkCapacity() {
        int n;
        if (this.size >= this.threshold && (n = this.data.length * 2) <= 0x40000000) {
            this.ensureCapacity(n);
        }
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        if (this.size == 0) {
            this.threshold = this.calculateThreshold(n, this.loadFactor);
            this.data = new HashEntry[n];
        } else {
            HashEntry[] hashEntryArray = this.data;
            HashEntry[] hashEntryArray2 = new HashEntry[n];
            ++this.modCount;
            for (int i = n2 - 1; i >= 0; --i) {
                HashEntry hashEntry;
                HashEntry hashEntry2 = hashEntryArray[i];
                if (hashEntry2 == null) continue;
                hashEntryArray[i] = null;
                do {
                    hashEntry = hashEntry2.next;
                    int n3 = this.hashIndex(hashEntry2.hashCode, n);
                    hashEntry2.next = hashEntryArray2[n3];
                    hashEntryArray2[n3] = hashEntry2;
                } while ((hashEntry2 = hashEntry) != null);
            }
            this.threshold = this.calculateThreshold(n, this.loadFactor);
            this.data = hashEntryArray2;
        }
    }

    protected int calculateNewCapacity(int n) {
        int n2;
        if (n > 0x40000000) {
            n2 = 0x40000000;
        } else {
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            if (n2 > 0x40000000) {
                n2 = 0x40000000;
            }
        }
        return n2;
    }

    protected int calculateThreshold(int n, float f) {
        return (int)((float)n * f);
    }

    protected HashEntry entryNext(HashEntry hashEntry) {
        return hashEntry.next;
    }

    protected int entryHashCode(HashEntry hashEntry) {
        return hashEntry.hashCode;
    }

    protected Object entryKey(HashEntry hashEntry) {
        return hashEntry.key;
    }

    protected Object entryValue(HashEntry hashEntry) {
        return hashEntry.value;
    }

    public MapIterator mapIterator() {
        if (this.size == 0) {
            return EmptyMapIterator.INSTANCE;
        }
        return new HashMapIterator(this);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new EntrySetIterator(this);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new KeySetIterator(this);
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator createValuesIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.writeInt(this.size);
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            objectOutputStream.writeObject(mapIterator.next());
            objectOutputStream.writeObject(mapIterator.getValue());
        }
    }

    protected void doReadObject(ObjectInputStream objectInputStream) {
        this.loadFactor = objectInputStream.readFloat();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this.init();
        this.threshold = this.calculateThreshold(n, this.loadFactor);
        this.data = new HashEntry[n];
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    protected Object clone() {
        try {
            AbstractHashedMap abstractHashedMap = (AbstractHashedMap)super.clone();
            abstractHashedMap.data = new HashEntry[this.data.length];
            abstractHashedMap.entrySet = null;
            abstractHashedMap.keySet = null;
            abstractHashedMap.values = null;
            abstractHashedMap.modCount = 0;
            abstractHashedMap.size = 0;
            abstractHashedMap.init();
            abstractHashedMap.putAll((Map)this);
            return abstractHashedMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        MapIterator mapIterator = this.mapIterator();
        try {
            while (mapIterator.hasNext()) {
                Object object2 = mapIterator.next();
                Object object3 = mapIterator.getValue();
                if (!(object3 == null ? map.get(object2) != null || !map.containsKey(object2) : !object3.equals(map.get(object2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.createEntrySetIterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(32 * this.size());
        stringBuffer.append('{');
        MapIterator mapIterator = this.mapIterator();
        boolean bl = mapIterator.hasNext();
        while (bl) {
            Object object = mapIterator.next();
            Object object2 = mapIterator.getValue();
            stringBuffer.append(object == this ? "(this Map)" : object).append('=').append(object2 == this ? "(this Map)" : object2);
            bl = mapIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(',').append(' ');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    protected static abstract class HashIterator
    implements Iterator {
        protected final AbstractHashedMap parent;
        protected int hashIndex;
        protected HashEntry last;
        protected HashEntry next;
        protected int expectedModCount;

        protected HashIterator(AbstractHashedMap abstractHashedMap) {
            this.parent = abstractHashedMap;
            HashEntry[] hashEntryArray = abstractHashedMap.data;
            int n = hashEntryArray.length;
            HashEntry hashEntry = null;
            while (n > 0 && hashEntry == null) {
                hashEntry = hashEntryArray[--n];
            }
            this.next = hashEntry;
            this.hashIndex = n;
            this.expectedModCount = abstractHashedMap.modCount;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected HashEntry nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            HashEntry hashEntry = this.next;
            if (hashEntry == null) {
                throw new NoSuchElementException(AbstractHashedMap.NO_NEXT_ENTRY);
            }
            HashEntry[] hashEntryArray = this.parent.data;
            int n = this.hashIndex;
            HashEntry hashEntry2 = hashEntry.next;
            while (hashEntry2 == null && n > 0) {
                hashEntry2 = hashEntryArray[--n];
            }
            this.next = hashEntry2;
            this.hashIndex = n;
            this.last = hashEntry;
            return hashEntry;
        }

        protected HashEntry currentEntry() {
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException(AbstractHashedMap.REMOVE_INVALID);
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class HashEntry
    implements Map.Entry,
    KeyValue {
        protected HashEntry next;
        protected int hashCode;
        protected Object key;
        protected Object value;

        protected HashEntry(HashEntry hashEntry, int n, Object object, Object object2) {
            this.next = hashEntry;
            this.hashCode = n;
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key == NULL ? null : this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    protected static class ValuesIterator
    extends HashIterator {
        protected ValuesIterator(AbstractHashedMap abstractHashedMap) {
            super(abstractHashedMap);
        }

        public Object next() {
            return super.nextEntry().getValue();
        }
    }

    protected static class Values
    extends AbstractCollection {
        protected final AbstractHashedMap parent;

        protected Values(AbstractHashedMap abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object object) {
            return this.parent.containsValue(object);
        }

        public Iterator iterator() {
            return this.parent.createValuesIterator();
        }
    }

    protected static class KeySetIterator
    extends EntrySetIterator {
        protected KeySetIterator(AbstractHashedMap abstractHashedMap) {
            super(abstractHashedMap);
        }

        public Object next() {
            return super.nextEntry().getKey();
        }
    }

    protected static class KeySet
    extends AbstractSet {
        protected final AbstractHashedMap parent;

        protected KeySet(AbstractHashedMap abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object object) {
            return this.parent.containsKey(object);
        }

        public boolean remove(Object object) {
            boolean bl = this.parent.containsKey(object);
            this.parent.remove(object);
            return bl;
        }

        public Iterator iterator() {
            return this.parent.createKeySetIterator();
        }
    }

    protected static class EntrySetIterator
    extends HashIterator {
        protected EntrySetIterator(AbstractHashedMap abstractHashedMap) {
            super(abstractHashedMap);
        }

        public Object next() {
            return super.nextEntry();
        }
    }

    protected static class EntrySet
    extends AbstractSet {
        protected final AbstractHashedMap parent;

        protected EntrySet(AbstractHashedMap abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                HashEntry hashEntry = this.parent.getEntry(entry.getKey());
                return hashEntry != null && ((Object)hashEntry).equals(entry);
            }
            return false;
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            if (!this.contains(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            this.parent.remove(k);
            return true;
        }

        public Iterator iterator() {
            return this.parent.createEntrySetIterator();
        }
    }

    protected static class HashMapIterator
    extends HashIterator
    implements MapIterator {
        protected HashMapIterator(AbstractHashedMap abstractHashedMap) {
            super(abstractHashedMap);
        }

        public Object next() {
            return super.nextEntry().getKey();
        }

        public Object getKey() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETKEY_INVALID);
            }
            return hashEntry.getKey();
        }

        public Object getValue() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETVALUE_INVALID);
            }
            return hashEntry.getValue();
        }

        public Object setValue(Object object) {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.SETVALUE_INVALID);
            }
            return hashEntry.setValue(object);
        }
    }
}

