/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.OrderedIterator;

public class TreeList
extends AbstractList {
    private AVLNode root;
    private int size;

    public TreeList() {
    }

    public TreeList(Collection collection) {
        this.addAll(collection);
    }

    public Object get(int n) {
        this.checkInterval(n, 0, this.size() - 1);
        return this.root.get(n).getValue();
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        this.checkInterval(n, 0, this.size());
        return new TreeListIterator(this, n);
    }

    public int indexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.indexOf(object, AVLNode.access$000(this.root));
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        if (this.root != null) {
            this.root.toArray(objectArray, AVLNode.access$000(this.root));
        }
        return objectArray;
    }

    public void add(int n, Object object) {
        ++this.modCount;
        this.checkInterval(n, 0, this.size());
        this.root = this.root == null ? new AVLNode(n, object, null, null, null) : this.root.insert(n, object);
        ++this.size;
    }

    public Object set(int n, Object object) {
        this.checkInterval(n, 0, this.size() - 1);
        AVLNode aVLNode = this.root.get(n);
        Object object2 = AVLNode.access$200(aVLNode);
        aVLNode.setValue(object);
        return object2;
    }

    public Object remove(int n) {
        ++this.modCount;
        this.checkInterval(n, 0, this.size() - 1);
        Object object = this.get(n);
        this.root = this.root.remove(n);
        --this.size;
        return object;
    }

    public void clear() {
        ++this.modCount;
        this.root = null;
        this.size = 0;
    }

    private void checkInterval(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IndexOutOfBoundsException("Invalid index:" + n + ", size=" + this.size());
        }
    }

    static int access$300(TreeList treeList) {
        return treeList.modCount;
    }

    static AVLNode access$400(TreeList treeList) {
        return treeList.root;
    }

    static int access$500(TreeList treeList) {
        return treeList.modCount;
    }

    static class 1 {
    }

    static class TreeListIterator
    implements ListIterator,
    OrderedIterator {
        protected final TreeList parent;
        protected AVLNode next;
        protected int nextIndex;
        protected AVLNode current;
        protected int currentIndex;
        protected int expectedModCount;

        protected TreeListIterator(TreeList treeList, int n) {
            this.parent = treeList;
            this.expectedModCount = TreeList.access$300(treeList);
            this.next = TreeList.access$400(treeList) == null ? null : TreeList.access$400(treeList).get(n);
            this.nextIndex = n;
            this.currentIndex = -1;
        }

        protected void checkModCount() {
            if (TreeList.access$500(this.parent) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            return this.nextIndex < this.parent.size();
        }

        public Object next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index " + this.nextIndex + ".");
            }
            if (this.next == null) {
                this.next = TreeList.access$400(this.parent).get(this.nextIndex);
            }
            Object object = this.next.getValue();
            this.current = this.next;
            this.currentIndex = this.nextIndex++;
            this.next = this.next.next();
            return object;
        }

        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        public Object previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Already at start of list.");
            }
            this.next = this.next == null ? TreeList.access$400(this.parent).get(this.nextIndex - 1) : this.next.previous();
            Object object = this.next.getValue();
            this.current = this.next;
            this.currentIndex = --this.nextIndex;
            return object;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        public void remove() {
            this.checkModCount();
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            if (this.nextIndex == this.currentIndex) {
                this.next = this.next.next();
                this.parent.remove(this.currentIndex);
            } else {
                this.parent.remove(this.currentIndex);
                --this.nextIndex;
            }
            this.current = null;
            this.currentIndex = -1;
            ++this.expectedModCount;
        }

        public void set(Object object) {
            this.checkModCount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue(object);
        }

        public void add(Object object) {
            this.checkModCount();
            this.parent.add(this.nextIndex, object);
            this.current = null;
            this.currentIndex = -1;
            ++this.nextIndex;
            ++this.expectedModCount;
        }
    }

    static class AVLNode {
        private AVLNode left;
        private boolean leftIsPrevious;
        private AVLNode right;
        private boolean rightIsNext;
        private int height;
        private int relativePosition;
        private Object value;

        private AVLNode(int n, Object object, AVLNode aVLNode, AVLNode aVLNode2) {
            this.relativePosition = n;
            this.value = object;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = aVLNode;
            this.left = aVLNode2;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object object) {
            this.value = object;
        }

        AVLNode get(int n) {
            AVLNode aVLNode;
            int n2 = n - this.relativePosition;
            if (n2 == 0) {
                return this;
            }
            AVLNode aVLNode2 = aVLNode = n2 < 0 ? this.getLeftSubTree() : this.getRightSubTree();
            if (aVLNode == null) {
                return null;
            }
            return aVLNode.get(n2);
        }

        int indexOf(Object object, int n) {
            int n2;
            if (this.getLeftSubTree() != null && (n2 = this.left.indexOf(object, n + this.left.relativePosition)) != -1) {
                return n2;
            }
            if (this.value == null ? this.value == object : this.value.equals(object)) {
                return n;
            }
            if (this.getRightSubTree() != null) {
                return this.right.indexOf(object, n + this.right.relativePosition);
            }
            return -1;
        }

        void toArray(Object[] objectArray, int n) {
            objectArray[n] = this.value;
            if (this.getLeftSubTree() != null) {
                this.left.toArray(objectArray, n + this.left.relativePosition);
            }
            if (this.getRightSubTree() != null) {
                this.right.toArray(objectArray, n + this.right.relativePosition);
            }
        }

        AVLNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        AVLNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        AVLNode insert(int n, Object object) {
            int n2 = n - this.relativePosition;
            if (n2 <= 0) {
                return this.insertOnLeft(n2, object);
            }
            return this.insertOnRight(n2, object);
        }

        private AVLNode insertOnLeft(int n, Object object) {
            AVLNode aVLNode = this;
            if (this.getLeftSubTree() == null) {
                this.setLeft(new AVLNode(-1, object, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(n, object), null);
            }
            if (this.relativePosition >= 0) {
                ++this.relativePosition;
            }
            aVLNode = this.balance();
            this.recalcHeight();
            return aVLNode;
        }

        private AVLNode insertOnRight(int n, Object object) {
            AVLNode aVLNode = this;
            if (this.getRightSubTree() == null) {
                this.setRight(new AVLNode(1, object, this.right, this), null);
            } else {
                this.setRight(this.right.insert(n, object), null);
            }
            if (this.relativePosition < 0) {
                --this.relativePosition;
            }
            aVLNode = this.balance();
            this.recalcHeight();
            return aVLNode;
        }

        private AVLNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private AVLNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private AVLNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private AVLNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        AVLNode remove(int n) {
            int n2 = n - this.relativePosition;
            if (n2 == 0) {
                return this.removeSelf();
            }
            if (n2 > 0) {
                this.setRight(this.right.remove(n2), this.right.right);
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                this.setLeft(this.left.remove(n2), this.left.left);
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            if (this.relativePosition < 0) {
                ++this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode removeMin() {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(), this.left.left);
            if (this.relativePosition > 0) {
                --this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode removeSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                if (this.relativePosition > 0) {
                    this.left.relativePosition = this.left.relativePosition + (this.relativePosition + (this.relativePosition > 0 ? 0 : 1));
                }
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                this.right.relativePosition = this.right.relativePosition + (this.relativePosition - (this.relativePosition < 0 ? 0 : 1));
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                AVLNode aVLNode = this.right.min();
                this.value = aVLNode.value;
                if (this.leftIsPrevious) {
                    this.left = aVLNode.left;
                }
                this.right = this.right.removeMin();
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                AVLNode aVLNode = this.left.max();
                this.value = aVLNode.value;
                if (this.rightIsNext) {
                    this.right = aVLNode.right;
                }
                AVLNode aVLNode2 = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = aVLNode2;
                    this.leftIsPrevious = true;
                }
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this;
        }

        private AVLNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(AVLNode aVLNode) {
            if (aVLNode == null) {
                return 0;
            }
            return aVLNode.relativePosition;
        }

        private int setOffset(AVLNode aVLNode, int n) {
            if (aVLNode == null) {
                return 0;
            }
            int n2 = this.getOffset(aVLNode);
            aVLNode.relativePosition = n;
            return n2;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(AVLNode aVLNode) {
            return aVLNode == null ? -1 : aVLNode.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private AVLNode rotateLeft() {
            AVLNode aVLNode = this.right;
            AVLNode aVLNode2 = this.getRightSubTree().getLeftSubTree();
            int n = this.relativePosition + this.getOffset(aVLNode);
            int n2 = -aVLNode.relativePosition;
            int n3 = this.getOffset(aVLNode) + this.getOffset(aVLNode2);
            this.setRight(aVLNode2, aVLNode);
            aVLNode.setLeft(this, null);
            this.setOffset(aVLNode, n);
            this.setOffset(this, n2);
            this.setOffset(aVLNode2, n3);
            return aVLNode;
        }

        private AVLNode rotateRight() {
            AVLNode aVLNode = this.left;
            AVLNode aVLNode2 = this.getLeftSubTree().getRightSubTree();
            int n = this.relativePosition + this.getOffset(aVLNode);
            int n2 = -aVLNode.relativePosition;
            int n3 = this.getOffset(aVLNode) + this.getOffset(aVLNode2);
            this.setLeft(aVLNode2, aVLNode);
            aVLNode.setRight(this, null);
            this.setOffset(aVLNode, n);
            this.setOffset(this, n2);
            this.setOffset(aVLNode2, n3);
            return aVLNode;
        }

        private void setLeft(AVLNode aVLNode, AVLNode aVLNode2) {
            this.leftIsPrevious = aVLNode == null;
            this.left = this.leftIsPrevious ? aVLNode2 : aVLNode;
            this.recalcHeight();
        }

        private void setRight(AVLNode aVLNode, AVLNode aVLNode2) {
            this.rightIsNext = aVLNode == null;
            this.right = this.rightIsNext ? aVLNode2 : aVLNode;
            this.recalcHeight();
        }

        public String toString() {
            return "AVLNode(" + this.relativePosition + "," + (this.left != null) + "," + this.value + "," + (this.getRightSubTree() != null) + ", faedelung " + this.rightIsNext + " )";
        }

        static int access$000(AVLNode aVLNode) {
            return aVLNode.relativePosition;
        }

        AVLNode(int n, Object object, AVLNode aVLNode, AVLNode aVLNode2, 1 var5_5) {
            this(n, object, aVLNode, aVLNode2);
        }

        static Object access$200(AVLNode aVLNode) {
            return aVLNode.value;
        }
    }
}

