/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.list.AbstractLinkedList;

public class NodeCachingLinkedList
extends AbstractLinkedList
implements Serializable {
    private static final long serialVersionUID = 6897789178562232073L;
    protected static final int DEFAULT_MAXIMUM_CACHE_SIZE = 20;
    protected transient AbstractLinkedList.Node firstCachedNode;
    protected transient int cacheSize;
    protected int maximumCacheSize;

    public NodeCachingLinkedList() {
        this(20);
    }

    public NodeCachingLinkedList(Collection collection) {
        super(collection);
        this.maximumCacheSize = 20;
    }

    public NodeCachingLinkedList(int n) {
        this.maximumCacheSize = n;
        this.init();
    }

    protected int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    protected void setMaximumCacheSize(int n) {
        this.maximumCacheSize = n;
        this.shrinkCacheToMaximumSize();
    }

    protected void shrinkCacheToMaximumSize() {
        while (this.cacheSize > this.maximumCacheSize) {
            this.getNodeFromCache();
        }
    }

    protected AbstractLinkedList.Node getNodeFromCache() {
        if (this.cacheSize == 0) {
            return null;
        }
        AbstractLinkedList.Node node = this.firstCachedNode;
        this.firstCachedNode = node.next;
        node.next = null;
        --this.cacheSize;
        return node;
    }

    protected boolean isCacheFull() {
        return this.cacheSize >= this.maximumCacheSize;
    }

    protected void addNodeToCache(AbstractLinkedList.Node node) {
        if (this.isCacheFull()) {
            return;
        }
        AbstractLinkedList.Node node2 = this.firstCachedNode;
        node.previous = null;
        node.next = node2;
        node.setValue(null);
        this.firstCachedNode = node;
        ++this.cacheSize;
    }

    protected AbstractLinkedList.Node createNode(Object object) {
        AbstractLinkedList.Node node = this.getNodeFromCache();
        if (node == null) {
            return super.createNode(object);
        }
        node.setValue(object);
        return node;
    }

    protected void removeNode(AbstractLinkedList.Node node) {
        super.removeNode(node);
        this.addNodeToCache(node);
    }

    protected void removeAllNodes() {
        int n = Math.min(this.size, this.maximumCacheSize - this.cacheSize);
        AbstractLinkedList.Node node = this.header.next;
        for (int i = 0; i < n; ++i) {
            AbstractLinkedList.Node node2 = node;
            node = node.next;
            this.addNodeToCache(node2);
        }
        super.removeAllNodes();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.doReadObject(objectInputStream);
    }
}

