/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.list.AbstractLinkedList;

public class CursorableLinkedList
extends AbstractLinkedList
implements Serializable {
    private static final long serialVersionUID = 8836393098519411393L;
    protected transient List cursors = new ArrayList();

    public CursorableLinkedList() {
        this.init();
    }

    public CursorableLinkedList(Collection collection) {
        super(collection);
    }

    protected void init() {
        super.init();
        this.cursors = new ArrayList();
    }

    public Iterator iterator() {
        return super.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.cursor(0);
    }

    public ListIterator listIterator(int n) {
        return this.cursor(n);
    }

    public Cursor cursor() {
        return this.cursor(0);
    }

    public Cursor cursor(int n) {
        Cursor cursor = new Cursor(this, n);
        this.registerCursor(cursor);
        return cursor;
    }

    protected void updateNode(AbstractLinkedList.Node node, Object object) {
        super.updateNode(node, object);
        this.broadcastNodeChanged(node);
    }

    protected void addNode(AbstractLinkedList.Node node, AbstractLinkedList.Node node2) {
        super.addNode(node, node2);
        this.broadcastNodeInserted(node);
    }

    protected void removeNode(AbstractLinkedList.Node node) {
        super.removeNode(node);
        this.broadcastNodeRemoved(node);
    }

    protected void removeAllNodes() {
        if (this.size() > 0) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    protected void registerCursor(Cursor cursor) {
        Iterator iterator = this.cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
        this.cursors.add(new WeakReference<Cursor>(cursor));
    }

    protected void unregisterCursor(Cursor cursor) {
        Iterator iterator = this.cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor2 = (Cursor)weakReference.get();
            if (cursor2 == null) {
                iterator.remove();
                continue;
            }
            if (cursor2 != cursor) continue;
            weakReference.clear();
            iterator.remove();
            break;
        }
    }

    protected void broadcastNodeChanged(AbstractLinkedList.Node node) {
        Iterator iterator = this.cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.nodeChanged(node);
        }
    }

    protected void broadcastNodeRemoved(AbstractLinkedList.Node node) {
        Iterator iterator = this.cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.nodeRemoved(node);
        }
    }

    protected void broadcastNodeInserted(AbstractLinkedList.Node node) {
        Iterator iterator = this.cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.nodeInserted(node);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.doReadObject(objectInputStream);
    }

    protected ListIterator createSubListListIterator(AbstractLinkedList.LinkedSubList linkedSubList, int n) {
        SubCursor subCursor = new SubCursor(linkedSubList, n);
        this.registerCursor(subCursor);
        return subCursor;
    }

    protected static class SubCursor
    extends Cursor {
        protected final AbstractLinkedList.LinkedSubList sub;

        protected SubCursor(AbstractLinkedList.LinkedSubList linkedSubList, int n) {
            super((CursorableLinkedList)linkedSubList.parent, n + linkedSubList.offset);
            this.sub = linkedSubList;
        }

        public boolean hasNext() {
            return this.nextIndex() < this.sub.size;
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public int nextIndex() {
            return super.nextIndex() - this.sub.offset;
        }

        public void add(Object object) {
            super.add(object);
            this.sub.expectedModCount = this.parent.modCount;
            ++this.sub.size;
        }

        public void remove() {
            super.remove();
            this.sub.expectedModCount = this.parent.modCount;
            --this.sub.size;
        }
    }

    public static class Cursor
    extends AbstractLinkedList.LinkedListIterator {
        boolean valid = true;
        boolean nextIndexValid = true;
        boolean currentRemovedByAnother = false;

        protected Cursor(CursorableLinkedList cursorableLinkedList, int n) {
            super(cursorableLinkedList, n);
        }

        public void remove() {
            if (this.current != null || !this.currentRemovedByAnother) {
                this.checkModCount();
                this.parent.removeNode(this.getLastNodeReturned());
            }
            this.currentRemovedByAnother = false;
        }

        public void add(Object object) {
            super.add(object);
            this.next = this.next.next;
        }

        public int nextIndex() {
            if (!this.nextIndexValid) {
                if (this.next == this.parent.header) {
                    this.nextIndex = this.parent.size();
                } else {
                    int n = 0;
                    AbstractLinkedList.Node node = this.parent.header.next;
                    while (node != this.next) {
                        ++n;
                        node = node.next;
                    }
                    this.nextIndex = n;
                }
                this.nextIndexValid = true;
            }
            return this.nextIndex;
        }

        protected void nodeChanged(AbstractLinkedList.Node node) {
        }

        protected void nodeRemoved(AbstractLinkedList.Node node) {
            if (node == this.next && node == this.current) {
                this.next = node.next;
                this.current = null;
                this.currentRemovedByAnother = true;
            } else if (node == this.next) {
                this.next = node.next;
                this.currentRemovedByAnother = false;
            } else if (node == this.current) {
                this.current = null;
                this.currentRemovedByAnother = true;
                --this.nextIndex;
            } else {
                this.nextIndexValid = false;
                this.currentRemovedByAnother = false;
            }
        }

        protected void nodeInserted(AbstractLinkedList.Node node) {
            if (node.previous == this.current) {
                this.next = node;
            } else if (this.next.previous == node) {
                this.next = node;
            } else {
                this.nextIndexValid = false;
            }
        }

        protected void checkModCount() {
            if (!this.valid) {
                throw new ConcurrentModificationException("Cursor closed");
            }
        }

        public void close() {
            if (this.valid) {
                ((CursorableLinkedList)this.parent).unregisterCursor(this);
                this.valid = false;
            }
        }
    }
}

