/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.OrderedIterator;

public abstract class AbstractLinkedList
implements List {
    protected transient Node header;
    protected transient int size;
    protected transient int modCount;

    protected AbstractLinkedList() {
    }

    protected AbstractLinkedList(Collection collection) {
        this.init();
        this.addAll(collection);
    }

    protected void init() {
        this.header = this.createHeaderNode();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object get(int n) {
        Node node = this.getNode(n, false);
        return node.getValue();
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return new LinkedListIterator(this, 0);
    }

    public ListIterator listIterator(int n) {
        return new LinkedListIterator(this, n);
    }

    public int indexOf(Object object) {
        int n = 0;
        Node node = this.header.next;
        while (node != this.header) {
            if (this.isEqualValue(node.getValue(), object)) {
                return n;
            }
            ++n;
            node = node.next;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size - 1;
        Node node = this.header.previous;
        while (node != this.header) {
            if (this.isEqualValue(node.getValue(), object)) {
                return n;
            }
            --n;
            node = node.previous;
        }
        return -1;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, this.size);
        }
        int n = 0;
        Node node = this.header.next;
        while (node != this.header) {
            objectArray[n] = node.getValue();
            node = node.next;
            ++n;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public List subList(int n, int n2) {
        return new LinkedSubList(this, n, n2);
    }

    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public void add(int n, Object object) {
        Node node = this.getNode(n, true);
        this.addNodeBefore(node, object);
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        Node node = this.getNode(n, true);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.addNodeBefore(node, e);
        }
        return true;
    }

    public Object remove(int n) {
        Node node = this.getNode(n, false);
        Object object = node.getValue();
        this.removeNode(node);
        return object;
    }

    public boolean remove(Object object) {
        Node node = this.header.next;
        while (node != this.header) {
            if (this.isEqualValue(node.getValue(), object)) {
                this.removeNode(node);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object set(int n, Object object) {
        Node node = this.getNode(n, false);
        Object object2 = node.getValue();
        this.updateNode(node, object);
        return object2;
    }

    public void clear() {
        this.removeAllNodes();
    }

    public Object getFirst() {
        Node node = this.header.next;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public Object getLast() {
        Node node = this.header.previous;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public boolean addFirst(Object object) {
        this.addNodeAfter(this.header, object);
        return true;
    }

    public boolean addLast(Object object) {
        this.addNodeBefore(this.header, object);
        return true;
    }

    public Object removeFirst() {
        Node node = this.header.next;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        Object object = node.getValue();
        this.removeNode(node);
        return object;
    }

    public Object removeLast() {
        Node node = this.header.previous;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        Object object = node.getValue();
        this.removeNode(node);
        return object;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(16 * this.size());
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            Object e = iterator.next();
            stringBuffer.append((Object)(e == this ? "(this Collection)" : e));
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected boolean isEqualValue(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    protected void updateNode(Node node, Object object) {
        node.setValue(object);
    }

    protected Node createHeaderNode() {
        return new Node();
    }

    protected Node createNode(Object object) {
        return new Node(object);
    }

    protected void addNodeBefore(Node node, Object object) {
        Node node2 = this.createNode(object);
        this.addNode(node2, node);
    }

    protected void addNodeAfter(Node node, Object object) {
        Node node2 = this.createNode(object);
        this.addNode(node2, node.next);
    }

    protected void addNode(Node node, Node node2) {
        node.next = node2;
        node.previous = node2.previous;
        node2.previous.next = node;
        node2.previous = node;
        ++this.size;
        ++this.modCount;
    }

    protected void removeNode(Node node) {
        node.previous.next = node.next;
        node.next.previous = node.previous;
        --this.size;
        ++this.modCount;
    }

    protected void removeAllNodes() {
        this.header.next = this.header;
        this.header.previous = this.header;
        this.size = 0;
        ++this.modCount;
    }

    protected Node getNode(int n, boolean bl) {
        Node node;
        if (n < 0) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + n + ") less than zero.");
        }
        if (!bl && n == this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + n + ") is the size of the list.");
        }
        if (n > this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + n + ") greater than the size of the " + "list (" + this.size + ").");
        }
        if (n < this.size / 2) {
            node = this.header.next;
            for (int i = 0; i < n; ++i) {
                node = node.next;
            }
        } else {
            node = this.header;
            for (int i = this.size; i > n; --i) {
                node = node.previous;
            }
        }
        return node;
    }

    protected Iterator createSubListIterator(LinkedSubList linkedSubList) {
        return this.createSubListListIterator(linkedSubList, 0);
    }

    protected ListIterator createSubListListIterator(LinkedSubList linkedSubList, int n) {
        return new LinkedSubListIterator(linkedSubList, n);
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    protected void doReadObject(ObjectInputStream objectInputStream) {
        this.init();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(objectInputStream.readObject());
        }
    }

    protected static class LinkedSubList
    extends AbstractList {
        AbstractLinkedList parent;
        int offset;
        int size;
        int expectedModCount;

        protected LinkedSubList(AbstractLinkedList abstractLinkedList, int n, int n2) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + n);
            }
            if (n2 > abstractLinkedList.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + n2);
            }
            if (n > n2) {
                throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
            }
            this.parent = abstractLinkedList;
            this.offset = n;
            this.size = n2 - n;
            this.expectedModCount = abstractLinkedList.modCount;
        }

        public int size() {
            this.checkModCount();
            return this.size;
        }

        public Object get(int n) {
            this.rangeCheck(n, this.size);
            this.checkModCount();
            return this.parent.get(n + this.offset);
        }

        public void add(int n, Object object) {
            this.rangeCheck(n, this.size + 1);
            this.checkModCount();
            this.parent.add(n + this.offset, object);
            this.expectedModCount = this.parent.modCount;
            ++this.size;
            ++this.modCount;
        }

        public Object remove(int n) {
            this.rangeCheck(n, this.size);
            this.checkModCount();
            Object object = this.parent.remove(n + this.offset);
            this.expectedModCount = this.parent.modCount;
            --this.size;
            ++this.modCount;
            return object;
        }

        public boolean addAll(Collection collection) {
            return this.addAll(this.size, collection);
        }

        public boolean addAll(int n, Collection collection) {
            this.rangeCheck(n, this.size + 1);
            int n2 = collection.size();
            if (n2 == 0) {
                return false;
            }
            this.checkModCount();
            this.parent.addAll(this.offset + n, collection);
            this.expectedModCount = this.parent.modCount;
            this.size += n2;
            ++this.modCount;
            return true;
        }

        public Object set(int n, Object object) {
            this.rangeCheck(n, this.size);
            this.checkModCount();
            return this.parent.set(n + this.offset, object);
        }

        public void clear() {
            this.checkModCount();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }

        public Iterator iterator() {
            this.checkModCount();
            return this.parent.createSubListIterator(this);
        }

        public ListIterator listIterator(int n) {
            this.rangeCheck(n, this.size + 1);
            this.checkModCount();
            return this.parent.createSubListListIterator(this, n);
        }

        public List subList(int n, int n2) {
            return new LinkedSubList(this.parent, n + this.offset, n2 + this.offset);
        }

        protected void rangeCheck(int n, int n2) {
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException("Index '" + n + "' out of bounds for size '" + this.size + "'");
            }
        }

        protected void checkModCount() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static class LinkedSubListIterator
    extends LinkedListIterator {
        protected final LinkedSubList sub;

        protected LinkedSubListIterator(LinkedSubList linkedSubList, int n) {
            super(linkedSubList.parent, n + linkedSubList.offset);
            this.sub = linkedSubList;
        }

        public boolean hasNext() {
            return this.nextIndex() < this.sub.size;
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public int nextIndex() {
            return super.nextIndex() - this.sub.offset;
        }

        public void add(Object object) {
            super.add(object);
            this.sub.expectedModCount = this.parent.modCount;
            ++this.sub.size;
        }

        public void remove() {
            super.remove();
            this.sub.expectedModCount = this.parent.modCount;
            --this.sub.size;
        }
    }

    protected static class LinkedListIterator
    implements ListIterator,
    OrderedIterator {
        protected final AbstractLinkedList parent;
        protected Node next;
        protected int nextIndex;
        protected Node current;
        protected int expectedModCount;

        protected LinkedListIterator(AbstractLinkedList abstractLinkedList, int n) {
            this.parent = abstractLinkedList;
            this.expectedModCount = abstractLinkedList.modCount;
            this.next = abstractLinkedList.getNode(n, true);
            this.nextIndex = n;
        }

        protected void checkModCount() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        protected Node getLastNodeReturned() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current;
        }

        public boolean hasNext() {
            return this.next != this.parent.header;
        }

        public Object next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index " + this.nextIndex + ".");
            }
            Object object = this.next.getValue();
            this.current = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return object;
        }

        public boolean hasPrevious() {
            return this.next.previous != this.parent.header;
        }

        public Object previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Already at start of list.");
            }
            this.next = this.next.previous;
            Object object = this.next.getValue();
            this.current = this.next;
            --this.nextIndex;
            return object;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        public void remove() {
            this.checkModCount();
            if (this.current == this.next) {
                this.next = this.next.next;
                this.parent.removeNode(this.getLastNodeReturned());
            } else {
                this.parent.removeNode(this.getLastNodeReturned());
                --this.nextIndex;
            }
            this.current = null;
            ++this.expectedModCount;
        }

        public void set(Object object) {
            this.checkModCount();
            this.getLastNodeReturned().setValue(object);
        }

        public void add(Object object) {
            this.checkModCount();
            this.parent.addNodeBefore(this.next, object);
            this.current = null;
            ++this.nextIndex;
            ++this.expectedModCount;
        }
    }

    protected static class Node {
        protected Node previous;
        protected Node next;
        protected Object value;

        protected Node() {
            this.previous = this;
            this.next = this;
        }

        protected Node(Object object) {
            this.value = object;
        }

        protected Node(Node node, Node node2, Object object) {
            this.previous = node;
            this.next = node2;
            this.value = object;
        }

        protected Object getValue() {
            return this.value;
        }

        protected void setValue(Object object) {
            this.value = object;
        }

        protected Node getPreviousNode() {
            return this.previous;
        }

        protected void setPreviousNode(Node node) {
            this.previous = node;
        }

        protected Node getNextNode() {
            return this.next;
        }

        protected void setNextNode(Node node) {
            this.next = node;
        }
    }
}

