/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.keyvalue;

import java.io.Serializable;
import java.util.Arrays;

public class MultiKey
implements Serializable {
    private static final long serialVersionUID = 4465448607415788805L;
    private final Object[] keys;
    private final int hashCode;

    public MultiKey(Object object, Object object2) {
        this(new Object[]{object, object2}, false);
    }

    public MultiKey(Object object, Object object2, Object object3) {
        this(new Object[]{object, object2, object3}, false);
    }

    public MultiKey(Object object, Object object2, Object object3, Object object4) {
        this(new Object[]{object, object2, object3, object4}, false);
    }

    public MultiKey(Object object, Object object2, Object object3, Object object4, Object object5) {
        this(new Object[]{object, object2, object3, object4, object5}, false);
    }

    public MultiKey(Object[] objectArray) {
        this(objectArray, true);
    }

    public MultiKey(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        this.keys = bl ? (Object[])objectArray.clone() : objectArray;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            n ^= objectArray[i].hashCode();
        }
        this.hashCode = n;
    }

    public Object[] getKeys() {
        return (Object[])this.keys.clone();
    }

    public Object getKey(int n) {
        return this.keys[n];
    }

    public int size() {
        return this.keys.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MultiKey) {
            MultiKey multiKey = (MultiKey)object;
            return Arrays.equals(this.keys, multiKey.keys);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "MultiKey" + Arrays.asList(this.keys).toString();
    }
}

