/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.Unmodifiable;

public final class UnmodifiableOrderedMapIterator
implements OrderedMapIterator,
Unmodifiable {
    private OrderedMapIterator iterator;

    public static OrderedMapIterator decorate(OrderedMapIterator orderedMapIterator) {
        if (orderedMapIterator == null) {
            throw new IllegalArgumentException("OrderedMapIterator must not be null");
        }
        if (orderedMapIterator instanceof Unmodifiable) {
            return orderedMapIterator;
        }
        return new UnmodifiableOrderedMapIterator(orderedMapIterator);
    }

    private UnmodifiableOrderedMapIterator(OrderedMapIterator orderedMapIterator) {
        this.iterator = orderedMapIterator;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    public Object previous() {
        return this.iterator.previous();
    }

    public Object getKey() {
        return this.iterator.getKey();
    }

    public Object getValue() {
        return this.iterator.getValue();
    }

    public Object setValue(Object object) {
        throw new UnsupportedOperationException("setValue() is not supported");
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }
}

