/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.Unmodifiable;

public final class UnmodifiableMapIterator
implements MapIterator,
Unmodifiable {
    private MapIterator iterator;

    public static MapIterator decorate(MapIterator mapIterator) {
        if (mapIterator == null) {
            throw new IllegalArgumentException("MapIterator must not be null");
        }
        if (mapIterator instanceof Unmodifiable) {
            return mapIterator;
        }
        return new UnmodifiableMapIterator(mapIterator);
    }

    private UnmodifiableMapIterator(MapIterator mapIterator) {
        this.iterator = mapIterator;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public Object getKey() {
        return this.iterator.getKey();
    }

    public Object getValue() {
        return this.iterator.getValue();
    }

    public Object setValue(Object object) {
        throw new UnsupportedOperationException("setValue() is not supported");
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }
}

