/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public class WhileClosure
implements Serializable,
Closure {
    private static final long serialVersionUID = -3110538116913760108L;
    private final Predicate iPredicate;
    private final Closure iClosure;
    private final boolean iDoLoop;

    public static Closure getInstance(Predicate predicate, Closure closure, boolean bl) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        if (closure == null) {
            throw new IllegalArgumentException("Closure must not be null");
        }
        return new WhileClosure(predicate, closure, bl);
    }

    public WhileClosure(Predicate predicate, Closure closure, boolean bl) {
        this.iPredicate = predicate;
        this.iClosure = closure;
        this.iDoLoop = bl;
    }

    public void execute(Object object) {
        if (this.iDoLoop) {
            this.iClosure.execute(object);
        }
        while (this.iPredicate.evaluate(object)) {
            this.iClosure.execute(object);
        }
    }

    public Predicate getPredicate() {
        return this.iPredicate;
    }

    public Closure getClosure() {
        return this.iClosure;
    }

    public boolean isDoLoop() {
        return this.iDoLoop;
    }
}

