/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.NOPClosure;

public class SwitchClosure
implements Serializable,
Closure {
    private static final long serialVersionUID = 3518477308466486130L;
    private final Predicate[] iPredicates;
    private final Closure[] iClosures;
    private final Closure iDefault;

    public static Closure getInstance(Predicate[] predicateArray, Closure[] closureArray, Closure closure) {
        FunctorUtils.validate(predicateArray);
        FunctorUtils.validate(closureArray);
        if (predicateArray.length != closureArray.length) {
            throw new IllegalArgumentException("The predicate and closure arrays must be the same size");
        }
        if (predicateArray.length == 0) {
            return closure == null ? NOPClosure.INSTANCE : closure;
        }
        predicateArray = FunctorUtils.copy(predicateArray);
        closureArray = FunctorUtils.copy(closureArray);
        return new SwitchClosure(predicateArray, closureArray, closure);
    }

    public static Closure getInstance(Map map) {
        Closure[] closureArray = null;
        Predicate[] predicateArray = null;
        if (map == null) {
            throw new IllegalArgumentException("The predicate and closure map must not be null");
        }
        if (map.size() == 0) {
            return NOPClosure.INSTANCE;
        }
        Closure closure = (Closure)map.remove(null);
        int n = map.size();
        if (n == 0) {
            return closure == null ? NOPClosure.INSTANCE : closure;
        }
        closureArray = new Closure[n];
        predicateArray = new Predicate[n];
        int n2 = 0;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            predicateArray[n2] = (Predicate)entry.getKey();
            closureArray[n2] = (Closure)entry.getValue();
            ++n2;
        }
        return new SwitchClosure(predicateArray, closureArray, closure);
    }

    public SwitchClosure(Predicate[] predicateArray, Closure[] closureArray, Closure closure) {
        this.iPredicates = predicateArray;
        this.iClosures = closureArray;
        this.iDefault = closure == null ? NOPClosure.INSTANCE : closure;
    }

    public void execute(Object object) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].evaluate(object)) continue;
            this.iClosures[i].execute(object);
            return;
        }
        this.iDefault.execute(object);
    }

    public Predicate[] getPredicates() {
        return this.iPredicates;
    }

    public Closure[] getClosures() {
        return this.iClosures;
    }

    public Closure getDefaultClosure() {
        return this.iDefault;
    }
}

