/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;

public class InstantiateFactory
implements Serializable,
Factory {
    private static final long serialVersionUID = -7732226881069447957L;
    private final Class iClassToInstantiate;
    private final Class[] iParamTypes;
    private final Object[] iArgs;
    private transient Constructor iConstructor = null;

    public static Factory getInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class to instantiate must not be null");
        }
        if (classArray == null && objectArray != null || classArray != null && objectArray == null || classArray != null && objectArray != null && classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Parameter types must match the arguments");
        }
        if (classArray == null || classArray.length == 0) {
            return new InstantiateFactory(clazz);
        }
        classArray = (Class[])classArray.clone();
        objectArray = (Object[])objectArray.clone();
        return new InstantiateFactory(clazz, classArray, objectArray);
    }

    public InstantiateFactory(Class clazz) {
        this.iClassToInstantiate = clazz;
        this.iParamTypes = null;
        this.iArgs = null;
        this.findConstructor();
    }

    public InstantiateFactory(Class clazz, Class[] classArray, Object[] objectArray) {
        this.iClassToInstantiate = clazz;
        this.iParamTypes = classArray;
        this.iArgs = objectArray;
        this.findConstructor();
    }

    private void findConstructor() {
        try {
            this.iConstructor = this.iClassToInstantiate.getConstructor(this.iParamTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("InstantiateFactory: The constructor must exist and be public ");
        }
    }

    public Object create() {
        if (this.iConstructor == null) {
            this.findConstructor();
        }
        try {
            return this.iConstructor.newInstance(this.iArgs);
        }
        catch (InstantiationException instantiationException) {
            throw new FunctorException("InstantiateFactory: InstantiationException", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FunctorException("InstantiateFactory: Constructor must be public", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FunctorException("InstantiateFactory: Constructor threw an exception", invocationTargetException);
        }
    }
}

