/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NOPClosure;

public class IfClosure
implements Serializable,
Closure {
    private static final long serialVersionUID = 3518477308466486130L;
    private final Predicate iPredicate;
    private final Closure iTrueClosure;
    private final Closure iFalseClosure;

    public static Closure getInstance(Predicate predicate, Closure closure) {
        return IfClosure.getInstance(predicate, closure, NOPClosure.INSTANCE);
    }

    public static Closure getInstance(Predicate predicate, Closure closure, Closure closure2) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        if (closure == null || closure2 == null) {
            throw new IllegalArgumentException("Closures must not be null");
        }
        return new IfClosure(predicate, closure, closure2);
    }

    public IfClosure(Predicate predicate, Closure closure) {
        this(predicate, closure, NOPClosure.INSTANCE);
    }

    public IfClosure(Predicate predicate, Closure closure, Closure closure2) {
        this.iPredicate = predicate;
        this.iTrueClosure = closure;
        this.iFalseClosure = closure2;
    }

    public void execute(Object object) {
        if (this.iPredicate.evaluate(object)) {
            this.iTrueClosure.execute(object);
        } else {
            this.iFalseClosure.execute(object);
        }
    }

    public Predicate getPredicate() {
        return this.iPredicate;
    }

    public Closure getTrueClosure() {
        return this.iTrueClosure;
    }

    public Closure getFalseClosure() {
        return this.iFalseClosure;
    }
}

