/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.NOPTransformer;

public class ChainedTransformer
implements Serializable,
Transformer {
    private static final long serialVersionUID = 3514945074733160196L;
    private final Transformer[] iTransformers;

    public static Transformer getInstance(Transformer[] transformerArray) {
        FunctorUtils.validate(transformerArray);
        if (transformerArray.length == 0) {
            return NOPTransformer.INSTANCE;
        }
        transformerArray = FunctorUtils.copy(transformerArray);
        return new ChainedTransformer(transformerArray);
    }

    public static Transformer getInstance(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Transformer collection must not be null");
        }
        if (collection.size() == 0) {
            return NOPTransformer.INSTANCE;
        }
        Transformer[] transformerArray = new Transformer[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            transformerArray[n++] = (Transformer)iterator.next();
        }
        FunctorUtils.validate(transformerArray);
        return new ChainedTransformer(transformerArray);
    }

    public static Transformer getInstance(Transformer transformer, Transformer transformer2) {
        if (transformer == null || transformer2 == null) {
            throw new IllegalArgumentException("Transformers must not be null");
        }
        Transformer[] transformerArray = new Transformer[]{transformer, transformer2};
        return new ChainedTransformer(transformerArray);
    }

    public ChainedTransformer(Transformer[] transformerArray) {
        this.iTransformers = transformerArray;
    }

    public Object transform(Object object) {
        for (int i = 0; i < this.iTransformers.length; ++i) {
            object = this.iTransformers[i].transform(object);
        }
        return object;
    }

    public Transformer[] getTransformers() {
        return this.iTransformers;
    }
}

