/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.NOPClosure;

public class ChainedClosure
implements Serializable,
Closure {
    private static final long serialVersionUID = -3520677225766901240L;
    private final Closure[] iClosures;

    public static Closure getInstance(Closure[] closureArray) {
        FunctorUtils.validate(closureArray);
        if (closureArray.length == 0) {
            return NOPClosure.INSTANCE;
        }
        closureArray = FunctorUtils.copy(closureArray);
        return new ChainedClosure(closureArray);
    }

    public static Closure getInstance(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Closure collection must not be null");
        }
        if (collection.size() == 0) {
            return NOPClosure.INSTANCE;
        }
        Closure[] closureArray = new Closure[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            closureArray[n++] = (Closure)iterator.next();
        }
        FunctorUtils.validate(closureArray);
        return new ChainedClosure(closureArray);
    }

    public static Closure getInstance(Closure closure, Closure closure2) {
        if (closure == null || closure2 == null) {
            throw new IllegalArgumentException("Closures must not be null");
        }
        Closure[] closureArray = new Closure[]{closure, closure2};
        return new ChainedClosure(closureArray);
    }

    public ChainedClosure(Closure[] closureArray) {
        this.iClosures = closureArray;
    }

    public void execute(Object object) {
        for (int i = 0; i < this.iClosures.length; ++i) {
            this.iClosures[i].execute(object);
        }
    }

    public Closure[] getClosures() {
        return this.iClosures;
    }
}

