/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FalsePredicate;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.PredicateDecorator;

public final class AnyPredicate
implements Serializable,
Predicate,
PredicateDecorator {
    private static final long serialVersionUID = 7429999530934647542L;
    private final Predicate[] iPredicates;

    public static Predicate getInstance(Predicate[] predicateArray) {
        FunctorUtils.validate(predicateArray);
        if (predicateArray.length == 0) {
            return FalsePredicate.INSTANCE;
        }
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        return new AnyPredicate(FunctorUtils.copy(predicateArray));
    }

    public static Predicate getInstance(Collection collection) {
        Predicate[] predicateArray = FunctorUtils.validate(collection);
        if (predicateArray.length == 0) {
            return FalsePredicate.INSTANCE;
        }
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        return new AnyPredicate(predicateArray);
    }

    public AnyPredicate(Predicate[] predicateArray) {
        this.iPredicates = predicateArray;
    }

    public boolean evaluate(Object object) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].evaluate(object)) continue;
            return true;
        }
        return false;
    }

    public Predicate[] getPredicates() {
        return this.iPredicates;
    }
}

