/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.PredicateDecorator;
import org.apache.commons.collections.functors.TruePredicate;

public final class AllPredicate
implements Serializable,
Predicate,
PredicateDecorator {
    private static final long serialVersionUID = -3094696765038308799L;
    private final Predicate[] iPredicates;

    public static Predicate getInstance(Predicate[] predicateArray) {
        FunctorUtils.validate(predicateArray);
        if (predicateArray.length == 0) {
            return TruePredicate.INSTANCE;
        }
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        predicateArray = FunctorUtils.copy(predicateArray);
        return new AllPredicate(predicateArray);
    }

    public static Predicate getInstance(Collection collection) {
        Predicate[] predicateArray = FunctorUtils.validate(collection);
        if (predicateArray.length == 0) {
            return TruePredicate.INSTANCE;
        }
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        return new AllPredicate(predicateArray);
    }

    public AllPredicate(Predicate[] predicateArray) {
        this.iPredicates = predicateArray;
    }

    public boolean evaluate(Object object) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (this.iPredicates[i].evaluate(object)) continue;
            return false;
        }
        return true;
    }

    public Predicate[] getPredicates() {
        return this.iPredicates;
    }
}

