/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.comparators;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FixedOrderComparator
implements Comparator {
    public static final int UNKNOWN_BEFORE = 0;
    public static final int UNKNOWN_AFTER = 1;
    public static final int UNKNOWN_THROW_EXCEPTION = 2;
    private final Map map = new HashMap();
    private int counter = 0;
    private boolean isLocked = false;
    private int unknownObjectBehavior = 2;

    public FixedOrderComparator() {
    }

    public FixedOrderComparator(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("The list of items must not be null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
    }

    public FixedOrderComparator(List list) {
        if (list == null) {
            throw new IllegalArgumentException("The list of items must not be null");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    protected void checkLocked() {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("Cannot modify a FixedOrderComparator after a comparison");
        }
    }

    public int getUnknownObjectBehavior() {
        return this.unknownObjectBehavior;
    }

    public void setUnknownObjectBehavior(int n) {
        this.checkLocked();
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("Unrecognised value for unknown behaviour flag");
        }
        this.unknownObjectBehavior = n;
    }

    public boolean add(Object object) {
        this.checkLocked();
        Integer n = this.map.put(object, new Integer(this.counter++));
        return n == null;
    }

    public boolean addAsEqual(Object object, Object object2) {
        this.checkLocked();
        Integer n = (Integer)this.map.get(object);
        if (n == null) {
            throw new IllegalArgumentException(object + " not known to " + this);
        }
        Integer n2 = this.map.put(object2, n);
        return n2 == null;
    }

    public int compare(Object object, Object object2) {
        this.isLocked = true;
        Integer n = (Integer)this.map.get(object);
        Integer n2 = (Integer)this.map.get(object2);
        if (n == null || n2 == null) {
            switch (this.unknownObjectBehavior) {
                case 0: {
                    if (n == null) {
                        return n2 == null ? 0 : -1;
                    }
                    return 1;
                }
                case 1: {
                    if (n == null) {
                        return n2 == null ? 0 : 1;
                    }
                    return -1;
                }
                case 2: {
                    Object object3 = n == null ? object : object2;
                    throw new IllegalArgumentException("Attempting to compare unknown object " + object3);
                }
            }
            throw new UnsupportedOperationException("Unknown unknownObjectBehavior: " + this.unknownObjectBehavior);
        }
        return n.compareTo(n2);
    }
}

