/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.collection;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.collection.AbstractSerializableCollectionDecorator;
import org.apache.commons.collections.collection.SynchronizedCollection;
import org.apache.commons.collections.iterators.UnmodifiableIterator;

public final class UnmodifiableBoundedCollection
extends AbstractSerializableCollectionDecorator
implements BoundedCollection {
    private static final long serialVersionUID = -7112672385450340330L;

    public static BoundedCollection decorate(BoundedCollection boundedCollection) {
        return new UnmodifiableBoundedCollection(boundedCollection);
    }

    public static BoundedCollection decorateUsing(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The collection must not be null");
        }
        for (int i = 0; i < 1000 && !(collection instanceof BoundedCollection); ++i) {
            if (collection instanceof AbstractCollectionDecorator) {
                collection = ((AbstractCollectionDecorator)collection).collection;
                continue;
            }
            if (!(collection instanceof SynchronizedCollection)) break;
            collection = ((SynchronizedCollection)collection).collection;
        }
        if (!(collection instanceof BoundedCollection)) {
            throw new IllegalArgumentException("The collection is not a bounded collection");
        }
        return new UnmodifiableBoundedCollection((BoundedCollection)collection);
    }

    private UnmodifiableBoundedCollection(BoundedCollection boundedCollection) {
        super(boundedCollection);
    }

    public Iterator iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean isFull() {
        return ((BoundedCollection)this.collection).isFull();
    }

    public int maxSize() {
        return ((BoundedCollection)this.collection).maxSize();
    }
}

