/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class UnboundedFifoBuffer
extends AbstractCollection
implements Serializable,
Buffer {
    private static final long serialVersionUID = -3482960336579541419L;
    protected transient Object[] buffer;
    protected transient int head;
    protected transient int tail;

    public UnboundedFifoBuffer() {
        this(32);
    }

    public UnboundedFifoBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.buffer = new Object[n + 1];
        this.head = 0;
        this.tail = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.buffer = new Object[n + 1];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = objectInputStream.readObject();
        }
        this.head = 0;
        this.tail = n;
    }

    public int size() {
        int n = 0;
        n = this.tail < this.head ? this.buffer.length - this.head + this.tail : this.tail - this.head;
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() + 1 >= this.buffer.length) {
            Object[] objectArray = new Object[(this.buffer.length - 1) * 2 + 1];
            int n = 0;
            int n2 = this.head;
            while (n2 != this.tail) {
                objectArray[n] = this.buffer[n2];
                this.buffer[n2] = null;
                ++n;
                n2 = this.increment(n2);
            }
            this.buffer = objectArray;
            this.head = 0;
            this.tail = n;
        }
        this.buffer[this.tail] = object;
        this.tail = this.increment(this.tail);
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.buffer[this.head];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.buffer[this.head];
        if (object != null) {
            this.buffer[this.head] = null;
            this.head = this.increment(this.head);
        }
        return object;
    }

    private int increment(int n) {
        if (++n >= this.buffer.length) {
            n = 0;
        }
        return n;
    }

    private int decrement(int n) {
        if (--n < 0) {
            n = this.buffer.length - 1;
        }
        return n;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private int index;
            private int lastReturnedIndex;
            private final UnboundedFifoBuffer this$0;
            {
                this.this$0 = unboundedFifoBuffer;
                this.index = this.this$0.head;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index != this.this$0.tail;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index;
                this.index = UnboundedFifoBuffer.access$000(this.this$0, this.index);
                return this.this$0.buffer[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == this.this$0.head) {
                    this.this$0.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n = UnboundedFifoBuffer.access$000(this.this$0, this.lastReturnedIndex);
                while (n != this.this$0.tail) {
                    this.this$0.buffer[UnboundedFifoBuffer.access$100((UnboundedFifoBuffer)this.this$0, (int)n)] = this.this$0.buffer[n];
                    n = UnboundedFifoBuffer.access$000(this.this$0, n);
                }
                this.lastReturnedIndex = -1;
                this.this$0.tail = UnboundedFifoBuffer.access$100(this.this$0, this.this$0.tail);
                this.this$0.buffer[this.this$0.tail] = null;
                this.index = UnboundedFifoBuffer.access$100(this.this$0, this.index);
            }
        };
    }

    static int access$000(UnboundedFifoBuffer unboundedFifoBuffer, int n) {
        return unboundedFifoBuffer.increment(n);
    }

    static int access$100(UnboundedFifoBuffer unboundedFifoBuffer, int n) {
        return unboundedFifoBuffer.decrement(n);
    }
}

