/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class PriorityBuffer
extends AbstractCollection
implements Serializable,
Buffer {
    private static final long serialVersionUID = 6891186490470027896L;
    private static final int DEFAULT_CAPACITY = 13;
    protected Object[] elements;
    protected int size;
    protected boolean ascendingOrder;
    protected Comparator comparator;

    public PriorityBuffer() {
        this(13, true, null);
    }

    public PriorityBuffer(Comparator comparator) {
        this(13, true, comparator);
    }

    public PriorityBuffer(boolean bl) {
        this(13, bl, null);
    }

    public PriorityBuffer(boolean bl, Comparator comparator) {
        this(13, bl, comparator);
    }

    public PriorityBuffer(int n) {
        this(n, true, null);
    }

    public PriorityBuffer(int n, Comparator comparator) {
        this(n, true, comparator);
    }

    public PriorityBuffer(int n, boolean bl) {
        this(n, bl, null);
    }

    public PriorityBuffer(int n, boolean bl, Comparator comparator) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.ascendingOrder = bl;
        this.elements = new Object[n + 1];
        this.comparator = comparator;
    }

    public boolean isAscendingOrder() {
        return this.ascendingOrder;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.elements = new Object[this.elements.length];
        this.size = 0;
    }

    public boolean add(Object object) {
        if (this.isAtCapacity()) {
            this.grow();
        }
        if (this.ascendingOrder) {
            this.percolateUpMinHeap(object);
        } else {
            this.percolateUpMaxHeap(object);
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException();
        }
        return this.elements[1];
    }

    public Object remove() {
        Object object = this.get();
        this.elements[1] = this.elements[this.size--];
        this.elements[this.size + 1] = null;
        if (this.size != 0) {
            if (this.ascendingOrder) {
                this.percolateDownMinHeap(1);
            } else {
                this.percolateDownMaxHeap(1);
            }
        }
        return object;
    }

    protected boolean isAtCapacity() {
        return this.elements.length == this.size + 1;
    }

    protected void percolateDownMinHeap(int n) {
        Object object = this.elements[n];
        int n2 = n;
        while (n2 * 2 <= this.size) {
            int n3 = n2 * 2;
            if (n3 != this.size && this.compare(this.elements[n3 + 1], this.elements[n3]) < 0) {
                ++n3;
            }
            if (this.compare(this.elements[n3], object) >= 0) break;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateDownMaxHeap(int n) {
        Object object = this.elements[n];
        int n2 = n;
        while (n2 * 2 <= this.size) {
            int n3 = n2 * 2;
            if (n3 != this.size && this.compare(this.elements[n3 + 1], this.elements[n3]) > 0) {
                ++n3;
            }
            if (this.compare(this.elements[n3], object) <= 0) break;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateUpMinHeap(int n) {
        int n2 = n;
        Object object = this.elements[n2];
        while (n2 > 1 && this.compare(object, this.elements[n2 / 2]) < 0) {
            int n3 = n2 / 2;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateUpMinHeap(Object object) {
        this.elements[++this.size] = object;
        this.percolateUpMinHeap(this.size);
    }

    protected void percolateUpMaxHeap(int n) {
        int n2 = n;
        Object object = this.elements[n2];
        while (n2 > 1 && this.compare(object, this.elements[n2 / 2]) > 0) {
            int n3 = n2 / 2;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateUpMaxHeap(Object object) {
        this.elements[++this.size] = object;
        this.percolateUpMaxHeap(this.size);
    }

    protected int compare(Object object, Object object2) {
        if (this.comparator != null) {
            return this.comparator.compare(object, object2);
        }
        return ((Comparable)object).compareTo(object2);
    }

    protected void grow() {
        Object[] objectArray = new Object[this.elements.length * 2];
        System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
        this.elements = objectArray;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private int index;
            private int lastReturnedIndex;
            private final PriorityBuffer this$0;
            {
                this.this$0 = priorityBuffer;
                this.index = 1;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index <= this.this$0.size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index++;
                return this.this$0.elements[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                this.this$0.elements[this.lastReturnedIndex] = this.this$0.elements[this.this$0.size];
                this.this$0.elements[this.this$0.size] = null;
                --this.this$0.size;
                if (this.this$0.size != 0 && this.lastReturnedIndex <= this.this$0.size) {
                    int n = 0;
                    if (this.lastReturnedIndex > 1) {
                        n = this.this$0.compare(this.this$0.elements[this.lastReturnedIndex], this.this$0.elements[this.lastReturnedIndex / 2]);
                    }
                    if (this.this$0.ascendingOrder) {
                        if (this.lastReturnedIndex > 1 && n < 0) {
                            this.this$0.percolateUpMinHeap(this.lastReturnedIndex);
                        } else {
                            this.this$0.percolateDownMinHeap(this.lastReturnedIndex);
                        }
                    } else if (this.lastReturnedIndex > 1 && n > 0) {
                        this.this$0.percolateUpMaxHeap(this.lastReturnedIndex);
                    } else {
                        this.this$0.percolateDownMaxHeap(this.lastReturnedIndex);
                    }
                }
                --this.index;
                this.lastReturnedIndex = -1;
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        for (int i = 1; i < this.size + 1; ++i) {
            if (i != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

