/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferOverflowException;
import org.apache.commons.collections.BufferUnderflowException;

public class BoundedFifoBuffer
extends AbstractCollection
implements Serializable,
BoundedCollection,
Buffer {
    private static final long serialVersionUID = 5603722811189451017L;
    private transient Object[] elements;
    private transient int start = 0;
    private transient int end = 0;
    private transient boolean full = false;
    private final int maxElements;

    public BoundedFifoBuffer() {
        this(32);
    }

    public BoundedFifoBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.elements = new Object[n];
        this.maxElements = this.elements.length;
    }

    public BoundedFifoBuffer(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.elements = new Object[this.maxElements];
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.elements[i] = objectInputStream.readObject();
        }
        this.start = 0;
        this.full = n == this.maxElements;
        this.end = this.full ? 0 : n;
    }

    public int size() {
        int n = 0;
        n = this.end < this.start ? this.maxElements - this.start + this.end : (this.end == this.start ? (this.full ? this.maxElements : 0) : this.end - this.start);
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.size() == this.maxElements;
    }

    public int maxSize() {
        return this.maxElements;
    }

    public void clear() {
        this.full = false;
        this.start = 0;
        this.end = 0;
        Arrays.fill(this.elements, null);
    }

    public boolean add(Object object) {
        if (null == object) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.full) {
            throw new BufferOverflowException("The buffer cannot hold more than " + this.maxElements + " objects.");
        }
        this.elements[this.end++] = object;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.elements[this.start];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.elements[this.start];
        if (null != object) {
            this.elements[this.start++] = null;
            if (this.start >= this.maxElements) {
                this.start = 0;
            }
            this.full = false;
        }
        return object;
    }

    private int increment(int n) {
        if (++n >= this.maxElements) {
            n = 0;
        }
        return n;
    }

    private int decrement(int n) {
        if (--n < 0) {
            n = this.maxElements - 1;
        }
        return n;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private int index;
            private int lastReturnedIndex;
            private boolean isFirst;
            private final BoundedFifoBuffer this$0;
            {
                this.this$0 = boundedFifoBuffer;
                this.index = BoundedFifoBuffer.access$000(this.this$0);
                this.lastReturnedIndex = -1;
                this.isFirst = BoundedFifoBuffer.access$100(this.this$0);
            }

            public boolean hasNext() {
                return this.isFirst || this.index != BoundedFifoBuffer.access$200(this.this$0);
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isFirst = false;
                this.lastReturnedIndex = this.index;
                this.index = BoundedFifoBuffer.access$300(this.this$0, this.index);
                return BoundedFifoBuffer.access$400(this.this$0)[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == BoundedFifoBuffer.access$000(this.this$0)) {
                    this.this$0.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n = this.lastReturnedIndex + 1;
                if (BoundedFifoBuffer.access$000(this.this$0) < this.lastReturnedIndex && n < BoundedFifoBuffer.access$200(this.this$0)) {
                    System.arraycopy(BoundedFifoBuffer.access$400(this.this$0), n, BoundedFifoBuffer.access$400(this.this$0), this.lastReturnedIndex, BoundedFifoBuffer.access$200(this.this$0) - n);
                } else {
                    while (n != BoundedFifoBuffer.access$200(this.this$0)) {
                        if (n >= BoundedFifoBuffer.access$500(this.this$0)) {
                            BoundedFifoBuffer.access$400((BoundedFifoBuffer)this.this$0)[n - 1] = BoundedFifoBuffer.access$400(this.this$0)[0];
                            n = 0;
                            continue;
                        }
                        BoundedFifoBuffer.access$400((BoundedFifoBuffer)this.this$0)[BoundedFifoBuffer.access$600((BoundedFifoBuffer)this.this$0, (int)n)] = BoundedFifoBuffer.access$400(this.this$0)[n];
                        n = BoundedFifoBuffer.access$300(this.this$0, n);
                    }
                }
                this.lastReturnedIndex = -1;
                BoundedFifoBuffer.access$202(this.this$0, BoundedFifoBuffer.access$600(this.this$0, BoundedFifoBuffer.access$200(this.this$0)));
                BoundedFifoBuffer.access$400((BoundedFifoBuffer)this.this$0)[BoundedFifoBuffer.access$200((BoundedFifoBuffer)this.this$0)] = null;
                BoundedFifoBuffer.access$102(this.this$0, false);
                this.index = BoundedFifoBuffer.access$600(this.this$0, this.index);
            }
        };
    }

    static int access$000(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.start;
    }

    static boolean access$100(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.full;
    }

    static int access$200(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.end;
    }

    static int access$300(BoundedFifoBuffer boundedFifoBuffer, int n) {
        return boundedFifoBuffer.increment(n);
    }

    static Object[] access$400(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.elements;
    }

    static int access$500(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.maxElements;
    }

    static int access$600(BoundedFifoBuffer boundedFifoBuffer, int n) {
        return boundedFifoBuffer.decrement(n);
    }

    static int access$202(BoundedFifoBuffer boundedFifoBuffer, int n) {
        boundedFifoBuffer.end = n;
        return boundedFifoBuffer.end;
    }

    static boolean access$102(BoundedFifoBuffer boundedFifoBuffer, boolean bl) {
        boundedFifoBuffer.full = bl;
        return boundedFifoBuffer.full;
    }
}

