/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferOverflowException;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.buffer.SynchronizedBuffer;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;

public class BoundedBuffer
extends SynchronizedBuffer
implements BoundedCollection {
    private static final long serialVersionUID = 1536432911093974264L;
    private final int maximumSize;
    private final long timeout;

    public static BoundedBuffer decorate(Buffer buffer, int n) {
        return new BoundedBuffer(buffer, n, 0L);
    }

    public static BoundedBuffer decorate(Buffer buffer, int n, long l) {
        return new BoundedBuffer(buffer, n, l);
    }

    protected BoundedBuffer(Buffer buffer, int n, long l) {
        super(buffer);
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.maximumSize = n;
        this.timeout = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.getBuffer().remove();
            this.lock.notifyAll();
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.timeoutWait(1);
            return this.getBuffer().add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        Object object = this.lock;
        synchronized (object) {
            this.timeoutWait(collection.size());
            return this.getBuffer().addAll(collection);
        }
    }

    public Iterator iterator() {
        return new NotifyingIterator(this, this.collection.iterator());
    }

    private void timeoutWait(int n) {
        if (n > this.maximumSize) {
            throw new BufferOverflowException("Buffer size cannot exceed " + this.maximumSize);
        }
        if (this.timeout <= 0L) {
            if (this.getBuffer().size() + n > this.maximumSize) {
                throw new BufferOverflowException("Buffer size cannot exceed " + this.maximumSize);
            }
            return;
        }
        long l = System.currentTimeMillis() + this.timeout;
        long l2 = l - System.currentTimeMillis();
        while (l2 > 0L && this.getBuffer().size() + n > this.maximumSize) {
            try {
                this.lock.wait(l2);
                l2 = l - System.currentTimeMillis();
            }
            catch (InterruptedException interruptedException) {
                PrintWriter printWriter = new PrintWriter(new StringWriter());
                interruptedException.printStackTrace(printWriter);
                throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
            }
        }
        if (this.getBuffer().size() + n > this.maximumSize) {
            throw new BufferOverflowException("Timeout expired");
        }
    }

    public boolean isFull() {
        return this.size() == this.maxSize();
    }

    public int maxSize() {
        return this.maximumSize;
    }

    static Object access$000(BoundedBuffer boundedBuffer) {
        return boundedBuffer.lock;
    }

    static Object access$100(BoundedBuffer boundedBuffer) {
        return boundedBuffer.lock;
    }

    private class NotifyingIterator
    extends AbstractIteratorDecorator {
        private final BoundedBuffer this$0;

        public NotifyingIterator(BoundedBuffer boundedBuffer, Iterator iterator) {
            super(iterator);
            this.this$0 = boundedBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Object object = BoundedBuffer.access$000(this.this$0);
            synchronized (object) {
                this.iterator.remove();
                BoundedBuffer.access$100(this.this$0).notifyAll();
            }
        }
    }
}

