/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.buffer.SynchronizedBuffer;

public class BlockingBuffer
extends SynchronizedBuffer {
    private static final long serialVersionUID = 1719328905017860541L;
    private final long timeout;

    public static Buffer decorate(Buffer buffer) {
        return new BlockingBuffer(buffer);
    }

    public static Buffer decorate(Buffer buffer, long l) {
        return new BlockingBuffer(buffer, l);
    }

    protected BlockingBuffer(Buffer buffer) {
        super(buffer);
        this.timeout = 0L;
    }

    protected BlockingBuffer(Buffer buffer, long l) {
        super(buffer);
        this.timeout = l < 0L ? 0L : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            boolean bl = this.collection.add(object);
            this.lock.notifyAll();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.collection.addAll(collection);
            this.lock.notifyAll();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    if (this.timeout <= 0L) {
                        this.lock.wait();
                        continue;
                    }
                    return this.get(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            return this.getBuffer().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long l) {
        Object object = this.lock;
        synchronized (object) {
            long l2 = System.currentTimeMillis() + l;
            long l3 = l2 - System.currentTimeMillis();
            while (l3 > 0L && this.collection.isEmpty()) {
                try {
                    this.lock.wait(l3);
                    l3 = l2 - System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            if (this.collection.isEmpty()) {
                throw new BufferUnderflowException("Timeout expired");
            }
            return this.getBuffer().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    if (this.timeout <= 0L) {
                        this.lock.wait();
                        continue;
                    }
                    return this.remove(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            return this.getBuffer().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long l) {
        Object object = this.lock;
        synchronized (object) {
            long l2 = System.currentTimeMillis() + l;
            long l3 = l2 - System.currentTimeMillis();
            while (l3 > 0L && this.collection.isEmpty()) {
                try {
                    this.lock.wait(l3);
                    l3 = l2 - System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            if (this.collection.isEmpty()) {
                throw new BufferUnderflowException("Timeout expired");
            }
            return this.getBuffer().remove();
        }
    }
}

