/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.collections.OrderedIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections.keyvalue.UnmodifiableMapEntry;

public class TreeBidiMap
implements OrderedBidiMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int MAPENTRY = 2;
    private static final int INVERSEMAPENTRY = 3;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[2];
    private int nodeCount = 0;
    private int modifications = 0;
    private Set keySet;
    private Set valuesSet;
    private Set entrySet;
    private Inverse inverse = null;

    public TreeBidiMap() {
    }

    public TreeBidiMap(Map map) {
        this.putAll(map);
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public boolean containsKey(Object object) {
        TreeBidiMap.checkKey(object);
        return this.lookup((Comparable)object, 0) != null;
    }

    public boolean containsValue(Object object) {
        TreeBidiMap.checkValue(object);
        return this.lookup((Comparable)object, 1) != null;
    }

    public Object get(Object object) {
        return this.doGet((Comparable)object, 0);
    }

    public Object put(Object object, Object object2) {
        return this.doPut((Comparable)object, (Comparable)object2, 0);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        return this.doRemove((Comparable)object, 0);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public Object getKey(Object object) {
        return this.doGet((Comparable)object, 1);
    }

    public Object removeValue(Object object) {
        return this.doRemove((Comparable)object, 1);
    }

    public Object firstKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.leastNode(this.rootNode[0], 0).getKey();
    }

    public Object lastKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.greatestNode(this.rootNode[0], 0).getKey();
    }

    public Object nextKey(Object object) {
        TreeBidiMap.checkKey(object);
        Node node = this.nextGreater(this.lookup((Comparable)object, 0), 0);
        return node == null ? null : node.getKey();
    }

    public Object previousKey(Object object) {
        TreeBidiMap.checkKey(object);
        Node node = this.nextSmaller(this.lookup((Comparable)object, 0), 0);
        return node == null ? null : node.getKey();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new View(this, 0, 0);
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesSet == null) {
            this.valuesSet = new View(this, 0, 1);
        }
        return this.valuesSet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            return new EntryView(this, 0, 2);
        }
        return this.entrySet;
    }

    public MapIterator mapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public OrderedMapIterator orderedMapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public BidiMap inverseBidiMap() {
        return this.inverseOrderedBidiMap();
    }

    public OrderedBidiMap inverseOrderedBidiMap() {
        if (this.inverse == null) {
            this.inverse = new Inverse(this);
        }
        return this.inverse;
    }

    public boolean equals(Object object) {
        return this.doEquals(object, 0);
    }

    public int hashCode() {
        return this.doHashCode(0);
    }

    public String toString() {
        return this.doToString(0);
    }

    private Object doGet(Comparable comparable, int n) {
        TreeBidiMap.checkNonNullComparable(comparable, n);
        Node node = this.lookup(comparable, n);
        return node == null ? null : Node.access$000(node, TreeBidiMap.oppositeIndex(n));
    }

    private Object doPut(Comparable comparable, Comparable comparable2, int n) {
        Object object;
        block6: {
            TreeBidiMap.checkKeyAndValue(comparable, comparable2);
            object = n == 0 ? this.doGet(comparable, 0) : this.doGet(comparable2, 1);
            this.doRemove(comparable, 0);
            this.doRemove(comparable2, 1);
            Node node = this.rootNode[0];
            if (node == null) {
                Node node2;
                this.rootNode[0] = node2 = new Node(comparable, comparable2);
                this.rootNode[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n2;
                    if ((n2 = TreeBidiMap.compare(comparable, Node.access$000(node, 0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + comparable + "\") in this Map");
                    }
                    if (n2 < 0) {
                        if (Node.access$100(node, 0) != null) {
                            node = Node.access$100(node, 0);
                            continue;
                        }
                        Node node3 = new Node(comparable, comparable2);
                        this.insertValue(node3);
                        Node.access$200(node, node3, 0);
                        Node.access$300(node3, node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (Node.access$400(node, 0) == null) break;
                    node = Node.access$400(node, 0);
                }
                Node node4 = new Node(comparable, comparable2);
                this.insertValue(node4);
                Node.access$500(node, node4, 0);
                Node.access$300(node4, node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return object;
    }

    private Object doRemove(Comparable comparable, int n) {
        Node node = this.lookup(comparable, n);
        Comparable comparable2 = null;
        if (node != null) {
            comparable2 = Node.access$000(node, TreeBidiMap.oppositeIndex(n));
            this.doRedBlackDelete(node);
        }
        return comparable2;
    }

    private Node lookup(Comparable comparable, int n) {
        Node node = null;
        Node node2 = this.rootNode[n];
        while (node2 != null) {
            int n2 = TreeBidiMap.compare(comparable, Node.access$000(node2, n));
            if (n2 == 0) {
                node = node2;
                break;
            }
            node2 = n2 < 0 ? Node.access$100(node2, n) : Node.access$400(node2, n);
        }
        return node;
    }

    private Node nextGreater(Node node, int n) {
        Node node2 = null;
        if (node == null) {
            node2 = null;
        } else if (Node.access$400(node, n) != null) {
            node2 = TreeBidiMap.leastNode(Node.access$400(node, n), n);
        } else {
            Node node3 = Node.access$600(node, n);
            Node node4 = node;
            while (node3 != null && node4 == Node.access$400(node3, n)) {
                node4 = node3;
                node3 = Node.access$600(node3, n);
            }
            node2 = node3;
        }
        return node2;
    }

    private Node nextSmaller(Node node, int n) {
        Node node2 = null;
        if (node == null) {
            node2 = null;
        } else if (Node.access$100(node, n) != null) {
            node2 = TreeBidiMap.greatestNode(Node.access$100(node, n), n);
        } else {
            Node node3 = Node.access$600(node, n);
            Node node4 = node;
            while (node3 != null && node4 == Node.access$100(node3, n)) {
                node4 = node3;
                node3 = Node.access$600(node3, n);
            }
            node2 = node3;
        }
        return node2;
    }

    private static int oppositeIndex(int n) {
        return 1 - n;
    }

    private static int compare(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    private static Node leastNode(Node node, int n) {
        Node node2 = node;
        if (node2 != null) {
            while (Node.access$100(node2, n) != null) {
                node2 = Node.access$100(node2, n);
            }
        }
        return node2;
    }

    private static Node greatestNode(Node node, int n) {
        Node node2 = node;
        if (node2 != null) {
            while (Node.access$400(node2, n) != null) {
                node2 = Node.access$400(node2, n);
            }
        }
        return node2;
    }

    private static void copyColor(Node node, Node node2, int n) {
        if (node2 != null) {
            if (node == null) {
                Node.access$700(node2, n);
            } else {
                Node.access$800(node2, node, n);
            }
        }
    }

    private static boolean isRed(Node node, int n) {
        return node == null ? false : Node.access$900(node, n);
    }

    private static boolean isBlack(Node node, int n) {
        return node == null ? true : Node.access$1000(node, n);
    }

    private static void makeRed(Node node, int n) {
        if (node != null) {
            Node.access$1100(node, n);
        }
    }

    private static void makeBlack(Node node, int n) {
        if (node != null) {
            Node.access$700(node, n);
        }
    }

    private static Node getGrandParent(Node node, int n) {
        return TreeBidiMap.getParent(TreeBidiMap.getParent(node, n), n);
    }

    private static Node getParent(Node node, int n) {
        return node == null ? null : Node.access$600(node, n);
    }

    private static Node getRightChild(Node node, int n) {
        return node == null ? null : Node.access$400(node, n);
    }

    private static Node getLeftChild(Node node, int n) {
        return node == null ? null : Node.access$100(node, n);
    }

    private static boolean isLeftChild(Node node, int n) {
        return node == null ? true : (Node.access$600(node, n) == null ? false : node == Node.access$100(Node.access$600(node, n), n));
    }

    private static boolean isRightChild(Node node, int n) {
        return node == null ? true : (Node.access$600(node, n) == null ? false : node == Node.access$400(Node.access$600(node, n), n));
    }

    private void rotateLeft(Node node, int n) {
        Node node2 = Node.access$400(node, n);
        Node.access$500(node, Node.access$100(node2, n), n);
        if (Node.access$100(node2, n) != null) {
            Node.access$300(Node.access$100(node2, n), node, n);
        }
        Node.access$300(node2, Node.access$600(node, n), n);
        if (Node.access$600(node, n) == null) {
            this.rootNode[n] = node2;
        } else if (Node.access$100(Node.access$600(node, n), n) == node) {
            Node.access$200(Node.access$600(node, n), node2, n);
        } else {
            Node.access$500(Node.access$600(node, n), node2, n);
        }
        Node.access$200(node2, node, n);
        Node.access$300(node, node2, n);
    }

    private void rotateRight(Node node, int n) {
        Node node2 = Node.access$100(node, n);
        Node.access$200(node, Node.access$400(node2, n), n);
        if (Node.access$400(node2, n) != null) {
            Node.access$300(Node.access$400(node2, n), node, n);
        }
        Node.access$300(node2, Node.access$600(node, n), n);
        if (Node.access$600(node, n) == null) {
            this.rootNode[n] = node2;
        } else if (Node.access$400(Node.access$600(node, n), n) == node) {
            Node.access$500(Node.access$600(node, n), node2, n);
        } else {
            Node.access$200(Node.access$600(node, n), node2, n);
        }
        Node.access$500(node2, node, n);
        Node.access$300(node, node2, n);
    }

    private void doRedBlackInsert(Node node, int n) {
        Node node2 = node;
        TreeBidiMap.makeRed(node2, n);
        while (node2 != null && node2 != this.rootNode[n] && TreeBidiMap.isRed(Node.access$600(node2, n), n)) {
            Node node3;
            if (TreeBidiMap.isLeftChild(TreeBidiMap.getParent(node2, n), n)) {
                node3 = TreeBidiMap.getRightChild(TreeBidiMap.getGrandParent(node2, n), n);
                if (TreeBidiMap.isRed(node3, n)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getParent(node2, n), n);
                    TreeBidiMap.makeBlack(node3, n);
                    TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node2, n), n);
                    node2 = TreeBidiMap.getGrandParent(node2, n);
                    continue;
                }
                if (TreeBidiMap.isRightChild(node2, n)) {
                    node2 = TreeBidiMap.getParent(node2, n);
                    this.rotateLeft(node2, n);
                }
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(node2, n), n);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node2, n), n);
                if (TreeBidiMap.getGrandParent(node2, n) == null) continue;
                this.rotateRight(TreeBidiMap.getGrandParent(node2, n), n);
                continue;
            }
            node3 = TreeBidiMap.getLeftChild(TreeBidiMap.getGrandParent(node2, n), n);
            if (TreeBidiMap.isRed(node3, n)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(node2, n), n);
                TreeBidiMap.makeBlack(node3, n);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node2, n), n);
                node2 = TreeBidiMap.getGrandParent(node2, n);
                continue;
            }
            if (TreeBidiMap.isLeftChild(node2, n)) {
                node2 = TreeBidiMap.getParent(node2, n);
                this.rotateRight(node2, n);
            }
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(node2, n), n);
            TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node2, n), n);
            if (TreeBidiMap.getGrandParent(node2, n) == null) continue;
            this.rotateLeft(TreeBidiMap.getGrandParent(node2, n), n);
        }
        TreeBidiMap.makeBlack(this.rootNode[n], n);
    }

    private void doRedBlackDelete(Node node) {
        for (int i = 0; i < 2; ++i) {
            Node node2;
            if (Node.access$100(node, i) != null && Node.access$400(node, i) != null) {
                this.swapPosition(this.nextGreater(node, i), node, i);
            }
            Node node3 = node2 = Node.access$100(node, i) != null ? Node.access$100(node, i) : Node.access$400(node, i);
            if (node2 != null) {
                Node.access$300(node2, Node.access$600(node, i), i);
                if (Node.access$600(node, i) == null) {
                    this.rootNode[i] = node2;
                } else if (node == Node.access$100(Node.access$600(node, i), i)) {
                    Node.access$200(Node.access$600(node, i), node2, i);
                } else {
                    Node.access$500(Node.access$600(node, i), node2, i);
                }
                Node.access$200(node, null, i);
                Node.access$500(node, null, i);
                Node.access$300(node, null, i);
                if (!TreeBidiMap.isBlack(node, i)) continue;
                this.doRedBlackDeleteFixup(node2, i);
                continue;
            }
            if (Node.access$600(node, i) == null) {
                this.rootNode[i] = null;
                continue;
            }
            if (TreeBidiMap.isBlack(node, i)) {
                this.doRedBlackDeleteFixup(node, i);
            }
            if (Node.access$600(node, i) == null) continue;
            if (node == Node.access$100(Node.access$600(node, i), i)) {
                Node.access$200(Node.access$600(node, i), null, i);
            } else {
                Node.access$500(Node.access$600(node, i), null, i);
            }
            Node.access$300(node, null, i);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node node, int n) {
        Node node2 = node;
        while (node2 != this.rootNode[n] && TreeBidiMap.isBlack(node2, n)) {
            Node node3;
            if (TreeBidiMap.isLeftChild(node2, n)) {
                node3 = TreeBidiMap.getRightChild(TreeBidiMap.getParent(node2, n), n);
                if (TreeBidiMap.isRed(node3, n)) {
                    TreeBidiMap.makeBlack(node3, n);
                    TreeBidiMap.makeRed(TreeBidiMap.getParent(node2, n), n);
                    this.rotateLeft(TreeBidiMap.getParent(node2, n), n);
                    node3 = TreeBidiMap.getRightChild(TreeBidiMap.getParent(node2, n), n);
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(node3, n), n) && TreeBidiMap.isBlack(TreeBidiMap.getRightChild(node3, n), n)) {
                    TreeBidiMap.makeRed(node3, n);
                    node2 = TreeBidiMap.getParent(node2, n);
                    continue;
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(node3, n), n)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(node3, n), n);
                    TreeBidiMap.makeRed(node3, n);
                    this.rotateRight(node3, n);
                    node3 = TreeBidiMap.getRightChild(TreeBidiMap.getParent(node2, n), n);
                }
                TreeBidiMap.copyColor(TreeBidiMap.getParent(node2, n), node3, n);
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(node2, n), n);
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(node3, n), n);
                this.rotateLeft(TreeBidiMap.getParent(node2, n), n);
                node2 = this.rootNode[n];
                continue;
            }
            node3 = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(node2, n), n);
            if (TreeBidiMap.isRed(node3, n)) {
                TreeBidiMap.makeBlack(node3, n);
                TreeBidiMap.makeRed(TreeBidiMap.getParent(node2, n), n);
                this.rotateRight(TreeBidiMap.getParent(node2, n), n);
                node3 = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(node2, n), n);
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(node3, n), n) && TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(node3, n), n)) {
                TreeBidiMap.makeRed(node3, n);
                node2 = TreeBidiMap.getParent(node2, n);
                continue;
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(node3, n), n)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(node3, n), n);
                TreeBidiMap.makeRed(node3, n);
                this.rotateLeft(node3, n);
                node3 = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(node2, n), n);
            }
            TreeBidiMap.copyColor(TreeBidiMap.getParent(node2, n), node3, n);
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(node2, n), n);
            TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(node3, n), n);
            this.rotateRight(TreeBidiMap.getParent(node2, n), n);
            node2 = this.rootNode[n];
        }
        TreeBidiMap.makeBlack(node2, n);
    }

    private void swapPosition(Node node, Node node2, int n) {
        boolean bl;
        Node node3 = Node.access$600(node, n);
        Node node4 = Node.access$100(node, n);
        Node node5 = Node.access$400(node, n);
        Node node6 = Node.access$600(node2, n);
        Node node7 = Node.access$100(node2, n);
        Node node8 = Node.access$400(node2, n);
        boolean bl2 = Node.access$600(node, n) != null && node == Node.access$100(Node.access$600(node, n), n);
        boolean bl3 = bl = Node.access$600(node2, n) != null && node2 == Node.access$100(Node.access$600(node2, n), n);
        if (node == node6) {
            Node.access$300(node, node2, n);
            if (bl) {
                Node.access$200(node2, node, n);
                Node.access$500(node2, node5, n);
            } else {
                Node.access$500(node2, node, n);
                Node.access$200(node2, node4, n);
            }
        } else {
            Node.access$300(node, node6, n);
            if (node6 != null) {
                if (bl) {
                    Node.access$200(node6, node, n);
                } else {
                    Node.access$500(node6, node, n);
                }
            }
            Node.access$200(node2, node4, n);
            Node.access$500(node2, node5, n);
        }
        if (node2 == node3) {
            Node.access$300(node2, node, n);
            if (bl2) {
                Node.access$200(node, node2, n);
                Node.access$500(node, node8, n);
            } else {
                Node.access$500(node, node2, n);
                Node.access$200(node, node7, n);
            }
        } else {
            Node.access$300(node2, node3, n);
            if (node3 != null) {
                if (bl2) {
                    Node.access$200(node3, node2, n);
                } else {
                    Node.access$500(node3, node2, n);
                }
            }
            Node.access$200(node, node7, n);
            Node.access$500(node, node8, n);
        }
        if (Node.access$100(node, n) != null) {
            Node.access$300(Node.access$100(node, n), node, n);
        }
        if (Node.access$400(node, n) != null) {
            Node.access$300(Node.access$400(node, n), node, n);
        }
        if (Node.access$100(node2, n) != null) {
            Node.access$300(Node.access$100(node2, n), node2, n);
        }
        if (Node.access$400(node2, n) != null) {
            Node.access$300(Node.access$400(node2, n), node2, n);
        }
        Node.access$1200(node, node2, n);
        if (this.rootNode[n] == node) {
            this.rootNode[n] = node2;
        } else if (this.rootNode[n] == node2) {
            this.rootNode[n] = node;
        }
    }

    private static void checkNonNullComparable(Object object, int n) {
        if (object == null) {
            throw new NullPointerException(dataName[n] + " cannot be null");
        }
        if (!(object instanceof Comparable)) {
            throw new ClassCastException(dataName[n] + " must be Comparable");
        }
    }

    private static void checkKey(Object object) {
        TreeBidiMap.checkNonNullComparable(object, 0);
    }

    private static void checkValue(Object object) {
        TreeBidiMap.checkNonNullComparable(object, 1);
    }

    private static void checkKeyAndValue(Object object, Object object2) {
        TreeBidiMap.checkKey(object);
        TreeBidiMap.checkValue(object2);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node node) {
        block4: {
            Node node2 = this.rootNode[1];
            while (true) {
                int n;
                if ((n = TreeBidiMap.compare(Node.access$000(node, 1), Node.access$000(node2, 1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + Node.access$000(node, 1) + "\") in this Map");
                }
                if (n < 0) {
                    if (Node.access$100(node2, 1) != null) {
                        node2 = Node.access$100(node2, 1);
                        continue;
                    }
                    Node.access$200(node2, node, 1);
                    Node.access$300(node, node2, 1);
                    this.doRedBlackInsert(node, 1);
                    break block4;
                }
                if (Node.access$400(node2, 1) == null) break;
                node2 = Node.access$400(node2, 1);
            }
            Node.access$500(node2, node, 1);
            Node.access$300(node, node2, 1);
            this.doRedBlackInsert(node, 1);
        }
    }

    private boolean doEquals(Object object, int n) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        if (this.nodeCount > 0) {
            try {
                ViewMapIterator viewMapIterator = new ViewMapIterator(this, n);
                while (viewMapIterator.hasNext()) {
                    Object object2 = viewMapIterator.next();
                    Object object3 = viewMapIterator.getValue();
                    if (object3.equals(map.get(object2))) continue;
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return true;
    }

    private int doHashCode(int n) {
        int n2 = 0;
        if (this.nodeCount > 0) {
            ViewMapIterator viewMapIterator = new ViewMapIterator(this, n);
            while (viewMapIterator.hasNext()) {
                Object object = viewMapIterator.next();
                Object object2 = viewMapIterator.getValue();
                n2 += object.hashCode() ^ object2.hashCode();
            }
        }
        return n2;
    }

    private String doToString(int n) {
        if (this.nodeCount == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(this.nodeCount * 32);
        stringBuffer.append('{');
        ViewMapIterator viewMapIterator = new ViewMapIterator(this, n);
        boolean bl = viewMapIterator.hasNext();
        while (bl) {
            Object object = viewMapIterator.next();
            Object object2 = viewMapIterator.getValue();
            stringBuffer.append(object == this ? "(this Map)" : object).append('=').append(object2 == this ? "(this Map)" : object2);
            bl = viewMapIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static void access$1300(Object object, int n) {
        TreeBidiMap.checkNonNullComparable(object, n);
    }

    static Node access$1400(TreeBidiMap treeBidiMap, Comparable comparable, int n) {
        return treeBidiMap.lookup(comparable, n);
    }

    static Object access$1500(TreeBidiMap treeBidiMap, Comparable comparable, int n) {
        return treeBidiMap.doRemove(comparable, n);
    }

    static int access$1600(TreeBidiMap treeBidiMap) {
        return treeBidiMap.modifications;
    }

    static Node[] access$1700(TreeBidiMap treeBidiMap) {
        return treeBidiMap.rootNode;
    }

    static Node access$1800(Node node, int n) {
        return TreeBidiMap.leastNode(node, n);
    }

    static Node access$1900(TreeBidiMap treeBidiMap, Node node, int n) {
        return treeBidiMap.nextGreater(node, n);
    }

    static Node access$2000(TreeBidiMap treeBidiMap, Node node, int n) {
        return treeBidiMap.nextSmaller(node, n);
    }

    static void access$2100(TreeBidiMap treeBidiMap, Node node) {
        treeBidiMap.doRedBlackDelete(node);
    }

    static Node access$2200(Node node, int n) {
        return TreeBidiMap.greatestNode(node, n);
    }

    static int access$2300(int n) {
        return TreeBidiMap.oppositeIndex(n);
    }

    static int access$2400(TreeBidiMap treeBidiMap) {
        return treeBidiMap.nodeCount;
    }

    static void access$2500(Object object) {
        TreeBidiMap.checkKey(object);
    }

    static Object access$2600(TreeBidiMap treeBidiMap, Comparable comparable, Comparable comparable2, int n) {
        return treeBidiMap.doPut(comparable, comparable2, n);
    }

    static boolean access$2700(TreeBidiMap treeBidiMap, Object object, int n) {
        return treeBidiMap.doEquals(object, n);
    }

    static int access$2800(TreeBidiMap treeBidiMap, int n) {
        return treeBidiMap.doHashCode(n);
    }

    static String access$2900(TreeBidiMap treeBidiMap, int n) {
        return treeBidiMap.doToString(n);
    }

    static class Inverse
    implements OrderedBidiMap {
        private final TreeBidiMap main;
        private Set keySet;
        private Set valuesSet;
        private Set entrySet;

        Inverse(TreeBidiMap treeBidiMap) {
            this.main = treeBidiMap;
        }

        public int size() {
            return this.main.size();
        }

        public boolean isEmpty() {
            return this.main.isEmpty();
        }

        public Object get(Object object) {
            return this.main.getKey(object);
        }

        public Object getKey(Object object) {
            return this.main.get(object);
        }

        public boolean containsKey(Object object) {
            return this.main.containsValue(object);
        }

        public boolean containsValue(Object object) {
            return this.main.containsKey(object);
        }

        public Object firstKey() {
            if (TreeBidiMap.access$2400(this.main) == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.access$1800(TreeBidiMap.access$1700(this.main)[1], 1).getValue();
        }

        public Object lastKey() {
            if (TreeBidiMap.access$2400(this.main) == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.access$2200(TreeBidiMap.access$1700(this.main)[1], 1).getValue();
        }

        public Object nextKey(Object object) {
            TreeBidiMap.access$2500(object);
            Node node = TreeBidiMap.access$1900(this.main, TreeBidiMap.access$1400(this.main, (Comparable)object, 1), 1);
            return node == null ? null : node.getValue();
        }

        public Object previousKey(Object object) {
            TreeBidiMap.access$2500(object);
            Node node = TreeBidiMap.access$2000(this.main, TreeBidiMap.access$1400(this.main, (Comparable)object, 1), 1);
            return node == null ? null : node.getValue();
        }

        public Object put(Object object, Object object2) {
            return TreeBidiMap.access$2600(this.main, (Comparable)object2, (Comparable)object, 1);
        }

        public void putAll(Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object object) {
            return this.main.removeValue(object);
        }

        public Object removeValue(Object object) {
            return this.main.remove(object);
        }

        public void clear() {
            this.main.clear();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = new View(this.main, 1, 1);
            }
            return this.keySet;
        }

        public Collection values() {
            if (this.valuesSet == null) {
                this.valuesSet = new View(this.main, 1, 0);
            }
            return this.valuesSet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                return new EntryView(this.main, 1, 3);
            }
            return this.entrySet;
        }

        public MapIterator mapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public OrderedMapIterator orderedMapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public BidiMap inverseBidiMap() {
            return this.main;
        }

        public OrderedBidiMap inverseOrderedBidiMap() {
            return this.main;
        }

        public boolean equals(Object object) {
            return TreeBidiMap.access$2700(this.main, object, 1);
        }

        public int hashCode() {
            return TreeBidiMap.access$2800(this.main, 1);
        }

        public String toString() {
            return TreeBidiMap.access$2900(this.main, 1);
        }
    }

    static class Node
    implements Map.Entry,
    KeyValue {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable comparable, Comparable comparable2) {
            this.data = new Comparable[]{comparable, comparable2};
            this.leftNode = new Node[2];
            this.rightNode = new Node[2];
            this.parentNode = new Node[2];
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int n) {
            return this.data[n];
        }

        private void setLeft(Node node, int n) {
            this.leftNode[n] = node;
        }

        private Node getLeft(int n) {
            return this.leftNode[n];
        }

        private void setRight(Node node, int n) {
            this.rightNode[n] = node;
        }

        private Node getRight(int n) {
            return this.rightNode[n];
        }

        private void setParent(Node node, int n) {
            this.parentNode[n] = node;
        }

        private Node getParent(int n) {
            return this.parentNode[n];
        }

        private void swapColors(Node node, int n) {
            int n2 = n;
            this.blackColor[n2] = this.blackColor[n2] ^ node.blackColor[n];
            int n3 = n;
            node.blackColor[n3] = node.blackColor[n3] ^ this.blackColor[n];
            int n4 = n;
            this.blackColor[n4] = this.blackColor[n4] ^ node.blackColor[n];
        }

        private boolean isBlack(int n) {
            return this.blackColor[n];
        }

        private boolean isRed(int n) {
            return !this.blackColor[n];
        }

        private void setBlack(int n) {
            this.blackColor[n] = true;
        }

        private void setRed(int n) {
            this.blackColor[n] = false;
        }

        private void copyColor(Node node, int n) {
            this.blackColor[n] = node.blackColor[n];
        }

        public Object getKey() {
            return this.data[0];
        }

        public Object getValue() {
            return this.data[1];
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.data[0].equals(entry.getKey()) && this.data[1].equals(entry.getValue());
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }

        static Comparable access$000(Node node, int n) {
            return node.getData(n);
        }

        static Node access$100(Node node, int n) {
            return node.getLeft(n);
        }

        static void access$200(Node node, Node node2, int n) {
            node.setLeft(node2, n);
        }

        static void access$300(Node node, Node node2, int n) {
            node.setParent(node2, n);
        }

        static Node access$400(Node node, int n) {
            return node.getRight(n);
        }

        static void access$500(Node node, Node node2, int n) {
            node.setRight(node2, n);
        }

        static Node access$600(Node node, int n) {
            return node.getParent(n);
        }

        static void access$700(Node node, int n) {
            node.setBlack(n);
        }

        static void access$800(Node node, Node node2, int n) {
            node.copyColor(node2, n);
        }

        static boolean access$900(Node node, int n) {
            return node.isRed(n);
        }

        static boolean access$1000(Node node, int n) {
            return node.isBlack(n);
        }

        static void access$1100(Node node, int n) {
            node.setRed(n);
        }

        static void access$1200(Node node, Node node2, int n) {
            node.swapColors(node2, n);
        }
    }

    static class EntryView
    extends View {
        private final int oppositeType;

        EntryView(TreeBidiMap treeBidiMap, int n, int n2) {
            super(treeBidiMap, n, n2);
            this.oppositeType = TreeBidiMap.access$2300(n);
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = entry.getValue();
            Node node = TreeBidiMap.access$1400(this.main, (Comparable)entry.getKey(), this.orderType);
            return node != null && Node.access$000(node, this.oppositeType).equals(v);
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = entry.getValue();
            Node node = TreeBidiMap.access$1400(this.main, (Comparable)entry.getKey(), this.orderType);
            if (node != null && Node.access$000(node, this.oppositeType).equals(v)) {
                TreeBidiMap.access$2100(this.main, node);
                return true;
            }
            return false;
        }
    }

    static class ViewMapIterator
    extends ViewIterator
    implements OrderedMapIterator {
        private final int oppositeType;

        ViewMapIterator(TreeBidiMap treeBidiMap, int n) {
            super(treeBidiMap, n, n);
            this.oppositeType = TreeBidiMap.access$2300(this.dataType);
        }

        public Object getKey() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return Node.access$000(this.lastReturnedNode, this.dataType);
        }

        public Object getValue() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return Node.access$000(this.lastReturnedNode, this.oppositeType);
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    static class ViewIterator
    implements OrderedIterator {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;
        protected Node lastReturnedNode;
        protected Node nextNode;
        protected Node previousNode;
        private int expectedModifications;

        ViewIterator(TreeBidiMap treeBidiMap, int n, int n2) {
            this.main = treeBidiMap;
            this.orderType = n;
            this.dataType = n2;
            this.expectedModifications = TreeBidiMap.access$1600(treeBidiMap);
            this.nextNode = TreeBidiMap.access$1800(TreeBidiMap.access$1700(treeBidiMap)[n], n);
            this.lastReturnedNode = null;
            this.previousNode = null;
        }

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (TreeBidiMap.access$1600(this.main) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.previousNode = this.nextNode;
            this.nextNode = TreeBidiMap.access$1900(this.main, this.nextNode, this.orderType);
            return this.doGetData();
        }

        public boolean hasPrevious() {
            return this.previousNode != null;
        }

        public Object previous() {
            if (this.previousNode == null) {
                throw new NoSuchElementException();
            }
            if (TreeBidiMap.access$1600(this.main) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = this.lastReturnedNode;
            if (this.nextNode == null) {
                this.nextNode = TreeBidiMap.access$1900(this.main, this.previousNode, this.orderType);
            }
            this.lastReturnedNode = this.previousNode;
            this.previousNode = TreeBidiMap.access$2000(this.main, this.previousNode, this.orderType);
            return this.doGetData();
        }

        protected Object doGetData() {
            switch (this.dataType) {
                case 0: {
                    return this.lastReturnedNode.getKey();
                }
                case 1: {
                    return this.lastReturnedNode.getValue();
                }
                case 2: {
                    return this.lastReturnedNode;
                }
                case 3: {
                    return new UnmodifiableMapEntry(this.lastReturnedNode.getValue(), this.lastReturnedNode.getKey());
                }
            }
            return null;
        }

        public final void remove() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (TreeBidiMap.access$1600(this.main) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            TreeBidiMap.access$2100(this.main, this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
            this.previousNode = this.nextNode == null ? TreeBidiMap.access$2200(TreeBidiMap.access$1700(this.main)[this.orderType], this.orderType) : TreeBidiMap.access$2000(this.main, this.nextNode, this.orderType);
        }
    }

    static class View
    extends AbstractSet {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;

        View(TreeBidiMap treeBidiMap, int n, int n2) {
            this.main = treeBidiMap;
            this.orderType = n;
            this.dataType = n2;
        }

        public Iterator iterator() {
            return new ViewIterator(this.main, this.orderType, this.dataType);
        }

        public int size() {
            return this.main.size();
        }

        public boolean contains(Object object) {
            TreeBidiMap.access$1300(object, this.dataType);
            return TreeBidiMap.access$1400(this.main, (Comparable)object, this.dataType) != null;
        }

        public boolean remove(Object object) {
            return TreeBidiMap.access$1500(this.main, (Comparable)object, this.dataType) != null;
        }

        public void clear() {
            this.main.clear();
        }
    }
}

