/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.SortedBidiMap;
import org.apache.commons.collections.bidimap.AbstractDualBidiMap;
import org.apache.commons.collections.map.AbstractSortedMapDecorator;

public class DualTreeBidiMap
extends AbstractDualBidiMap
implements Serializable,
SortedBidiMap {
    private static final long serialVersionUID = 721969328361809L;
    protected final Comparator comparator;

    public DualTreeBidiMap() {
        super(new TreeMap(), new TreeMap());
        this.comparator = null;
    }

    public DualTreeBidiMap(Map map) {
        super(new TreeMap(), new TreeMap());
        this.putAll(map);
        this.comparator = null;
    }

    public DualTreeBidiMap(Comparator comparator) {
        super(new TreeMap(comparator), new TreeMap(comparator));
        this.comparator = comparator;
    }

    protected DualTreeBidiMap(Map map, Map map2, BidiMap bidiMap) {
        super(map, map2, bidiMap);
        this.comparator = ((SortedMap)map).comparator();
    }

    protected BidiMap createBidiMap(Map map, Map map2, BidiMap bidiMap) {
        return new DualTreeBidiMap(map, map2, bidiMap);
    }

    public Comparator comparator() {
        return ((SortedMap)this.maps[0]).comparator();
    }

    public Object firstKey() {
        return ((SortedMap)this.maps[0]).firstKey();
    }

    public Object lastKey() {
        return ((SortedMap)this.maps[0]).lastKey();
    }

    public Object nextKey(Object object) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.maps[0] instanceof OrderedMap) {
            return ((OrderedMap)this.maps[0]).nextKey(object);
        }
        SortedMap sortedMap = (SortedMap)this.maps[0];
        Iterator<Object> iterator = sortedMap.tailMap(object).keySet().iterator();
        iterator.next();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public Object previousKey(Object object) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.maps[0] instanceof OrderedMap) {
            return ((OrderedMap)this.maps[0]).previousKey(object);
        }
        SortedMap sortedMap = (SortedMap)this.maps[0];
        SortedMap sortedMap2 = sortedMap.headMap(object);
        if (sortedMap2.isEmpty()) {
            return null;
        }
        return sortedMap2.lastKey();
    }

    public OrderedMapIterator orderedMapIterator() {
        return new BidiOrderedMapIterator(this);
    }

    public SortedBidiMap inverseSortedBidiMap() {
        return (SortedBidiMap)this.inverseBidiMap();
    }

    public OrderedBidiMap inverseOrderedBidiMap() {
        return (OrderedBidiMap)this.inverseBidiMap();
    }

    public SortedMap headMap(Object object) {
        SortedMap sortedMap = ((SortedMap)this.maps[0]).headMap(object);
        return new ViewMap(this, sortedMap);
    }

    public SortedMap tailMap(Object object) {
        SortedMap sortedMap = ((SortedMap)this.maps[0]).tailMap(object);
        return new ViewMap(this, sortedMap);
    }

    public SortedMap subMap(Object object, Object object2) {
        SortedMap sortedMap = ((SortedMap)this.maps[0]).subMap(object, object2);
        return new ViewMap(this, sortedMap);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.maps[0]);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.maps[0] = new TreeMap(this.comparator);
        this.maps[1] = new TreeMap(this.comparator);
        Map map = (Map)objectInputStream.readObject();
        this.putAll(map);
    }

    protected static class BidiOrderedMapIterator
    implements OrderedMapIterator,
    ResettableIterator {
        protected final AbstractDualBidiMap parent;
        protected ListIterator iterator;
        private Map.Entry last = null;

        protected BidiOrderedMapIterator(AbstractDualBidiMap abstractDualBidiMap) {
            this.parent = abstractDualBidiMap;
            this.iterator = new ArrayList(abstractDualBidiMap.entrySet()).listIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = (Map.Entry)this.iterator.next();
            return this.last.getKey();
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            this.last = (Map.Entry)this.iterator.previous();
            return this.last.getKey();
        }

        public void remove() {
            this.iterator.remove();
            this.parent.remove(this.last.getKey());
            this.last = null;
        }

        public Object getKey() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return this.last.getKey();
        }

        public Object getValue() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return this.last.getValue();
        }

        public Object setValue(Object object) {
            if (this.last == null) {
                throw new IllegalStateException("Iterator setValue() can only be called after next() and before remove()");
            }
            if (this.parent.maps[1].containsKey(object) && this.parent.maps[1].get(object) != this.last.getKey()) {
                throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
            }
            return this.parent.put(this.last.getKey(), object);
        }

        public void reset() {
            this.iterator = new ArrayList(this.parent.entrySet()).listIterator();
            this.last = null;
        }

        public String toString() {
            if (this.last != null) {
                return "MapIterator[" + this.getKey() + "=" + this.getValue() + "]";
            }
            return "MapIterator[]";
        }
    }

    protected static class ViewMap
    extends AbstractSortedMapDecorator {
        final DualTreeBidiMap bidi;

        protected ViewMap(DualTreeBidiMap dualTreeBidiMap, SortedMap sortedMap) {
            super((SortedMap)((Object)dualTreeBidiMap.createBidiMap(sortedMap, dualTreeBidiMap.maps[1], dualTreeBidiMap.inverseBidiMap)));
            this.bidi = (DualTreeBidiMap)this.map;
        }

        public boolean containsValue(Object object) {
            return this.bidi.maps[0].containsValue(object);
        }

        public void clear() {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }

        public SortedMap headMap(Object object) {
            return new ViewMap(this.bidi, super.headMap(object));
        }

        public SortedMap tailMap(Object object) {
            return new ViewMap(this.bidi, super.tailMap(object));
        }

        public SortedMap subMap(Object object, Object object2) {
            return new ViewMap(this.bidi, super.subMap(object, object2));
        }
    }
}

