/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;

public abstract class AbstractDualBidiMap
implements BidiMap {
    protected final transient Map[] maps = new Map[2];
    protected transient BidiMap inverseBidiMap = null;
    protected transient Set keySet = null;
    protected transient Collection values = null;
    protected transient Set entrySet = null;

    protected AbstractDualBidiMap() {
        this.maps[0] = this.createMap();
        this.maps[1] = this.createMap();
    }

    protected AbstractDualBidiMap(Map map, Map map2) {
        this.maps[0] = map;
        this.maps[1] = map2;
    }

    protected AbstractDualBidiMap(Map map, Map map2, BidiMap bidiMap) {
        this.maps[0] = map;
        this.maps[1] = map2;
        this.inverseBidiMap = bidiMap;
    }

    protected Map createMap() {
        return null;
    }

    protected abstract BidiMap createBidiMap(Map var1, Map var2, BidiMap var3);

    public Object get(Object object) {
        return this.maps[0].get(object);
    }

    public int size() {
        return this.maps[0].size();
    }

    public boolean isEmpty() {
        return this.maps[0].isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.maps[0].containsKey(object);
    }

    public boolean equals(Object object) {
        return ((Object)this.maps[0]).equals(object);
    }

    public int hashCode() {
        return ((Object)this.maps[0]).hashCode();
    }

    public String toString() {
        return this.maps[0].toString();
    }

    public Object put(Object object, Object object2) {
        if (this.maps[0].containsKey(object)) {
            this.maps[1].remove(this.maps[0].get(object));
        }
        if (this.maps[1].containsKey(object2)) {
            this.maps[0].remove(this.maps[1].get(object2));
        }
        Object object3 = this.maps[0].put(object, object2);
        this.maps[1].put(object2, object);
        return object3;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Object var2_2 = null;
        if (this.maps[0].containsKey(object)) {
            var2_2 = this.maps[0].remove(object);
            this.maps[1].remove(var2_2);
        }
        return var2_2;
    }

    public void clear() {
        this.maps[0].clear();
        this.maps[1].clear();
    }

    public boolean containsValue(Object object) {
        return this.maps[1].containsKey(object);
    }

    public MapIterator mapIterator() {
        return new BidiMapIterator(this);
    }

    public Object getKey(Object object) {
        return this.maps[1].get(object);
    }

    public Object removeValue(Object object) {
        Object var2_2 = null;
        if (this.maps[1].containsKey(object)) {
            var2_2 = this.maps[1].remove(object);
            this.maps[0].remove(var2_2);
        }
        return var2_2;
    }

    public BidiMap inverseBidiMap() {
        if (this.inverseBidiMap == null) {
            this.inverseBidiMap = this.createBidiMap(this.maps[1], this.maps[0], this);
        }
        return this.inverseBidiMap;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator createKeySetIterator(Iterator iterator) {
        return new KeySetIterator(iterator, this);
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator createValuesIterator(Iterator iterator) {
        return new ValuesIterator(iterator, this);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator createEntrySetIterator(Iterator iterator) {
        return new EntrySetIterator(iterator, this);
    }

    protected static class BidiMapIterator
    implements MapIterator,
    ResettableIterator {
        protected final AbstractDualBidiMap parent;
        protected Iterator iterator;
        protected Map.Entry last = null;
        protected boolean canRemove = false;

        protected BidiMapIterator(AbstractDualBidiMap abstractDualBidiMap) {
            this.parent = abstractDualBidiMap;
            this.iterator = abstractDualBidiMap.maps[0].entrySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = (Map.Entry)this.iterator.next();
            this.canRemove = true;
            return this.last.getKey();
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            Object v = this.last.getValue();
            this.iterator.remove();
            this.parent.maps[1].remove(v);
            this.last = null;
            this.canRemove = false;
        }

        public Object getKey() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return this.last.getKey();
        }

        public Object getValue() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return this.last.getValue();
        }

        public Object setValue(Object object) {
            if (this.last == null) {
                throw new IllegalStateException("Iterator setValue() can only be called after next() and before remove()");
            }
            if (this.parent.maps[1].containsKey(object) && this.parent.maps[1].get(object) != this.last.getKey()) {
                throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
            }
            return this.parent.put(this.last.getKey(), object);
        }

        public void reset() {
            this.iterator = this.parent.maps[0].entrySet().iterator();
            this.last = null;
            this.canRemove = false;
        }

        public String toString() {
            if (this.last != null) {
                return "MapIterator[" + this.getKey() + "=" + this.getValue() + "]";
            }
            return "MapIterator[]";
        }
    }

    protected static class MapEntry
    extends AbstractMapEntryDecorator {
        protected final AbstractDualBidiMap parent;

        protected MapEntry(Map.Entry entry, AbstractDualBidiMap abstractDualBidiMap) {
            super(entry);
            this.parent = abstractDualBidiMap;
        }

        public Object setValue(Object object) {
            Object object2 = this.getKey();
            if (this.parent.maps[1].containsKey(object) && this.parent.maps[1].get(object) != object2) {
                throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
            }
            this.parent.put(object2, object);
            Object object3 = super.setValue(object);
            return object3;
        }
    }

    protected static class EntrySetIterator
    extends AbstractIteratorDecorator {
        protected final AbstractDualBidiMap parent;
        protected Map.Entry last = null;
        protected boolean canRemove = false;

        protected EntrySetIterator(Iterator iterator, AbstractDualBidiMap abstractDualBidiMap) {
            super(iterator);
            this.parent = abstractDualBidiMap;
        }

        public Object next() {
            this.last = new MapEntry((Map.Entry)super.next(), this.parent);
            this.canRemove = true;
            return this.last;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            Object v = this.last.getValue();
            super.remove();
            this.parent.maps[1].remove(v);
            this.last = null;
            this.canRemove = false;
        }
    }

    protected static class EntrySet
    extends View
    implements Set {
        protected EntrySet(AbstractDualBidiMap abstractDualBidiMap) {
            super(abstractDualBidiMap.maps[0].entrySet(), abstractDualBidiMap);
        }

        public Iterator iterator() {
            return this.parent.createEntrySetIterator(super.iterator());
        }

        public boolean remove(Object object) {
            Object v;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            if (this.parent.containsKey(k) && ((v = this.parent.maps[0].get(k)) == null ? entry.getValue() == null : v.equals(entry.getValue()))) {
                this.parent.maps[0].remove(k);
                this.parent.maps[1].remove(v);
                return true;
            }
            return false;
        }
    }

    protected static class ValuesIterator
    extends AbstractIteratorDecorator {
        protected final AbstractDualBidiMap parent;
        protected Object lastValue = null;
        protected boolean canRemove = false;

        protected ValuesIterator(Iterator iterator, AbstractDualBidiMap abstractDualBidiMap) {
            super(iterator);
            this.parent = abstractDualBidiMap;
        }

        public Object next() {
            this.lastValue = super.next();
            this.canRemove = true;
            return this.lastValue;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            super.remove();
            this.parent.maps[1].remove(this.lastValue);
            this.lastValue = null;
            this.canRemove = false;
        }
    }

    protected static class Values
    extends View
    implements Set {
        protected Values(AbstractDualBidiMap abstractDualBidiMap) {
            super(abstractDualBidiMap.maps[0].values(), abstractDualBidiMap);
        }

        public Iterator iterator() {
            return this.parent.createValuesIterator(super.iterator());
        }

        public boolean contains(Object object) {
            return this.parent.maps[1].containsKey(object);
        }

        public boolean remove(Object object) {
            if (this.parent.maps[1].containsKey(object)) {
                Object v = this.parent.maps[1].remove(object);
                this.parent.maps[0].remove(v);
                return true;
            }
            return false;
        }
    }

    protected static class KeySetIterator
    extends AbstractIteratorDecorator {
        protected final AbstractDualBidiMap parent;
        protected Object lastKey = null;
        protected boolean canRemove = false;

        protected KeySetIterator(Iterator iterator, AbstractDualBidiMap abstractDualBidiMap) {
            super(iterator);
            this.parent = abstractDualBidiMap;
        }

        public Object next() {
            this.lastKey = super.next();
            this.canRemove = true;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            Object v = this.parent.maps[0].get(this.lastKey);
            super.remove();
            this.parent.maps[1].remove(v);
            this.lastKey = null;
            this.canRemove = false;
        }
    }

    protected static class KeySet
    extends View
    implements Set {
        protected KeySet(AbstractDualBidiMap abstractDualBidiMap) {
            super(abstractDualBidiMap.maps[0].keySet(), abstractDualBidiMap);
        }

        public Iterator iterator() {
            return this.parent.createKeySetIterator(super.iterator());
        }

        public boolean contains(Object object) {
            return this.parent.maps[0].containsKey(object);
        }

        public boolean remove(Object object) {
            if (this.parent.maps[0].containsKey(object)) {
                Object v = this.parent.maps[0].remove(object);
                this.parent.maps[1].remove(v);
                return true;
            }
            return false;
        }
    }

    protected static abstract class View
    extends AbstractCollectionDecorator {
        protected final AbstractDualBidiMap parent;

        protected View(Collection collection, AbstractDualBidiMap abstractDualBidiMap) {
            super(collection);
            this.parent = abstractDualBidiMap;
        }

        public boolean removeAll(Collection collection) {
            if (this.parent.isEmpty() || collection.isEmpty()) {
                return false;
            }
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        public boolean retainAll(Collection collection) {
            if (this.parent.isEmpty()) {
                return false;
            }
            if (collection.isEmpty()) {
                this.parent.clear();
                return true;
            }
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        public void clear() {
            this.parent.clear();
        }
    }
}

