/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bag;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.SortedBag;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.bag.AbstractSortedBagDecorator;
import org.apache.commons.collections.iterators.UnmodifiableIterator;
import org.apache.commons.collections.set.UnmodifiableSet;

public final class UnmodifiableSortedBag
extends AbstractSortedBagDecorator
implements Serializable,
Unmodifiable {
    private static final long serialVersionUID = -3190437252665717841L;

    public static SortedBag decorate(SortedBag sortedBag) {
        if (sortedBag instanceof Unmodifiable) {
            return sortedBag;
        }
        return new UnmodifiableSortedBag(sortedBag);
    }

    private UnmodifiableSortedBag(SortedBag sortedBag) {
        super(sortedBag);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.collection);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.collection = (Collection)objectInputStream.readObject();
    }

    public Iterator iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    public Set uniqueSet() {
        Set set = this.getBag().uniqueSet();
        return UnmodifiableSet.decorate(set);
    }
}

