/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bag;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.bag.HashBag;
import org.apache.commons.collections.set.UnmodifiableSet;

public abstract class AbstractMapBag
implements Bag {
    private transient Map map;
    private int size;
    private transient int modCount;
    private transient Set uniqueSet;

    protected AbstractMapBag() {
    }

    protected AbstractMapBag(Map map) {
        this.map = map;
    }

    protected Map getMap() {
        return this.map;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getCount(Object object) {
        MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
        if (mutableInteger != null) {
            return mutableInteger.value;
        }
        return 0;
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsAll(Collection collection) {
        if (collection instanceof Bag) {
            return this.containsAll((Bag)collection);
        }
        return this.containsAll(new HashBag(collection));
    }

    boolean containsAll(Bag bag) {
        boolean bl = true;
        Iterator iterator = bag.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl2 = this.getCount(e) >= bag.getCount(e);
            bl = bl && bl2;
        }
        return bl;
    }

    public Iterator iterator() {
        return new BagIterator(this);
    }

    public boolean add(Object object) {
        return this.add(object, 1);
    }

    public boolean add(Object object, int n) {
        ++this.modCount;
        if (n > 0) {
            MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
            this.size += n;
            if (mutableInteger == null) {
                this.map.put(object, new MutableInteger(n));
                return true;
            }
            mutableInteger.value += n;
            return false;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = this.add(iterator.next());
            bl = bl || bl2;
        }
        return bl;
    }

    public void clear() {
        ++this.modCount;
        this.map.clear();
        this.size = 0;
    }

    public boolean remove(Object object) {
        MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
        if (mutableInteger == null) {
            return false;
        }
        ++this.modCount;
        this.map.remove(object);
        this.size -= mutableInteger.value;
        return true;
    }

    public boolean remove(Object object, int n) {
        MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
        if (mutableInteger == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        ++this.modCount;
        if (n < mutableInteger.value) {
            mutableInteger.value -= n;
            this.size -= n;
        } else {
            this.map.remove(object);
            this.size -= mutableInteger.value;
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = this.remove(iterator.next(), 1);
                bl = bl || bl2;
            }
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        if (collection instanceof Bag) {
            return this.retainAll((Bag)collection);
        }
        return this.retainAll(new HashBag(collection));
    }

    boolean retainAll(Bag bag) {
        boolean bl = false;
        HashBag hashBag = new HashBag();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.getCount(e);
            int n2 = bag.getCount(e);
            if (1 <= n2 && n2 <= n) {
                hashBag.add(e, n - n2);
                continue;
            }
            hashBag.add(e, n);
        }
        if (!hashBag.isEmpty()) {
            bl = this.removeAll((Collection)hashBag);
        }
        return bl;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            for (int i = this.getCount(k); i > 0; --i) {
                objectArray[n++] = k;
            }
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        int n2 = 0;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            for (int i = this.getCount(k); i > 0; --i) {
                objectArray[n2++] = k;
            }
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public Set uniqueSet() {
        if (this.uniqueSet == null) {
            this.uniqueSet = UnmodifiableSet.decorate(this.map.keySet());
        }
        return this.uniqueSet;
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeInt(((MutableInteger)entry.getValue()).value);
        }
    }

    protected void doReadObject(Map map, ObjectInputStream objectInputStream) {
        this.map = map;
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            map.put(object, new MutableInteger(n2));
            this.size += n2;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)object;
        if (bag.size() != this.size()) {
            return false;
        }
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (bag.getCount(k) == this.getCount(k)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            MutableInteger mutableInteger = (MutableInteger)entry.getValue();
            n += (k == null ? 0 : k.hashCode()) ^ mutableInteger.value;
        }
        return n;
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.getCount(e);
            stringBuffer.append(n);
            stringBuffer.append(':');
            stringBuffer.append(e);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static Map access$000(AbstractMapBag abstractMapBag) {
        return abstractMapBag.map;
    }

    static int access$100(AbstractMapBag abstractMapBag) {
        return abstractMapBag.modCount;
    }

    static int access$210(AbstractMapBag abstractMapBag) {
        return abstractMapBag.size--;
    }

    protected static class MutableInteger {
        protected int value;

        MutableInteger(int n) {
            this.value = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MutableInteger)) {
                return false;
            }
            return ((MutableInteger)object).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }
    }

    static class BagIterator
    implements Iterator {
        private AbstractMapBag parent;
        private Iterator entryIterator;
        private Map.Entry current;
        private int itemCount;
        private final int mods;
        private boolean canRemove;

        public BagIterator(AbstractMapBag abstractMapBag) {
            this.parent = abstractMapBag;
            this.entryIterator = AbstractMapBag.access$000(abstractMapBag).entrySet().iterator();
            this.current = null;
            this.mods = AbstractMapBag.access$100(abstractMapBag);
            this.canRemove = false;
        }

        public boolean hasNext() {
            return this.itemCount > 0 || this.entryIterator.hasNext();
        }

        public Object next() {
            if (AbstractMapBag.access$100(this.parent) != this.mods) {
                throw new ConcurrentModificationException();
            }
            if (this.itemCount == 0) {
                this.current = (Map.Entry)this.entryIterator.next();
                this.itemCount = ((MutableInteger)this.current.getValue()).value;
            }
            this.canRemove = true;
            --this.itemCount;
            return this.current.getKey();
        }

        public void remove() {
            if (AbstractMapBag.access$100(this.parent) != this.mods) {
                throw new ConcurrentModificationException();
            }
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            MutableInteger mutableInteger = (MutableInteger)this.current.getValue();
            if (mutableInteger.value > 1) {
                --mutableInteger.value;
            } else {
                this.entryIterator.remove();
            }
            AbstractMapBag.access$210(this.parent);
            this.canRemove = false;
        }
    }
}

