/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.collections.set.PredicatedSet;
import org.apache.commons.collections.set.PredicatedSortedSet;
import org.apache.commons.collections.set.SynchronizedSet;
import org.apache.commons.collections.set.SynchronizedSortedSet;
import org.apache.commons.collections.set.TransformedSet;
import org.apache.commons.collections.set.TransformedSortedSet;
import org.apache.commons.collections.set.TypedSet;
import org.apache.commons.collections.set.TypedSortedSet;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.collections.set.UnmodifiableSortedSet;

public class SetUtils {
    public static final Set EMPTY_SET = Collections.EMPTY_SET;
    public static final SortedSet EMPTY_SORTED_SET = UnmodifiableSortedSet.decorate(new TreeSet());

    public static boolean isEqualSet(Collection collection, Collection collection2) {
        if (collection == collection2) {
            return true;
        }
        if (collection == null || collection2 == null || collection.size() != collection2.size()) {
            return false;
        }
        return collection.containsAll(collection2);
    }

    public static int hashCodeForSet(Collection collection) {
        if (collection == null) {
            return 0;
        }
        int n = 0;
        Iterator iterator = collection.iterator();
        Object object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) continue;
            n += object.hashCode();
        }
        return n;
    }

    public static Set synchronizedSet(Set set) {
        return SynchronizedSet.decorate(set);
    }

    public static Set unmodifiableSet(Set set) {
        return UnmodifiableSet.decorate(set);
    }

    public static Set predicatedSet(Set set, Predicate predicate) {
        return PredicatedSet.decorate(set, predicate);
    }

    public static Set typedSet(Set set, Class clazz) {
        return TypedSet.decorate(set, clazz);
    }

    public static Set transformedSet(Set set, Transformer transformer) {
        return TransformedSet.decorate(set, transformer);
    }

    public static Set orderedSet(Set set) {
        return ListOrderedSet.decorate(set);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return SynchronizedSortedSet.decorate(sortedSet);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return UnmodifiableSortedSet.decorate(sortedSet);
    }

    public static SortedSet predicatedSortedSet(SortedSet sortedSet, Predicate predicate) {
        return PredicatedSortedSet.decorate(sortedSet, predicate);
    }

    public static SortedSet typedSortedSet(SortedSet sortedSet, Class clazz) {
        return TypedSortedSet.decorate(sortedSet, clazz);
    }

    public static SortedSet transformedSortedSet(SortedSet sortedSet, Transformer transformer) {
        return TransformedSortedSet.decorate(sortedSet, transformer);
    }
}

