/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.AllPredicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.ExceptionPredicate;
import org.apache.commons.collections.functors.FalsePredicate;
import org.apache.commons.collections.functors.IdentityPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.apache.commons.collections.functors.NonePredicate;
import org.apache.commons.collections.functors.NotNullPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.functors.NullIsExceptionPredicate;
import org.apache.commons.collections.functors.NullIsFalsePredicate;
import org.apache.commons.collections.functors.NullIsTruePredicate;
import org.apache.commons.collections.functors.NullPredicate;
import org.apache.commons.collections.functors.OnePredicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.apache.commons.collections.functors.TransformedPredicate;
import org.apache.commons.collections.functors.TransformerPredicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.apache.commons.collections.functors.UniquePredicate;

public class PredicateUtils {
    public static Predicate exceptionPredicate() {
        return ExceptionPredicate.INSTANCE;
    }

    public static Predicate truePredicate() {
        return TruePredicate.INSTANCE;
    }

    public static Predicate falsePredicate() {
        return FalsePredicate.INSTANCE;
    }

    public static Predicate nullPredicate() {
        return NullPredicate.INSTANCE;
    }

    public static Predicate notNullPredicate() {
        return NotNullPredicate.INSTANCE;
    }

    public static Predicate equalPredicate(Object object) {
        return EqualPredicate.getInstance(object);
    }

    public static Predicate identityPredicate(Object object) {
        return IdentityPredicate.getInstance(object);
    }

    public static Predicate instanceofPredicate(Class clazz) {
        return InstanceofPredicate.getInstance(clazz);
    }

    public static Predicate uniquePredicate() {
        return UniquePredicate.getInstance();
    }

    public static Predicate invokerPredicate(String string) {
        return PredicateUtils.asPredicate(InvokerTransformer.getInstance(string));
    }

    public static Predicate invokerPredicate(String string, Class[] classArray, Object[] objectArray) {
        return PredicateUtils.asPredicate(InvokerTransformer.getInstance(string, classArray, objectArray));
    }

    public static Predicate andPredicate(Predicate predicate, Predicate predicate2) {
        return AndPredicate.getInstance(predicate, predicate2);
    }

    public static Predicate allPredicate(Predicate[] predicateArray) {
        return AllPredicate.getInstance(predicateArray);
    }

    public static Predicate allPredicate(Collection collection) {
        return AllPredicate.getInstance(collection);
    }

    public static Predicate orPredicate(Predicate predicate, Predicate predicate2) {
        return OrPredicate.getInstance(predicate, predicate2);
    }

    public static Predicate anyPredicate(Predicate[] predicateArray) {
        return AnyPredicate.getInstance(predicateArray);
    }

    public static Predicate anyPredicate(Collection collection) {
        return AnyPredicate.getInstance(collection);
    }

    public static Predicate eitherPredicate(Predicate predicate, Predicate predicate2) {
        return PredicateUtils.onePredicate(new Predicate[]{predicate, predicate2});
    }

    public static Predicate onePredicate(Predicate[] predicateArray) {
        return OnePredicate.getInstance(predicateArray);
    }

    public static Predicate onePredicate(Collection collection) {
        return OnePredicate.getInstance(collection);
    }

    public static Predicate neitherPredicate(Predicate predicate, Predicate predicate2) {
        return PredicateUtils.nonePredicate(new Predicate[]{predicate, predicate2});
    }

    public static Predicate nonePredicate(Predicate[] predicateArray) {
        return NonePredicate.getInstance(predicateArray);
    }

    public static Predicate nonePredicate(Collection collection) {
        return NonePredicate.getInstance(collection);
    }

    public static Predicate notPredicate(Predicate predicate) {
        return NotPredicate.getInstance(predicate);
    }

    public static Predicate asPredicate(Transformer transformer) {
        return TransformerPredicate.getInstance(transformer);
    }

    public static Predicate nullIsExceptionPredicate(Predicate predicate) {
        return NullIsExceptionPredicate.getInstance(predicate);
    }

    public static Predicate nullIsFalsePredicate(Predicate predicate) {
        return NullIsFalsePredicate.getInstance(predicate);
    }

    public static Predicate nullIsTruePredicate(Predicate predicate) {
        return NullIsTruePredicate.getInstance(predicate);
    }

    public static Predicate transformedPredicate(Transformer transformer, Predicate predicate) {
        return TransformedPredicate.getInstance(transformer, predicate);
    }
}

