/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.FixedSizeMap;
import org.apache.commons.collections.map.FixedSizeSortedMap;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.collections.map.LazySortedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.collections.map.PredicatedMap;
import org.apache.commons.collections.map.PredicatedSortedMap;
import org.apache.commons.collections.map.TransformedMap;
import org.apache.commons.collections.map.TransformedSortedMap;
import org.apache.commons.collections.map.TypedMap;
import org.apache.commons.collections.map.TypedSortedMap;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.commons.collections.map.UnmodifiableSortedMap;

public class MapUtils {
    public static final Map EMPTY_MAP = UnmodifiableMap.decorate(new HashMap(1));
    public static final SortedMap EMPTY_SORTED_MAP = UnmodifiableSortedMap.decorate(new TreeMap());
    private static final String INDENT_STRING = "    ";

    public static Object getObject(Map map, Object object) {
        if (map != null) {
            return map.get(object);
        }
        return null;
    }

    public static String getString(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            return v.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            if (v instanceof String) {
                return new Boolean((String)v);
            }
            if (v instanceof Number) {
                Number number = (Number)v;
                return number.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Number getNumber(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            if (v instanceof Number) {
                return (Number)v;
            }
            if (v instanceof String) {
                try {
                    String string = (String)v;
                    return NumberFormat.getInstance().parse(string);
                }
                catch (ParseException parseException) {
                    MapUtils.logInfo(parseException);
                }
            }
        }
        return null;
    }

    public static Byte getByte(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Byte) {
            return (Byte)number;
        }
        return new Byte(number.byteValue());
    }

    public static Short getShort(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Short) {
            return (Short)number;
        }
        return new Short(number.shortValue());
    }

    public static Integer getInteger(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return new Integer(number.intValue());
    }

    public static Long getLong(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return new Long(number.longValue());
    }

    public static Float getFloat(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return new Double(number.doubleValue());
    }

    public static Map getMap(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null && v instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    public static Object getObject(Map map, Object object, Object object2) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            return v;
        }
        return object2;
    }

    public static String getString(Map map, Object object, String string) {
        String string2 = MapUtils.getString(map, object);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static Boolean getBoolean(Map map, Object object, Boolean bl) {
        Boolean bl2 = MapUtils.getBoolean(map, object);
        if (bl2 == null) {
            bl2 = bl;
        }
        return bl2;
    }

    public static Number getNumber(Map map, Object object, Number number) {
        Number number2 = MapUtils.getNumber(map, object);
        if (number2 == null) {
            number2 = number;
        }
        return number2;
    }

    public static Byte getByte(Map map, Object object, Byte by) {
        Byte by2 = MapUtils.getByte(map, object);
        if (by2 == null) {
            by2 = by;
        }
        return by2;
    }

    public static Short getShort(Map map, Object object, Short s) {
        Short s2 = MapUtils.getShort(map, object);
        if (s2 == null) {
            s2 = s;
        }
        return s2;
    }

    public static Integer getInteger(Map map, Object object, Integer n) {
        Integer n2 = MapUtils.getInteger(map, object);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    public static Long getLong(Map map, Object object, Long l) {
        Long l2 = MapUtils.getLong(map, object);
        if (l2 == null) {
            l2 = l;
        }
        return l2;
    }

    public static Float getFloat(Map map, Object object, Float f) {
        Float f2 = MapUtils.getFloat(map, object);
        if (f2 == null) {
            f2 = f;
        }
        return f2;
    }

    public static Double getDouble(Map map, Object object, Double d) {
        Double d2 = MapUtils.getDouble(map, object);
        if (d2 == null) {
            d2 = d;
        }
        return d2;
    }

    public static Map getMap(Map map, Object object, Map map2) {
        Map map3 = MapUtils.getMap(map, object);
        if (map3 == null) {
            map3 = map2;
        }
        return map3;
    }

    public static boolean getBooleanValue(Map map, Object object) {
        Boolean bl = MapUtils.getBoolean(map, object);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static byte getByteValue(Map map, Object object) {
        Byte by = MapUtils.getByte(map, object);
        if (by == null) {
            return 0;
        }
        return by;
    }

    public static short getShortValue(Map map, Object object) {
        Short s = MapUtils.getShort(map, object);
        if (s == null) {
            return 0;
        }
        return s;
    }

    public static int getIntValue(Map map, Object object) {
        Integer n = MapUtils.getInteger(map, object);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static long getLongValue(Map map, Object object) {
        Long l = MapUtils.getLong(map, object);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static float getFloatValue(Map map, Object object) {
        Float f = MapUtils.getFloat(map, object);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public static double getDoubleValue(Map map, Object object) {
        Double d = MapUtils.getDouble(map, object);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public static boolean getBooleanValue(Map map, Object object, boolean bl) {
        Boolean bl2 = MapUtils.getBoolean(map, object);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public static byte getByteValue(Map map, Object object, byte by) {
        Byte by2 = MapUtils.getByte(map, object);
        if (by2 == null) {
            return by;
        }
        return by2;
    }

    public static short getShortValue(Map map, Object object, short s) {
        Short s2 = MapUtils.getShort(map, object);
        if (s2 == null) {
            return s;
        }
        return s2;
    }

    public static int getIntValue(Map map, Object object, int n) {
        Integer n2 = MapUtils.getInteger(map, object);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public static long getLongValue(Map map, Object object, long l) {
        Long l2 = MapUtils.getLong(map, object);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    public static float getFloatValue(Map map, Object object, float f) {
        Float f2 = MapUtils.getFloat(map, object);
        if (f2 == null) {
            return f;
        }
        return f2.floatValue();
    }

    public static double getDoubleValue(Map map, Object object, double d) {
        Double d2 = MapUtils.getDouble(map, object);
        if (d2 == null) {
            return d;
        }
        return d2;
    }

    public static Properties toProperties(Map map) {
        Properties properties = new Properties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                properties.put(k, v);
            }
        }
        return properties;
    }

    public static Map toMap(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = resourceBundle.getObject(string);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public static void verbosePrint(PrintStream printStream, Object object, Map map) {
        MapUtils.verbosePrintInternal(printStream, object, map, new ArrayStack(), false);
    }

    public static void debugPrint(PrintStream printStream, Object object, Map map) {
        MapUtils.verbosePrintInternal(printStream, object, map, new ArrayStack(), true);
    }

    protected static void logInfo(Exception exception) {
        System.out.println("INFO: Exception: " + exception);
    }

    private static void verbosePrintInternal(PrintStream printStream, Object object, Map map, ArrayStack arrayStack, boolean bl) {
        MapUtils.printIndent(printStream, arrayStack.size());
        if (map == null) {
            if (object != null) {
                printStream.print(object);
                printStream.print(" = ");
            }
            printStream.println("null");
            return;
        }
        if (object != null) {
            printStream.print(object);
            printStream.println(" = ");
        }
        MapUtils.printIndent(printStream, arrayStack.size());
        printStream.println("{");
        arrayStack.push(map);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Map && !arrayStack.contains(v)) {
                MapUtils.verbosePrintInternal(printStream, k == null ? "null" : k, (Map)v, arrayStack, bl);
                continue;
            }
            MapUtils.printIndent(printStream, arrayStack.size());
            printStream.print(k);
            printStream.print(" = ");
            int n = arrayStack.indexOf(v);
            if (n == -1) {
                printStream.print(v);
            } else if (arrayStack.size() - 1 == n) {
                printStream.print("(this Map)");
            } else {
                printStream.print("(ancestor[" + (arrayStack.size() - 1 - n - 1) + "] Map)");
            }
            if (bl && v != null) {
                printStream.print(' ');
                printStream.println(v.getClass().getName());
                continue;
            }
            printStream.println();
        }
        arrayStack.pop();
        MapUtils.printIndent(printStream, arrayStack.size());
        printStream.println(bl ? "} " + map.getClass().getName() : "}");
    }

    private static void printIndent(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(INDENT_STRING);
        }
    }

    public static Map invertMap(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public static void safeAddToMap(Map map, Object object, Object object2) {
        if (object2 == null) {
            map.put(object, "");
        } else {
            map.put(object, object2);
        }
    }

    public static Map putAll(Map map, Object[] objectArray) {
        map.size();
        if (objectArray == null || objectArray.length == 0) {
            return map;
        }
        Object object = objectArray[0];
        if (object instanceof Map.Entry) {
            for (int i = 0; i < objectArray.length; ++i) {
                Map.Entry entry = (Map.Entry)objectArray[i];
                map.put(entry.getKey(), entry.getValue());
            }
        } else if (object instanceof KeyValue) {
            for (int i = 0; i < objectArray.length; ++i) {
                KeyValue keyValue = (KeyValue)objectArray[i];
                map.put(keyValue.getKey(), keyValue.getValue());
            }
        } else if (object instanceof Object[]) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2 = (Object[])objectArray[i];
                if (objectArray2 == null || objectArray2.length < 2) {
                    throw new IllegalArgumentException("Invalid array element: " + i);
                }
                map.put(objectArray2[0], objectArray2[1]);
            }
        } else {
            int n = 0;
            while (n < objectArray.length - 1) {
                map.put(objectArray[n++], objectArray[n++]);
            }
        }
        return map;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !MapUtils.isEmpty(map);
    }

    public static Map synchronizedMap(Map map) {
        return Collections.synchronizedMap(map);
    }

    public static Map unmodifiableMap(Map map) {
        return UnmodifiableMap.decorate(map);
    }

    public static Map predicatedMap(Map map, Predicate predicate, Predicate predicate2) {
        return PredicatedMap.decorate(map, predicate, predicate2);
    }

    public static Map typedMap(Map map, Class clazz, Class clazz2) {
        return TypedMap.decorate(map, clazz, clazz2);
    }

    public static Map transformedMap(Map map, Transformer transformer, Transformer transformer2) {
        return TransformedMap.decorate(map, transformer, transformer2);
    }

    public static Map fixedSizeMap(Map map) {
        return FixedSizeMap.decorate(map);
    }

    public static Map lazyMap(Map map, Factory factory) {
        return LazyMap.decorate(map, factory);
    }

    public static Map lazyMap(Map map, Transformer transformer) {
        return LazyMap.decorate(map, transformer);
    }

    public static Map orderedMap(Map map) {
        return ListOrderedMap.decorate(map);
    }

    public static Map multiValueMap(Map map) {
        return MultiValueMap.decorate(map);
    }

    public static Map multiValueMap(Map map, Class clazz) {
        return MultiValueMap.decorate(map, clazz);
    }

    public static Map multiValueMap(Map map, Factory factory) {
        return MultiValueMap.decorate(map, factory);
    }

    public static Map synchronizedSortedMap(SortedMap sortedMap) {
        return Collections.synchronizedSortedMap(sortedMap);
    }

    public static Map unmodifiableSortedMap(SortedMap sortedMap) {
        return UnmodifiableSortedMap.decorate(sortedMap);
    }

    public static SortedMap predicatedSortedMap(SortedMap sortedMap, Predicate predicate, Predicate predicate2) {
        return PredicatedSortedMap.decorate(sortedMap, predicate, predicate2);
    }

    public static SortedMap typedSortedMap(SortedMap sortedMap, Class clazz, Class clazz2) {
        return TypedSortedMap.decorate(sortedMap, clazz, clazz2);
    }

    public static SortedMap transformedSortedMap(SortedMap sortedMap, Transformer transformer, Transformer transformer2) {
        return TransformedSortedMap.decorate(sortedMap, transformer, transformer2);
    }

    public static SortedMap fixedSizeSortedMap(SortedMap sortedMap) {
        return FixedSizeSortedMap.decorate(sortedMap);
    }

    public static SortedMap lazySortedMap(SortedMap sortedMap, Factory factory) {
        return LazySortedMap.decorate(sortedMap, factory);
    }

    public static SortedMap lazySortedMap(SortedMap sortedMap, Transformer transformer) {
        return LazySortedMap.decorate(sortedMap, transformer);
    }
}

