/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.list.FixedSizeList;
import org.apache.commons.collections.list.LazyList;
import org.apache.commons.collections.list.PredicatedList;
import org.apache.commons.collections.list.SynchronizedList;
import org.apache.commons.collections.list.TransformedList;
import org.apache.commons.collections.list.TypedList;
import org.apache.commons.collections.list.UnmodifiableList;

public class ListUtils {
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;

    public static List intersection(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!list.contains(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static List subtract(List list, List list2) {
        ArrayList arrayList = new ArrayList(list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        return arrayList;
    }

    public static List sum(List list, List list2) {
        return ListUtils.subtract(ListUtils.union(list, list2), ListUtils.intersection(list, list2));
    }

    public static List union(List list, List list2) {
        ArrayList arrayList = new ArrayList(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public static boolean isEqualList(Collection collection, Collection collection2) {
        if (collection == collection2) {
            return true;
        }
        if (collection == null || collection2 == null || collection.size() != collection2.size()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        Object object = null;
        Object var5_5 = null;
        while (iterator.hasNext() && iterator2.hasNext()) {
            object = iterator.next();
            var5_5 = iterator2.next();
            if (object != null ? object.equals(var5_5) : var5_5 == null) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public static int hashCodeForList(Collection collection) {
        if (collection == null) {
            return 0;
        }
        int n = 1;
        Iterator iterator = collection.iterator();
        Object object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public static List retainAll(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(Math.min(collection.size(), collection2.size()));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!collection2.contains(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static List removeAll(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection2.contains(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static List synchronizedList(List list) {
        return SynchronizedList.decorate(list);
    }

    public static List unmodifiableList(List list) {
        return UnmodifiableList.decorate(list);
    }

    public static List predicatedList(List list, Predicate predicate) {
        return PredicatedList.decorate(list, predicate);
    }

    public static List typedList(List list, Class clazz) {
        return TypedList.decorate(list, clazz);
    }

    public static List transformedList(List list, Transformer transformer) {
        return TransformedList.decorate(list, transformer);
    }

    public static List lazyList(List list, Factory factory) {
        return LazyList.decorate(list, factory);
    }

    public static List fixedSizeList(List list) {
        return FixedSizeList.decorate(list);
    }
}

