/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.ResettableListIterator;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.ArrayListIterator;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.EmptyListIterator;
import org.apache.commons.collections.iterators.EmptyMapIterator;
import org.apache.commons.collections.iterators.EmptyOrderedIterator;
import org.apache.commons.collections.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.FilterListIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.collections.iterators.ListIteratorWrapper;
import org.apache.commons.collections.iterators.LoopingIterator;
import org.apache.commons.collections.iterators.LoopingListIterator;
import org.apache.commons.collections.iterators.ObjectArrayIterator;
import org.apache.commons.collections.iterators.ObjectArrayListIterator;
import org.apache.commons.collections.iterators.ObjectGraphIterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.collections.iterators.SingletonListIterator;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.commons.collections.iterators.UnmodifiableIterator;
import org.apache.commons.collections.iterators.UnmodifiableListIterator;
import org.apache.commons.collections.iterators.UnmodifiableMapIterator;

public class IteratorUtils {
    public static final ResettableIterator EMPTY_ITERATOR = EmptyIterator.RESETTABLE_INSTANCE;
    public static final ResettableListIterator EMPTY_LIST_ITERATOR = EmptyListIterator.RESETTABLE_INSTANCE;
    public static final OrderedIterator EMPTY_ORDERED_ITERATOR = EmptyOrderedIterator.INSTANCE;
    public static final MapIterator EMPTY_MAP_ITERATOR = EmptyMapIterator.INSTANCE;
    public static final OrderedMapIterator EMPTY_ORDERED_MAP_ITERATOR = EmptyOrderedMapIterator.INSTANCE;
    static Class class$java$util$Iterator;

    public static ResettableIterator emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static ResettableListIterator emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static OrderedIterator emptyOrderedIterator() {
        return EMPTY_ORDERED_ITERATOR;
    }

    public static MapIterator emptyMapIterator() {
        return EMPTY_MAP_ITERATOR;
    }

    public static OrderedMapIterator emptyOrderedMapIterator() {
        return EMPTY_ORDERED_MAP_ITERATOR;
    }

    public static ResettableIterator singletonIterator(Object object) {
        return new SingletonIterator(object);
    }

    public static ListIterator singletonListIterator(Object object) {
        return new SingletonListIterator(object);
    }

    public static ResettableIterator arrayIterator(Object[] objectArray) {
        return new ObjectArrayIterator(objectArray);
    }

    public static ResettableIterator arrayIterator(Object object) {
        return new ArrayIterator(object);
    }

    public static ResettableIterator arrayIterator(Object[] objectArray, int n) {
        return new ObjectArrayIterator(objectArray, n);
    }

    public static ResettableIterator arrayIterator(Object object, int n) {
        return new ArrayIterator(object, n);
    }

    public static ResettableIterator arrayIterator(Object[] objectArray, int n, int n2) {
        return new ObjectArrayIterator(objectArray, n, n2);
    }

    public static ResettableIterator arrayIterator(Object object, int n, int n2) {
        return new ArrayIterator(object, n, n2);
    }

    public static ResettableListIterator arrayListIterator(Object[] objectArray) {
        return new ObjectArrayListIterator(objectArray);
    }

    public static ResettableListIterator arrayListIterator(Object object) {
        return new ArrayListIterator(object);
    }

    public static ResettableListIterator arrayListIterator(Object[] objectArray, int n) {
        return new ObjectArrayListIterator(objectArray, n);
    }

    public static ResettableListIterator arrayListIterator(Object object, int n) {
        return new ArrayListIterator(object, n);
    }

    public static ResettableListIterator arrayListIterator(Object[] objectArray, int n, int n2) {
        return new ObjectArrayListIterator(objectArray, n, n2);
    }

    public static ResettableListIterator arrayListIterator(Object object, int n, int n2) {
        return new ArrayListIterator(object, n, n2);
    }

    public static Iterator unmodifiableIterator(Iterator iterator) {
        return UnmodifiableIterator.decorate(iterator);
    }

    public static ListIterator unmodifiableListIterator(ListIterator listIterator) {
        return UnmodifiableListIterator.decorate(listIterator);
    }

    public static MapIterator unmodifiableMapIterator(MapIterator mapIterator) {
        return UnmodifiableMapIterator.decorate(mapIterator);
    }

    public static Iterator chainedIterator(Iterator iterator, Iterator iterator2) {
        return new IteratorChain(iterator, iterator2);
    }

    public static Iterator chainedIterator(Iterator[] iteratorArray) {
        return new IteratorChain(iteratorArray);
    }

    public static Iterator chainedIterator(Collection collection) {
        return new IteratorChain(collection);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator iterator, Iterator iterator2) {
        return new CollatingIterator(comparator, iterator, iterator2);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator[] iteratorArray) {
        return new CollatingIterator(comparator, iteratorArray);
    }

    public static Iterator collatedIterator(Comparator comparator, Collection collection) {
        return new CollatingIterator(comparator, collection);
    }

    public static Iterator objectGraphIterator(Object object, Transformer transformer) {
        return new ObjectGraphIterator(object, transformer);
    }

    public static Iterator transformedIterator(Iterator iterator, Transformer transformer) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (transformer == null) {
            throw new NullPointerException("Transformer must not be null");
        }
        return new TransformIterator(iterator, transformer);
    }

    public static Iterator filteredIterator(Iterator iterator, Predicate predicate) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterIterator(iterator, predicate);
    }

    public static ListIterator filteredListIterator(ListIterator listIterator, Predicate predicate) {
        if (listIterator == null) {
            throw new NullPointerException("ListIterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterListIterator(listIterator, predicate);
    }

    public static ResettableIterator loopingIterator(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new LoopingIterator(collection);
    }

    public static ResettableListIterator loopingListIterator(List list) {
        if (list == null) {
            throw new NullPointerException("List must not be null");
        }
        return new LoopingListIterator(list);
    }

    public static Iterator asIterator(Enumeration enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        return new EnumerationIterator(enumeration);
    }

    public static Iterator asIterator(Enumeration enumeration, Collection collection) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new EnumerationIterator(enumeration, collection);
    }

    public static Enumeration asEnumeration(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new IteratorEnumeration(iterator);
    }

    public static ListIterator toListIterator(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new ListIteratorWrapper(iterator);
    }

    public static Object[] toArray(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray();
    }

    public static Object[] toArray(Iterator iterator, Class clazz) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (clazz == null) {
            throw new NullPointerException("Array class must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    public static List toList(Iterator iterator) {
        return IteratorUtils.toList(iterator, 10);
    }

    public static List toList(Iterator iterator, int n) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Estimated size must be greater than 0");
        }
        ArrayList arrayList = new ArrayList(n);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static Iterator getIterator(Object object) {
        if (object == null) {
            return IteratorUtils.emptyIterator();
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Object[]) {
            return new ObjectArrayIterator((Object[])object);
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)object);
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        if (object instanceof Dictionary) {
            return new EnumerationIterator(((Dictionary)object).elements());
        }
        if (object != null && object.getClass().isArray()) {
            return new ArrayIterator(object);
        }
        try {
            Iterator iterator;
            Method method = object.getClass().getMethod("iterator", null);
            if ((class$java$util$Iterator == null ? (class$java$util$Iterator = IteratorUtils.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(method.getReturnType()) && (iterator = (Iterator)method.invoke(object, (Object[])null)) != null) {
                return iterator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IteratorUtils.singletonIterator(object);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

