/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;

public final class DoubleOrderedMap
extends AbstractMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[]{null, null};
    private int nodeCount = 0;
    private int modifications = 0;
    private Set[] setOfKeys = new Set[]{null, null};
    private Set[] setOfEntries = new Set[]{null, null};
    private Collection[] collectionOfValues = new Collection[]{null, null};

    public DoubleOrderedMap() {
    }

    public DoubleOrderedMap(Map map) {
        this.putAll(map);
    }

    public Object getKeyForValue(Object object) {
        return this.doGet((Comparable)object, 1);
    }

    public Object removeValue(Object object) {
        return this.doRemove((Comparable)object, 1);
    }

    public Set entrySetByValue() {
        if (this.setOfEntries[1] == null) {
            this.setOfEntries[1] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getValue(), 1);
                    return node != null && Node.access$200(node, 0).equals(k);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getValue(), 1);
                    if (node != null && Node.access$200(node, 0).equals(k)) {
                        DoubleOrderedMap.access$300(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return this.this$0.size();
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$000(1 var0) {
                    return var0.this$0;
                }
            };
        }
        return this.setOfEntries[1];
    }

    public Set keySetByValue() {
        if (this.setOfKeys[1] == null) {
            this.setOfKeys[1] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 0);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.remove(object);
                    return DoubleOrderedMap.access$500(this.this$0) != n;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$400(2 var0) {
                    return var0.this$0;
                }
            };
        }
        return this.setOfKeys[1];
    }

    public Collection valuesByValue() {
        if (this.collectionOfValues[1] == null) {
            this.collectionOfValues[1] = new AbstractCollection(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 1);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsValue(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.removeValue(object);
                    return DoubleOrderedMap.access$500(this.this$0) != n;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$600(3 var0) {
                    return var0.this$0;
                }
            };
        }
        return this.collectionOfValues[1];
    }

    private Object doRemove(Comparable comparable, int n) {
        Node node = this.lookup(comparable, n);
        Comparable comparable2 = null;
        if (node != null) {
            comparable2 = Node.access$200(node, this.oppositeIndex(n));
            this.doRedBlackDelete(node);
        }
        return comparable2;
    }

    private Object doGet(Comparable comparable, int n) {
        DoubleOrderedMap.checkNonNullComparable(comparable, n);
        Node node = this.lookup(comparable, n);
        return node == null ? null : Node.access$200(node, this.oppositeIndex(n));
    }

    private int oppositeIndex(int n) {
        return 1 - n;
    }

    private Node lookup(Comparable comparable, int n) {
        Node node = null;
        Node node2 = this.rootNode[n];
        while (node2 != null) {
            int n2 = DoubleOrderedMap.compare(comparable, Node.access$200(node2, n));
            if (n2 == 0) {
                node = node2;
                break;
            }
            node2 = n2 < 0 ? Node.access$700(node2, n) : Node.access$800(node2, n);
        }
        return node;
    }

    private static int compare(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    private static Node leastNode(Node node, int n) {
        Node node2 = node;
        if (node2 != null) {
            while (Node.access$700(node2, n) != null) {
                node2 = Node.access$700(node2, n);
            }
        }
        return node2;
    }

    private Node nextGreater(Node node, int n) {
        Node node2 = null;
        if (node == null) {
            node2 = null;
        } else if (Node.access$800(node, n) != null) {
            node2 = DoubleOrderedMap.leastNode(Node.access$800(node, n), n);
        } else {
            Node node3 = Node.access$900(node, n);
            Node node4 = node;
            while (node3 != null && node4 == Node.access$800(node3, n)) {
                node4 = node3;
                node3 = Node.access$900(node3, n);
            }
            node2 = node3;
        }
        return node2;
    }

    private static void copyColor(Node node, Node node2, int n) {
        if (node2 != null) {
            if (node == null) {
                Node.access$1000(node2, n);
            } else {
                Node.access$1100(node2, node, n);
            }
        }
    }

    private static boolean isRed(Node node, int n) {
        return node == null ? false : Node.access$1200(node, n);
    }

    private static boolean isBlack(Node node, int n) {
        return node == null ? true : Node.access$1300(node, n);
    }

    private static void makeRed(Node node, int n) {
        if (node != null) {
            Node.access$1400(node, n);
        }
    }

    private static void makeBlack(Node node, int n) {
        if (node != null) {
            Node.access$1000(node, n);
        }
    }

    private static Node getGrandParent(Node node, int n) {
        return DoubleOrderedMap.getParent(DoubleOrderedMap.getParent(node, n), n);
    }

    private static Node getParent(Node node, int n) {
        return node == null ? null : Node.access$900(node, n);
    }

    private static Node getRightChild(Node node, int n) {
        return node == null ? null : Node.access$800(node, n);
    }

    private static Node getLeftChild(Node node, int n) {
        return node == null ? null : Node.access$700(node, n);
    }

    private static boolean isLeftChild(Node node, int n) {
        return node == null ? true : (Node.access$900(node, n) == null ? false : node == Node.access$700(Node.access$900(node, n), n));
    }

    private static boolean isRightChild(Node node, int n) {
        return node == null ? true : (Node.access$900(node, n) == null ? false : node == Node.access$800(Node.access$900(node, n), n));
    }

    private void rotateLeft(Node node, int n) {
        Node node2 = Node.access$800(node, n);
        Node.access$1500(node, Node.access$700(node2, n), n);
        if (Node.access$700(node2, n) != null) {
            Node.access$1600(Node.access$700(node2, n), node, n);
        }
        Node.access$1600(node2, Node.access$900(node, n), n);
        if (Node.access$900(node, n) == null) {
            this.rootNode[n] = node2;
        } else if (Node.access$700(Node.access$900(node, n), n) == node) {
            Node.access$1700(Node.access$900(node, n), node2, n);
        } else {
            Node.access$1500(Node.access$900(node, n), node2, n);
        }
        Node.access$1700(node2, node, n);
        Node.access$1600(node, node2, n);
    }

    private void rotateRight(Node node, int n) {
        Node node2 = Node.access$700(node, n);
        Node.access$1700(node, Node.access$800(node2, n), n);
        if (Node.access$800(node2, n) != null) {
            Node.access$1600(Node.access$800(node2, n), node, n);
        }
        Node.access$1600(node2, Node.access$900(node, n), n);
        if (Node.access$900(node, n) == null) {
            this.rootNode[n] = node2;
        } else if (Node.access$800(Node.access$900(node, n), n) == node) {
            Node.access$1500(Node.access$900(node, n), node2, n);
        } else {
            Node.access$1700(Node.access$900(node, n), node2, n);
        }
        Node.access$1500(node2, node, n);
        Node.access$1600(node, node2, n);
    }

    private void doRedBlackInsert(Node node, int n) {
        Node node2 = node;
        DoubleOrderedMap.makeRed(node2, n);
        while (node2 != null && node2 != this.rootNode[n] && DoubleOrderedMap.isRed(Node.access$900(node2, n), n)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(DoubleOrderedMap.getParent(node2, n), n)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getGrandParent(node2, n), n);
                if (DoubleOrderedMap.isRed(node3, n)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                    DoubleOrderedMap.makeBlack(node3, n);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                    node2 = DoubleOrderedMap.getGrandParent(node2, n);
                    continue;
                }
                if (DoubleOrderedMap.isRightChild(node2, n)) {
                    node2 = DoubleOrderedMap.getParent(node2, n);
                    this.rotateLeft(node2, n);
                }
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                if (DoubleOrderedMap.getGrandParent(node2, n) == null) continue;
                this.rotateRight(DoubleOrderedMap.getGrandParent(node2, n), n);
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getGrandParent(node2, n), n);
            if (DoubleOrderedMap.isRed(node3, n)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeBlack(node3, n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                node2 = DoubleOrderedMap.getGrandParent(node2, n);
                continue;
            }
            if (DoubleOrderedMap.isLeftChild(node2, n)) {
                node2 = DoubleOrderedMap.getParent(node2, n);
                this.rotateRight(node2, n);
            }
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
            DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
            if (DoubleOrderedMap.getGrandParent(node2, n) == null) continue;
            this.rotateLeft(DoubleOrderedMap.getGrandParent(node2, n), n);
        }
        DoubleOrderedMap.makeBlack(this.rootNode[n], n);
    }

    private void doRedBlackDelete(Node node) {
        for (int i = 0; i < 2; ++i) {
            Node node2;
            if (Node.access$700(node, i) != null && Node.access$800(node, i) != null) {
                this.swapPosition(this.nextGreater(node, i), node, i);
            }
            Node node3 = node2 = Node.access$700(node, i) != null ? Node.access$700(node, i) : Node.access$800(node, i);
            if (node2 != null) {
                Node.access$1600(node2, Node.access$900(node, i), i);
                if (Node.access$900(node, i) == null) {
                    this.rootNode[i] = node2;
                } else if (node == Node.access$700(Node.access$900(node, i), i)) {
                    Node.access$1700(Node.access$900(node, i), node2, i);
                } else {
                    Node.access$1500(Node.access$900(node, i), node2, i);
                }
                Node.access$1700(node, null, i);
                Node.access$1500(node, null, i);
                Node.access$1600(node, null, i);
                if (!DoubleOrderedMap.isBlack(node, i)) continue;
                this.doRedBlackDeleteFixup(node2, i);
                continue;
            }
            if (Node.access$900(node, i) == null) {
                this.rootNode[i] = null;
                continue;
            }
            if (DoubleOrderedMap.isBlack(node, i)) {
                this.doRedBlackDeleteFixup(node, i);
            }
            if (Node.access$900(node, i) == null) continue;
            if (node == Node.access$700(Node.access$900(node, i), i)) {
                Node.access$1700(Node.access$900(node, i), null, i);
            } else {
                Node.access$1500(Node.access$900(node, i), null, i);
            }
            Node.access$1600(node, null, i);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node node, int n) {
        Node node2 = node;
        while (node2 != this.rootNode[n] && DoubleOrderedMap.isBlack(node2, n)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(node2, n)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                if (DoubleOrderedMap.isRed(node3, n)) {
                    DoubleOrderedMap.makeBlack(node3, n);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n), n);
                    this.rotateLeft(DoubleOrderedMap.getParent(node2, n), n);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n)) {
                    DoubleOrderedMap.makeRed(node3, n);
                    node2 = DoubleOrderedMap.getParent(node2, n);
                    continue;
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n), n);
                    DoubleOrderedMap.makeRed(node3, n);
                    this.rotateRight(node3, n);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                }
                DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n), node3, n);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n), n);
                this.rotateLeft(DoubleOrderedMap.getParent(node2, n), n);
                node2 = this.rootNode[n];
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            if (DoubleOrderedMap.isRed(node3, n)) {
                DoubleOrderedMap.makeBlack(node3, n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n), n);
                this.rotateRight(DoubleOrderedMap.getParent(node2, n), n);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n)) {
                DoubleOrderedMap.makeRed(node3, n);
                node2 = DoubleOrderedMap.getParent(node2, n);
                continue;
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n), n);
                DoubleOrderedMap.makeRed(node3, n);
                this.rotateLeft(node3, n);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            }
            DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n), node3, n);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n), n);
            this.rotateRight(DoubleOrderedMap.getParent(node2, n), n);
            node2 = this.rootNode[n];
        }
        DoubleOrderedMap.makeBlack(node2, n);
    }

    private void swapPosition(Node node, Node node2, int n) {
        boolean bl;
        Node node3 = Node.access$900(node, n);
        Node node4 = Node.access$700(node, n);
        Node node5 = Node.access$800(node, n);
        Node node6 = Node.access$900(node2, n);
        Node node7 = Node.access$700(node2, n);
        Node node8 = Node.access$800(node2, n);
        boolean bl2 = Node.access$900(node, n) != null && node == Node.access$700(Node.access$900(node, n), n);
        boolean bl3 = bl = Node.access$900(node2, n) != null && node2 == Node.access$700(Node.access$900(node2, n), n);
        if (node == node6) {
            Node.access$1600(node, node2, n);
            if (bl) {
                Node.access$1700(node2, node, n);
                Node.access$1500(node2, node5, n);
            } else {
                Node.access$1500(node2, node, n);
                Node.access$1700(node2, node4, n);
            }
        } else {
            Node.access$1600(node, node6, n);
            if (node6 != null) {
                if (bl) {
                    Node.access$1700(node6, node, n);
                } else {
                    Node.access$1500(node6, node, n);
                }
            }
            Node.access$1700(node2, node4, n);
            Node.access$1500(node2, node5, n);
        }
        if (node2 == node3) {
            Node.access$1600(node2, node, n);
            if (bl2) {
                Node.access$1700(node, node2, n);
                Node.access$1500(node, node8, n);
            } else {
                Node.access$1500(node, node2, n);
                Node.access$1700(node, node7, n);
            }
        } else {
            Node.access$1600(node2, node3, n);
            if (node3 != null) {
                if (bl2) {
                    Node.access$1700(node3, node2, n);
                } else {
                    Node.access$1500(node3, node2, n);
                }
            }
            Node.access$1700(node, node7, n);
            Node.access$1500(node, node8, n);
        }
        if (Node.access$700(node, n) != null) {
            Node.access$1600(Node.access$700(node, n), node, n);
        }
        if (Node.access$800(node, n) != null) {
            Node.access$1600(Node.access$800(node, n), node, n);
        }
        if (Node.access$700(node2, n) != null) {
            Node.access$1600(Node.access$700(node2, n), node2, n);
        }
        if (Node.access$800(node2, n) != null) {
            Node.access$1600(Node.access$800(node2, n), node2, n);
        }
        Node.access$1800(node, node2, n);
        if (this.rootNode[n] == node) {
            this.rootNode[n] = node2;
        } else if (this.rootNode[n] == node2) {
            this.rootNode[n] = node;
        }
    }

    private static void checkNonNullComparable(Object object, int n) {
        if (object == null) {
            throw new NullPointerException(dataName[n] + " cannot be null");
        }
        if (!(object instanceof Comparable)) {
            throw new ClassCastException(dataName[n] + " must be Comparable");
        }
    }

    private static void checkKey(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 0);
    }

    private static void checkValue(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 1);
    }

    private static void checkKeyAndValue(Object object, Object object2) {
        DoubleOrderedMap.checkKey(object);
        DoubleOrderedMap.checkValue(object2);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node node) {
        block4: {
            Node node2 = this.rootNode[1];
            while (true) {
                int n;
                if ((n = DoubleOrderedMap.compare(Node.access$200(node, 1), Node.access$200(node2, 1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + Node.access$200(node, 1) + "\") in this Map");
                }
                if (n < 0) {
                    if (Node.access$700(node2, 1) != null) {
                        node2 = Node.access$700(node2, 1);
                        continue;
                    }
                    Node.access$1700(node2, node, 1);
                    Node.access$1600(node, node2, 1);
                    this.doRedBlackInsert(node, 1);
                    break block4;
                }
                if (Node.access$800(node2, 1) == null) break;
                node2 = Node.access$800(node2, 1);
            }
            Node.access$1500(node2, node, 1);
            Node.access$1600(node, node2, 1);
            this.doRedBlackInsert(node, 1);
        }
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean containsKey(Object object) {
        DoubleOrderedMap.checkKey(object);
        return this.lookup((Comparable)object, 0) != null;
    }

    public boolean containsValue(Object object) {
        DoubleOrderedMap.checkValue(object);
        return this.lookup((Comparable)object, 1) != null;
    }

    public Object get(Object object) {
        return this.doGet((Comparable)object, 0);
    }

    public Object put(Object object, Object object2) {
        block6: {
            DoubleOrderedMap.checkKeyAndValue(object, object2);
            Node node = this.rootNode[0];
            if (node == null) {
                Node node2;
                this.rootNode[0] = node2 = new Node((Comparable)object, (Comparable)object2);
                this.rootNode[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n;
                    if ((n = DoubleOrderedMap.compare((Comparable)object, Node.access$200(node, 0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + object + "\") in this Map");
                    }
                    if (n < 0) {
                        if (Node.access$700(node, 0) != null) {
                            node = Node.access$700(node, 0);
                            continue;
                        }
                        Node node3 = new Node((Comparable)object, (Comparable)object2);
                        this.insertValue(node3);
                        Node.access$1700(node, node3, 0);
                        Node.access$1600(node3, node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (Node.access$800(node, 0) == null) break;
                    node = Node.access$800(node, 0);
                }
                Node node4 = new Node((Comparable)object, (Comparable)object2);
                this.insertValue(node4);
                Node.access$1500(node, node4, 0);
                Node.access$1600(node4, node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return null;
    }

    public Object remove(Object object) {
        return this.doRemove((Comparable)object, 0);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public Set keySet() {
        if (this.setOfKeys[0] == null) {
            this.setOfKeys[0] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 0);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.remove(object);
                    return DoubleOrderedMap.access$500(this.this$0) != n;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$1900(4 var0) {
                    return var0.this$0;
                }
            };
        }
        return this.setOfKeys[0];
    }

    public Collection values() {
        if (this.collectionOfValues[0] == null) {
            this.collectionOfValues[0] = new AbstractCollection(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 1);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsValue(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.removeValue(object);
                    return DoubleOrderedMap.access$500(this.this$0) != n;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$2000(5 var0) {
                    return var0.this$0;
                }
            };
        }
        return this.collectionOfValues[0];
    }

    public Set entrySet() {
        if (this.setOfEntries[0] == null) {
            this.setOfEntries[0] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getKey(), 0);
                    return node != null && Node.access$200(node, 1).equals(v);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getKey(), 0);
                    if (node != null && Node.access$200(node, 1).equals(v)) {
                        DoubleOrderedMap.access$300(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return this.this$0.size();
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$2100(6 var0) {
                    return var0.this$0;
                }
            };
        }
        return this.setOfEntries[0];
    }

    static Node access$100(DoubleOrderedMap doubleOrderedMap, Comparable comparable, int n) {
        return doubleOrderedMap.lookup(comparable, n);
    }

    static void access$300(DoubleOrderedMap doubleOrderedMap, Node node) {
        doubleOrderedMap.doRedBlackDelete(node);
    }

    static int access$500(DoubleOrderedMap doubleOrderedMap) {
        return doubleOrderedMap.nodeCount;
    }

    static int access$2200(DoubleOrderedMap doubleOrderedMap) {
        return doubleOrderedMap.modifications;
    }

    static Node[] access$2300(DoubleOrderedMap doubleOrderedMap) {
        return doubleOrderedMap.rootNode;
    }

    static Node access$2400(Node node, int n) {
        return DoubleOrderedMap.leastNode(node, n);
    }

    static Node access$2500(DoubleOrderedMap doubleOrderedMap, Node node, int n) {
        return doubleOrderedMap.nextGreater(node, n);
    }

    private static final class Node
    implements Map.Entry,
    KeyValue {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable comparable, Comparable comparable2) {
            this.data = new Comparable[]{comparable, comparable2};
            this.leftNode = new Node[]{null, null};
            this.rightNode = new Node[]{null, null};
            this.parentNode = new Node[]{null, null};
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int n) {
            return this.data[n];
        }

        private void setLeft(Node node, int n) {
            this.leftNode[n] = node;
        }

        private Node getLeft(int n) {
            return this.leftNode[n];
        }

        private void setRight(Node node, int n) {
            this.rightNode[n] = node;
        }

        private Node getRight(int n) {
            return this.rightNode[n];
        }

        private void setParent(Node node, int n) {
            this.parentNode[n] = node;
        }

        private Node getParent(int n) {
            return this.parentNode[n];
        }

        private void swapColors(Node node, int n) {
            int n2 = n;
            this.blackColor[n2] = this.blackColor[n2] ^ node.blackColor[n];
            int n3 = n;
            node.blackColor[n3] = node.blackColor[n3] ^ this.blackColor[n];
            int n4 = n;
            this.blackColor[n4] = this.blackColor[n4] ^ node.blackColor[n];
        }

        private boolean isBlack(int n) {
            return this.blackColor[n];
        }

        private boolean isRed(int n) {
            return !this.blackColor[n];
        }

        private void setBlack(int n) {
            this.blackColor[n] = true;
        }

        private void setRed(int n) {
            this.blackColor[n] = false;
        }

        private void copyColor(Node node, int n) {
            this.blackColor[n] = node.blackColor[n];
        }

        public Object getKey() {
            return this.data[0];
        }

        public Object getValue() {
            return this.data[1];
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.data[0].equals(entry.getKey()) && this.data[1].equals(entry.getValue());
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }

        static Comparable access$200(Node node, int n) {
            return node.getData(n);
        }

        static Node access$700(Node node, int n) {
            return node.getLeft(n);
        }

        static Node access$800(Node node, int n) {
            return node.getRight(n);
        }

        static Node access$900(Node node, int n) {
            return node.getParent(n);
        }

        static void access$1000(Node node, int n) {
            node.setBlack(n);
        }

        static void access$1100(Node node, Node node2, int n) {
            node.copyColor(node2, n);
        }

        static boolean access$1200(Node node, int n) {
            return node.isRed(n);
        }

        static boolean access$1300(Node node, int n) {
            return node.isBlack(n);
        }

        static void access$1400(Node node, int n) {
            node.setRed(n);
        }

        static void access$1500(Node node, Node node2, int n) {
            node.setRight(node2, n);
        }

        static void access$1600(Node node, Node node2, int n) {
            node.setParent(node2, n);
        }

        static void access$1700(Node node, Node node2, int n) {
            node.setLeft(node2, n);
        }

        static void access$1800(Node node, Node node2, int n) {
            node.swapColors(node2, n);
        }
    }

    private abstract class DoubleOrderedMapIterator
    implements Iterator {
        private int expectedModifications;
        protected Node lastReturnedNode;
        private Node nextNode;
        private int iteratorType;
        private final DoubleOrderedMap this$0;

        DoubleOrderedMapIterator(DoubleOrderedMap doubleOrderedMap, int n) {
            this.this$0 = doubleOrderedMap;
            this.iteratorType = n;
            this.expectedModifications = DoubleOrderedMap.access$2200(doubleOrderedMap);
            this.lastReturnedNode = null;
            this.nextNode = DoubleOrderedMap.access$2400(DoubleOrderedMap.access$2300(doubleOrderedMap)[this.iteratorType], this.iteratorType);
        }

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (DoubleOrderedMap.access$2200(this.this$0) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.nextNode = DoubleOrderedMap.access$2500(this.this$0, this.nextNode, this.iteratorType);
            return this.doGetNext();
        }

        public final void remove() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (DoubleOrderedMap.access$2200(this.this$0) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            DoubleOrderedMap.access$300(this.this$0, this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
        }
    }
}

