/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.HashBag;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.set.UnmodifiableSet;

public abstract class DefaultMapBag
implements Bag {
    private Map _map = null;
    private int _total = 0;
    private int _mods = 0;

    public DefaultMapBag() {
    }

    protected DefaultMapBag(Map map) {
        this.setMap(map);
    }

    public boolean add(Object object) {
        return this.add(object, 1);
    }

    public boolean add(Object object, int n) {
        ++this._mods;
        if (n > 0) {
            int n2 = n + this.getCount(object);
            this._map.put(object, new Integer(n2));
            this._total += n;
            return n2 == n;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = this.add(iterator.next());
            bl = bl || bl2;
        }
        return bl;
    }

    public void clear() {
        ++this._mods;
        this._map.clear();
        this._total = 0;
    }

    public boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    public boolean containsAll(Collection collection) {
        return this.containsAll(new HashBag(collection));
    }

    public boolean containsAll(Bag bag) {
        boolean bl = true;
        Iterator iterator = bag.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl2 = this.getCount(e) >= bag.getCount(e);
            bl = bl && bl2;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)object;
        if (bag.size() != this.size()) {
            return false;
        }
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (bag.getCount(k) == this.getCount(k)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this._map).hashCode();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Iterator iterator() {
        return new BagIterator(this, this.extractList().iterator());
    }

    public boolean remove(Object object) {
        return this.remove(object, this.getCount(object));
    }

    public boolean remove(Object object, int n) {
        ++this._mods;
        boolean bl = false;
        int n2 = this.getCount(object);
        if (n <= 0) {
            bl = false;
        } else if (n2 > n) {
            this._map.put(object, new Integer(n2 - n));
            bl = true;
            this._total -= n;
        } else {
            bl = this._map.remove(object) != null;
            this._total -= n2;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = this.remove(iterator.next(), 1);
                bl = bl || bl2;
            }
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        return this.retainAll(new HashBag(collection));
    }

    public boolean retainAll(Bag bag) {
        boolean bl = false;
        HashBag hashBag = new HashBag();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.getCount(e);
            int n2 = bag.getCount(e);
            if (1 <= n2 && n2 <= n) {
                hashBag.add(e, n - n2);
                continue;
            }
            hashBag.add(e, n);
        }
        if (!hashBag.isEmpty()) {
            bl = this.removeAll((Collection)hashBag);
        }
        return bl;
    }

    public Object[] toArray() {
        return this.extractList().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.extractList().toArray(objectArray);
    }

    public int getCount(Object object) {
        int n = 0;
        Integer n2 = MapUtils.getInteger(this._map, object);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public Set uniqueSet() {
        return UnmodifiableSet.decorate(this._map.keySet());
    }

    public int size() {
        return this._total;
    }

    protected int calcTotalSize() {
        this._total = this.extractList().size();
        return this._total;
    }

    protected void setMap(Map map) {
        if (map == null || !map.isEmpty()) {
            throw new IllegalArgumentException("The map must be non-null and empty");
        }
        this._map = map;
    }

    protected Map getMap() {
        return this._map;
    }

    private List extractList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            for (int i = this.getCount(e); i > 0; --i) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    private int modCount() {
        return this._mods;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.getCount(e);
            stringBuffer.append(n);
            stringBuffer.append(":");
            stringBuffer.append(e);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static int access$000(DefaultMapBag defaultMapBag) {
        return defaultMapBag.modCount();
    }

    static class BagIterator
    implements Iterator {
        private DefaultMapBag _parent = null;
        private Iterator _support = null;
        private Object _current = null;
        private int _mods = 0;

        public BagIterator(DefaultMapBag defaultMapBag, Iterator iterator) {
            this._parent = defaultMapBag;
            this._support = iterator;
            this._current = null;
            this._mods = DefaultMapBag.access$000(defaultMapBag);
        }

        public boolean hasNext() {
            return this._support.hasNext();
        }

        public Object next() {
            if (DefaultMapBag.access$000(this._parent) != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._current = this._support.next();
            return this._current;
        }

        public void remove() {
            if (DefaultMapBag.access$000(this._parent) != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._support.remove();
            this._parent.remove(this._current, 1);
            ++this._mods;
        }
    }
}

