/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.PredicatedCollection;
import org.apache.commons.collections.collection.SynchronizedCollection;
import org.apache.commons.collections.collection.TransformedCollection;
import org.apache.commons.collections.collection.TypedCollection;
import org.apache.commons.collections.collection.UnmodifiableBoundedCollection;
import org.apache.commons.collections.collection.UnmodifiableCollection;

public class CollectionUtils {
    private static Integer INTEGER_ONE = new Integer(1);
    public static final Collection EMPTY_COLLECTION = UnmodifiableCollection.decorate(new ArrayList());

    public static Collection union(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = Math.max(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            for (int i = 0; i < n; ++i) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = Math.min(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            for (int i = 0; i < n; ++i) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public static Collection disjunction(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = Math.max(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2)) - Math.min(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            for (int i = 0; i < n; ++i) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public static Collection subtract(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        return arrayList;
    }

    public static boolean containsAny(Collection collection, Collection collection2) {
        if (collection.size() < collection2.size()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!collection2.contains(iterator.next())) continue;
                return true;
            }
        } else {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map getCardinalityMap(Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Integer n = (Integer)hashMap.get(e);
            if (n == null) {
                hashMap.put(e, INTEGER_ONE);
                continue;
            }
            hashMap.put(e, new Integer(n + 1));
        }
        return hashMap;
    }

    public static boolean isSubCollection(Collection collection, Collection collection2) {
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (CollectionUtils.getFreq(e, map) <= CollectionUtils.getFreq(e, map2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection collection, Collection collection2) {
        return collection.size() < collection2.size() && CollectionUtils.isSubCollection(collection, collection2);
    }

    public static boolean isEqualCollection(Collection collection, Collection collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (CollectionUtils.getFreq(k, map) == CollectionUtils.getFreq(k, map2)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object object, Collection collection) {
        if (collection instanceof Set) {
            return collection.contains(object) ? 1 : 0;
        }
        if (collection instanceof Bag) {
            return ((Bag)collection).getCount(object);
        }
        int n = 0;
        if (object == null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                ++n;
            }
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                ++n;
            }
        }
        return n;
    }

    public static Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!predicate.evaluate(e)) continue;
                return e;
            }
        }
        return null;
    }

    public static void forAllDo(Collection collection, Closure closure) {
        if (collection != null && closure != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                closure.execute(iterator.next());
            }
        }
    }

    public static void filter(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (predicate.evaluate(iterator.next())) continue;
                iterator.remove();
            }
        }
    }

    public static void transform(Collection collection, Transformer transformer) {
        if (collection != null && transformer != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                ListIterator<Object> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    listIterator.set(transformer.transform(listIterator.next()));
                }
            } else {
                Collection collection2 = CollectionUtils.collect(collection, transformer);
                collection.clear();
                collection.addAll(collection2);
            }
        }
    }

    public static int countMatches(Collection collection, Predicate predicate) {
        int n = 0;
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!predicate.evaluate(iterator.next())) continue;
                ++n;
            }
        }
        return n;
    }

    public static boolean exists(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!predicate.evaluate(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection select(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.select(collection, predicate, arrayList);
        return arrayList;
    }

    public static void select(Collection collection, Predicate predicate, Collection collection2) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!predicate.evaluate(e)) continue;
                collection2.add(e);
            }
        }
    }

    public static Collection selectRejected(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.selectRejected(collection, predicate, arrayList);
        return arrayList;
    }

    public static void selectRejected(Collection collection, Predicate predicate, Collection collection2) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (predicate.evaluate(e)) continue;
                collection2.add(e);
            }
        }
    }

    public static Collection collect(Collection collection, Transformer transformer) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.collect(collection, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Iterator iterator, Transformer transformer) {
        ArrayList arrayList = new ArrayList();
        CollectionUtils.collect(iterator, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Collection collection, Transformer transformer, Collection collection2) {
        if (collection != null) {
            return CollectionUtils.collect(collection.iterator(), transformer, collection2);
        }
        return collection2;
    }

    public static Collection collect(Iterator iterator, Transformer transformer, Collection collection) {
        if (iterator != null && transformer != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object object = transformer.transform(e);
                collection.add(object);
            }
        }
        return collection;
    }

    public static boolean addIgnoreNull(Collection collection, Object object) {
        return object == null ? false : collection.add(object);
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection, Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            collection.add(objectArray[i]);
        }
    }

    public static Object index(Object object, int n) {
        return CollectionUtils.index(object, new Integer(n));
    }

    public static Object index(Object object, Object object2) {
        Map map;
        if (object instanceof Map && (map = (Map)object).containsKey(object2)) {
            return map.get(object2);
        }
        int n = -1;
        if (object2 instanceof Integer) {
            n = (Integer)object2;
        }
        if (n < 0) {
            return object;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            Iterator iterator = map2.keySet().iterator();
            return CollectionUtils.index(iterator, n);
        }
        if (object instanceof List) {
            return ((List)object).get(n);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[n];
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                if (--n == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
        } else {
            if (object instanceof Iterator) {
                return CollectionUtils.index((Iterator)object, n);
            }
            if (object instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                return CollectionUtils.index(iterator, n);
            }
        }
        return object;
    }

    private static Object index(Iterator iterator, int n) {
        while (iterator.hasNext()) {
            if (--n == -1) {
                return iterator.next();
            }
            iterator.next();
        }
        return iterator;
    }

    public static Object get(Object object, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + n);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return CollectionUtils.get(iterator, n);
        }
        if (object instanceof List) {
            return ((List)object).get(n);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[n];
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (--n == -1) {
                    return iterator.next();
                }
                iterator.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + n);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return CollectionUtils.get(iterator, n);
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                if (--n == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + n);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static int size(Object object) {
        int n = 0;
        if (object instanceof Map) {
            n = ((Map)object).size();
        } else if (object instanceof Collection) {
            n = ((Collection)object).size();
        } else if (object instanceof Object[]) {
            n = ((Object[])object).length;
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Unsupported object type: null");
            }
            try {
                n = Array.getLength(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
            }
        }
        return n;
    }

    public static boolean sizeIsEmpty(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Iterator) {
            return !((Iterator)object).hasNext();
        }
        if (object instanceof Enumeration) {
            return !((Enumeration)object).hasMoreElements();
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.getLength(object) == 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static void reverseArray(Object[] objectArray) {
        int n = 0;
        for (int i = objectArray.length - 1; i > n; --i, ++n) {
            Object object = objectArray[i];
            objectArray[i] = objectArray[n];
            objectArray[n] = object;
        }
    }

    private static final int getFreq(Object object, Map map) {
        Integer n = (Integer)map.get(object);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static boolean isFull(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (collection instanceof BoundedCollection) {
            return ((BoundedCollection)collection).isFull();
        }
        try {
            BoundedCollection boundedCollection = UnmodifiableBoundedCollection.decorateUsing(collection);
            return boundedCollection.isFull();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static int maxSize(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (collection instanceof BoundedCollection) {
            return ((BoundedCollection)collection).maxSize();
        }
        try {
            BoundedCollection boundedCollection = UnmodifiableBoundedCollection.decorateUsing(collection);
            return boundedCollection.maxSize();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    public static Collection retainAll(Collection collection, Collection collection2) {
        return ListUtils.retainAll(collection, collection2);
    }

    public static Collection removeAll(Collection collection, Collection collection2) {
        return ListUtils.retainAll(collection, collection2);
    }

    public static Collection synchronizedCollection(Collection collection) {
        return SynchronizedCollection.decorate(collection);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return UnmodifiableCollection.decorate(collection);
    }

    public static Collection predicatedCollection(Collection collection, Predicate predicate) {
        return PredicatedCollection.decorate(collection, predicate);
    }

    public static Collection typedCollection(Collection collection, Class clazz) {
        return TypedCollection.decorate(collection, clazz);
    }

    public static Collection transformedCollection(Collection collection, Transformer transformer) {
        return TransformedCollection.decorate(collection, transformer);
    }
}

