/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ChainedClosure;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.ExceptionClosure;
import org.apache.commons.collections.functors.ForClosure;
import org.apache.commons.collections.functors.IfClosure;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.apache.commons.collections.functors.NOPClosure;
import org.apache.commons.collections.functors.SwitchClosure;
import org.apache.commons.collections.functors.TransformerClosure;
import org.apache.commons.collections.functors.WhileClosure;

public class ClosureUtils {
    public static Closure exceptionClosure() {
        return ExceptionClosure.INSTANCE;
    }

    public static Closure nopClosure() {
        return NOPClosure.INSTANCE;
    }

    public static Closure asClosure(Transformer transformer) {
        return TransformerClosure.getInstance(transformer);
    }

    public static Closure forClosure(int n, Closure closure) {
        return ForClosure.getInstance(n, closure);
    }

    public static Closure whileClosure(Predicate predicate, Closure closure) {
        return WhileClosure.getInstance(predicate, closure, false);
    }

    public static Closure doWhileClosure(Closure closure, Predicate predicate) {
        return WhileClosure.getInstance(predicate, closure, true);
    }

    public static Closure invokerClosure(String string) {
        return ClosureUtils.asClosure(InvokerTransformer.getInstance(string));
    }

    public static Closure invokerClosure(String string, Class[] classArray, Object[] objectArray) {
        return ClosureUtils.asClosure(InvokerTransformer.getInstance(string, classArray, objectArray));
    }

    public static Closure chainedClosure(Closure closure, Closure closure2) {
        return ChainedClosure.getInstance(closure, closure2);
    }

    public static Closure chainedClosure(Closure[] closureArray) {
        return ChainedClosure.getInstance(closureArray);
    }

    public static Closure chainedClosure(Collection collection) {
        return ChainedClosure.getInstance(collection);
    }

    public static Closure ifClosure(Predicate predicate, Closure closure) {
        return IfClosure.getInstance(predicate, closure);
    }

    public static Closure ifClosure(Predicate predicate, Closure closure, Closure closure2) {
        return IfClosure.getInstance(predicate, closure, closure2);
    }

    public static Closure switchClosure(Predicate[] predicateArray, Closure[] closureArray) {
        return SwitchClosure.getInstance(predicateArray, closureArray, null);
    }

    public static Closure switchClosure(Predicate[] predicateArray, Closure[] closureArray, Closure closure) {
        return SwitchClosure.getInstance(predicateArray, closureArray, closure);
    }

    public static Closure switchClosure(Map map) {
        return SwitchClosure.getInstance(map);
    }

    public static Closure switchMapClosure(Map map) {
        Closure[] closureArray = null;
        Predicate[] predicateArray = null;
        if (map == null) {
            throw new IllegalArgumentException("The object and closure map must not be null");
        }
        Closure closure = (Closure)map.remove(null);
        int n = map.size();
        closureArray = new Closure[n];
        predicateArray = new Predicate[n];
        int n2 = 0;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            predicateArray[n2] = EqualPredicate.getInstance(entry.getKey());
            closureArray[n2] = (Closure)entry.getValue();
            ++n2;
        }
        return ClosureUtils.switchClosure(predicateArray, closureArray, closure);
    }
}

