/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferOverflowException;
import org.apache.commons.collections.BufferUnderflowException;

public class BoundedFifoBuffer
extends AbstractCollection
implements BoundedCollection,
Buffer {
    private final Object[] m_elements;
    private int m_start = 0;
    private int m_end = 0;
    private boolean m_full = false;
    private final int maxElements;

    public BoundedFifoBuffer() {
        this(32);
    }

    public BoundedFifoBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.m_elements = new Object[n];
        this.maxElements = this.m_elements.length;
    }

    public BoundedFifoBuffer(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public int size() {
        int n = 0;
        n = this.m_end < this.m_start ? this.maxElements - this.m_start + this.m_end : (this.m_end == this.m_start ? (this.m_full ? this.maxElements : 0) : this.m_end - this.m_start);
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.size() == this.maxElements;
    }

    public int maxSize() {
        return this.maxElements;
    }

    public void clear() {
        this.m_full = false;
        this.m_start = 0;
        this.m_end = 0;
        Arrays.fill(this.m_elements, null);
    }

    public boolean add(Object object) {
        if (null == object) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.m_full) {
            throw new BufferOverflowException("The buffer cannot hold more than " + this.maxElements + " objects.");
        }
        this.m_elements[this.m_end++] = object;
        if (this.m_end >= this.maxElements) {
            this.m_end = 0;
        }
        if (this.m_end == this.m_start) {
            this.m_full = true;
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.m_elements[this.m_start];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.m_elements[this.m_start];
        if (null != object) {
            this.m_elements[this.m_start++] = null;
            if (this.m_start >= this.maxElements) {
                this.m_start = 0;
            }
            this.m_full = false;
        }
        return object;
    }

    private int increment(int n) {
        if (++n >= this.maxElements) {
            n = 0;
        }
        return n;
    }

    private int decrement(int n) {
        if (--n < 0) {
            n = this.maxElements - 1;
        }
        return n;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private int index;
            private int lastReturnedIndex;
            private boolean isFirst;
            private final BoundedFifoBuffer this$0;
            {
                this.this$0 = boundedFifoBuffer;
                this.index = BoundedFifoBuffer.access$000(this.this$0);
                this.lastReturnedIndex = -1;
                this.isFirst = BoundedFifoBuffer.access$100(this.this$0);
            }

            public boolean hasNext() {
                return this.isFirst || this.index != BoundedFifoBuffer.access$200(this.this$0);
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isFirst = false;
                this.lastReturnedIndex = this.index;
                this.index = BoundedFifoBuffer.access$300(this.this$0, this.index);
                return BoundedFifoBuffer.access$400(this.this$0)[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == BoundedFifoBuffer.access$000(this.this$0)) {
                    this.this$0.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n = this.lastReturnedIndex + 1;
                while (n != BoundedFifoBuffer.access$200(this.this$0)) {
                    if (n >= BoundedFifoBuffer.access$500(this.this$0)) {
                        BoundedFifoBuffer.access$400((BoundedFifoBuffer)this.this$0)[n - 1] = BoundedFifoBuffer.access$400(this.this$0)[0];
                        n = 0;
                        continue;
                    }
                    BoundedFifoBuffer.access$400((BoundedFifoBuffer)this.this$0)[n - 1] = BoundedFifoBuffer.access$400(this.this$0)[n];
                    ++n;
                }
                this.lastReturnedIndex = -1;
                BoundedFifoBuffer.access$202(this.this$0, BoundedFifoBuffer.access$600(this.this$0, BoundedFifoBuffer.access$200(this.this$0)));
                BoundedFifoBuffer.access$400((BoundedFifoBuffer)this.this$0)[BoundedFifoBuffer.access$200((BoundedFifoBuffer)this.this$0)] = null;
                BoundedFifoBuffer.access$102(this.this$0, false);
                this.index = BoundedFifoBuffer.access$600(this.this$0, this.index);
            }
        };
    }

    static int access$000(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_start;
    }

    static boolean access$100(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_full;
    }

    static int access$200(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_end;
    }

    static int access$300(BoundedFifoBuffer boundedFifoBuffer, int n) {
        return boundedFifoBuffer.increment(n);
    }

    static Object[] access$400(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_elements;
    }

    static int access$500(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.maxElements;
    }

    static int access$202(BoundedFifoBuffer boundedFifoBuffer, int n) {
        boundedFifoBuffer.m_end = n;
        return boundedFifoBuffer.m_end;
    }

    static int access$600(BoundedFifoBuffer boundedFifoBuffer, int n) {
        return boundedFifoBuffer.decrement(n);
    }

    static boolean access$102(BoundedFifoBuffer boundedFifoBuffer, boolean bl) {
        boundedFifoBuffer.m_full = bl;
        return boundedFifoBuffer.m_full;
    }
}

