/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.EmptyStackException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class ArrayStack
extends ArrayList
implements Buffer {
    private static final long serialVersionUID = 2130079159931574599L;

    public ArrayStack() {
    }

    public ArrayStack(int n) {
        super(n);
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public Object peek() {
        int n = this.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        return this.get(n - 1);
    }

    public Object peek(int n) {
        int n2 = this.size() - n - 1;
        if (n2 < 0) {
            throw new EmptyStackException();
        }
        return this.get(n2);
    }

    public Object pop() {
        int n = this.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        return this.remove(n - 1);
    }

    public Object push(Object object) {
        this.add(object);
        return object;
    }

    public int search(Object object) {
        int n = this.size() - 1;
        int n2 = 1;
        while (n >= 0) {
            Object e = this.get(n);
            if (object == null && e == null || object != null && object.equals(e)) {
                return n2;
            }
            --n;
            ++n2;
        }
        return -1;
    }

    public Object get() {
        int n = this.size();
        if (n == 0) {
            throw new BufferUnderflowException();
        }
        return this.get(n - 1);
    }

    public Object remove() {
        int n = this.size();
        if (n == 0) {
            throw new BufferUnderflowException();
        }
        return this.remove(n - 1);
    }
}

